/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.codeActions;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolution;
import org.eclipse.xtext.ide.editor.quickfix.IQuickFixProvider;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

@Beta
public class QuickFixCodeActionService
implements ICodeActionService2 {
    @Inject
    private IQuickFixProvider quickfixes;

    @Override
    public List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options) {
        boolean handleQuickfixes;
        boolean bl = handleQuickfixes = options.getCodeActionParams().getContext().getOnly() == null || options.getCodeActionParams().getContext().getOnly().isEmpty() || options.getCodeActionParams().getContext().getOnly().contains("quickfix");
        if (!handleQuickfixes) {
            return Collections.emptyList();
        }
        ArrayList<Either<Command, CodeAction>> result = new ArrayList<Either<Command, CodeAction>>();
        for (Diagnostic diagnostic : options.getCodeActionParams().getContext().getDiagnostics()) {
            if (!this.handlesDiagnostic(diagnostic)) continue;
            result.addAll(options.getLanguageServerAccess().doSyncRead(options.getURI(), context -> {
                options.setDocument(context.getDocument());
                options.setResource(context.getResource());
                return this.getCodeActions(options, diagnostic);
            }));
        }
        return result;
    }

    protected boolean handlesDiagnostic(Diagnostic diagnostic) {
        return this.quickfixes.handlesDiagnostic(diagnostic);
    }

    protected List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options, Diagnostic diagnostic) {
        ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
        this.quickfixes.getResolutions(options, diagnostic).stream().sorted(Comparator.nullsLast(Comparator.comparing(DiagnosticResolution::getLabel))).forEach(r -> {
            boolean bl = codeActions.add(Either.forRight((Object)this.createFix((DiagnosticResolution)r, diagnostic)));
        });
        return codeActions;
    }

    private CodeAction createFix(DiagnosticResolution resolution, Diagnostic diagnostic) {
        CodeAction codeAction = new CodeAction();
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setTitle(resolution.getLabel());
        codeAction.setEdit(resolution.apply());
        codeAction.setKind("quickfix");
        return codeAction;
    }
}

