/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.builder.standalone.incremental.ExtendedEObjectInputStream;
import org.eclipse.xtext.builder.standalone.incremental.ExtendedEObjectOutputStream;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

class StandaloneBuilderState {
    private static final Logger LOG = Logger.getLogger(StandaloneBuilder.class);
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);
    private static final int SERIALIZATION_VERSION = 1;
    private static final int HASH_CODE = 0;
    private static final int PATH = 1;
    private static final int PATHS = 2;
    private static final int URI = 3;
    HashCode libraryPathHash;
    final ResourceDescriptionsData index;
    final Map<URI, HashCode> sourceFiles = new HashMap<URI, HashCode>();
    final Map<URI, HashCode> libraryFiles = new HashMap<URI, HashCode>();
    final Map<IPath, HashCode> outputFiles = new HashMap<IPath, HashCode>();
    final Map<URI, IPath[]> inputToOutputFiles = new HashMap<URI, IPath[]>();
    final Map<IPath, URI> outputToInputFile = new HashMap<IPath, URI>();
    final Map<IPath, HashCode> stubFiles = new HashMap<IPath, HashCode>();
    final Map<URI, IPath[]> inputToStubFiles = new HashMap<URI, IPath[]>();
    final Map<IPath, URI> stubToInputFile = new HashMap<IPath, URI>();
    final Multimap<URI, Issue> issues = TreeMultimap.create(Comparator.comparing(Object::toString), Comparator.comparingInt(Issue::getLineNumber).thenComparingInt(Issue::getColumn).thenComparing(Issue::getMessage).thenComparing(Object::hashCode));
    private static final Severity[] severities = Severity.values();
    private static final CheckType[] checkTypes = CheckType.values();

    StandaloneBuilderState() {
        this.index = new ResourceDescriptionsData(new ArrayList());
    }

    boolean updateLibraryHash(HashCode libraryPathHash) {
        if (libraryPathHash.equals((Object)this.libraryPathHash)) {
            return false;
        }
        this.libraryPathHash = libraryPathHash;
        return true;
    }

    void processOutputDirectories(Set<String> outputFolders) {
        HashMap<IPath, HashCode> currentOutputFiles = new HashMap<IPath, HashCode>();
        for (String directory : outputFolders) {
            BinaryFileHashing.processDirectory(directory, currentOutputFiles, null);
        }
        this.syncOutputFiles(this.outputFiles, currentOutputFiles);
    }

    void processStubDirectory(String stubDirectory) {
        HashMap<IPath, HashCode> currentStubFiles = new HashMap<IPath, HashCode>();
        BinaryFileHashing.processDirectory(stubDirectory, currentStubFiles, ".java");
        this.syncOutputFiles(this.stubFiles, currentStubFiles);
    }

    private void syncOutputFiles(Map<IPath, HashCode> originalFiles, Map<IPath, HashCode> newFiles) {
        MapDifference difference = Maps.difference(originalFiles, newFiles);
        for (IPath missing : difference.entriesOnlyOnLeft().keySet()) {
            this.discardOutputAndStubData(this.outputToInputFile.remove(missing));
            this.discardOutputAndStubData(this.stubToInputFile.remove(missing));
        }
        for (IPath different : difference.entriesDiffering().keySet()) {
            this.discardOutputAndStubData(this.outputToInputFile.remove(different));
            this.discardOutputAndStubData(this.stubToInputFile.remove(different));
        }
    }

    private void discardOutputAndStubData(URI inputFile) {
        if (inputFile != null && this.sourceFiles.put(inputFile, null) != null) {
            IPath[] stubFiles;
            int n;
            IPath[] outputFiles = this.inputToOutputFiles.remove(inputFile);
            if (outputFiles != null) {
                IPath[] iPathArray = outputFiles;
                n = outputFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath outputFile = iPathArray[n2];
                    outputFile.toFile().delete();
                    this.outputToInputFile.remove(outputFile);
                    this.outputFiles.remove(outputFile);
                    ++n2;
                }
            }
            if ((stubFiles = this.inputToStubFiles.remove(inputFile)) != null) {
                IPath[] iPathArray = stubFiles;
                int n3 = stubFiles.length;
                n = 0;
                while (n < n3) {
                    IPath stubFile = iPathArray[n];
                    stubFile.toFile().delete();
                    this.stubToInputFile.remove(stubFile);
                    this.stubFiles.remove(stubFile);
                    ++n;
                }
            }
        }
    }

    IResourceDescription.Event sourceChanges(List<URI> resourceURIs, Collection<URI> newResources) {
        HashMap<URI, HashCode> newSourceFiles = new HashMap<URI, HashCode>();
        for (URI sourceResource : resourceURIs) {
            newSourceFiles.put(sourceResource, this.hash(sourceResource));
        }
        return this.diffDslResources(this.sourceFiles, newSourceFiles, newResources);
    }

    IResourceDescription.Event libraryChanges(List<URI> resourceURIs, Collection<URI> newResources) {
        HashMap<URI, HashCode> newBinaryFiles = new HashMap<URI, HashCode>();
        for (URI binaryResource : resourceURIs) {
            newBinaryFiles.put(binaryResource, this.hash(binaryResource));
        }
        return this.diffDslResources(this.libraryFiles, newBinaryFiles, newResources);
    }

    private IResourceDescription.Event diffDslResources(Map<URI, HashCode> originalFiles, Map<URI, HashCode> newFiles, Collection<URI> accumulator) {
        MapDifference difference = Maps.difference(originalFiles, newFiles);
        ArrayList<DefaultResourceDescriptionDelta> deltas = new ArrayList<DefaultResourceDescriptionDelta>();
        for (URI removed : difference.entriesOnlyOnLeft().keySet()) {
            IResourceDescription oldDescription = this.index.getResourceDescription(removed);
            if (oldDescription != null) {
                deltas.add(new DefaultResourceDescriptionDelta(oldDescription, null));
                this.index.removeDescription(removed);
            }
            this.issues.removeAll((Object)removed);
            this.processRemovedFiles(removed, this.inputToOutputFiles, this.outputToInputFile, this.outputFiles);
            this.processRemovedFiles(removed, this.inputToStubFiles, this.stubToInputFile, this.stubFiles);
        }
        accumulator.addAll(difference.entriesOnlyOnRight().keySet());
        accumulator.addAll(difference.entriesDiffering().keySet());
        originalFiles.clear();
        originalFiles.putAll(newFiles);
        return new ResourceDescriptionChangeEvent(deltas);
    }

    private void processRemovedFiles(URI removed, Map<URI, IPath[]> inputToOutput, Map<IPath, URI> outputToInput, Map<IPath, HashCode> outputHashes) {
        IPath[] outputFiles = inputToOutput.remove(removed);
        if (outputFiles != null) {
            IPath[] iPathArray = outputFiles;
            int n = outputFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IPath outputFile = iPathArray[n2];
                outputFile.toFile().delete();
                outputToInput.remove(outputFile);
                outputHashes.remove(outputFile);
                ++n2;
            }
        }
    }

    private HashCode hash(URI resource) {
        Hasher hasher = this.newHasher();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream hasherAsStream = Funnels.asOutputStream((PrimitiveSink)hasher);){
                try {
                    Throwable throwable2 = null;
                    Object var7_12 = null;
                    try (BufferedInputStream in = new BufferedInputStream(URIConverter.INSTANCE.createInputStream(resource), 16384);){
                        ByteStreams.copy((InputStream)in, (OutputStream)hasherAsStream);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    hasher.putBoolean(false);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasher.hash();
    }

    void setIssues(URI resource, Iterable<Issue> issues) {
        this.issues.replaceValues((Object)resource, issues);
    }

    boolean processIssues(IIssueHandler issueHandler) {
        boolean result = true;
        for (Collection issues : this.issues.asMap().values()) {
            if (issueHandler.handleIssue(issues)) continue;
            result = false;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StandaloneBuilderState from(File file) {
        StandaloneBuilderState result = new StandaloneBuilderState();
        if (file.exists()) {
            Stopwatch sw = Stopwatch.createStarted();
            boolean failed = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedInputStream buffy = new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));){
                        ExtendedEObjectInputStream in = new ExtendedEObjectInputStream(buffy, 128);
                        result.read(in);
                        return result;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    failed = true;
                    LOG.error((Object)"Failed to read compiler state.", (Throwable)e);
                    if (failed) return result;
                    LOG.trace((Object)("Read compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms."));
                }
                return result;
            }
            finally {
                if (!failed) {
                    LOG.trace((Object)("Read compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms."));
                }
            }
        } else {
            result.libraryPathHash = HashCode.fromInt((int)0);
        }
        return result;
    }

    private void read(ExtendedEObjectInputStream in) throws IOException {
        if (in.readCompressedInt() != 1) {
            this.libraryPathHash = HashCode.fromInt((int)0);
            return;
        }
        this.libraryPathHash = in.readHashCode();
        this.readResourceDescriptions(in);
        this.readMap(in, this.sourceFiles, 3, URI.class, 0, HashCode.class);
        this.readMap(in, this.libraryFiles, 3, URI.class, 0, HashCode.class);
        this.readMap(in, this.outputFiles, 1, IPath.class, 0, HashCode.class);
        this.readMap(in, this.inputToOutputFiles, 3, URI.class, 2, IPath[].class);
        this.readMap(in, this.outputToInputFile, 1, IPath.class, 3, URI.class);
        this.readMap(in, this.stubFiles, 1, IPath.class, 0, HashCode.class);
        this.readMap(in, this.inputToStubFiles, 3, URI.class, 2, IPath[].class);
        this.readMap(in, this.stubToInputFile, 1, IPath.class, 3, URI.class);
        this.readIssues(in);
    }

    private void readIssues(ExtendedEObjectInputStream input) throws IOException {
        int numberOfSources = input.readCompressedInt();
        while (numberOfSources > 0) {
            --numberOfSources;
            URI source = input.readURI();
            int numberOfIssues = input.readCompressedInt();
            while (numberOfIssues > 0) {
                --numberOfIssues;
                this.issues.put((Object)source, (Object)StandaloneBuilderState.readIssue(input));
            }
        }
    }

    private void readResourceDescriptions(ExtendedEObjectInputStream input) throws IOException {
        int size = input.readCompressedInt();
        while (size > 0) {
            --size;
            SerializableResourceDescription description = input.readResourceDescription();
            this.index.addDescription(description.getURI(), (IResourceDescription)description);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void to(File file) {
        Stopwatch sw = Stopwatch.createStarted();
        boolean failed = false;
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to store compiler state.", (Throwable)e);
            return;
        }
        long uncompressedCount = 0L;
        long compressedCount = 0L;
        try {
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try {
                    CountingOutputStream baseOut = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
                    try {
                        try (CountingOutputStream countingOut = new CountingOutputStream((OutputStream)new BufferedOutputStream(new GZIPOutputStream((OutputStream)baseOut)));){
                            ExtendedEObjectOutputStream out = new ExtendedEObjectOutputStream((OutputStream)countingOut, 128);
                            out.writeCompressedInt(1);
                            out.writeHashCode(this.libraryPathHash);
                            this.writeResourceDescriptions(out);
                            this.writeMap(out, this.sourceFiles, 3, 0);
                            this.writeMap(out, this.libraryFiles, 3, 0);
                            this.writeMap(out, this.outputFiles, 1, 0);
                            this.writeMap(out, this.inputToOutputFiles, 3, 2);
                            this.writeMap(out, this.outputToInputFile, 1, 3);
                            this.writeMap(out, this.stubFiles, 1, 0);
                            this.writeMap(out, this.inputToStubFiles, 3, 2);
                            this.writeMap(out, this.stubToInputFile, 1, 3);
                            this.writeIssues(out);
                            out.flush();
                            countingOut.flush();
                            countingOut.close();
                            compressedCount = baseOut.getCount();
                            uncompressedCount = countingOut.getCount();
                        }
                        if (baseOut == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (baseOut == null) throw throwable;
                        baseOut.close();
                        throw throwable;
                    }
                    baseOut.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                failed = true;
                LOG.error((Object)"Failed to store compiler state.", (Throwable)e);
                if (failed) return;
                LOG.trace((Object)("Stored compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms (" + uncompressedCount + " bytes compressed to " + compressedCount + " bytes)."));
            }
            return;
        }
        finally {
            if (!failed) {
                LOG.trace((Object)("Stored compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms (" + uncompressedCount + " bytes compressed to " + compressedCount + " bytes)."));
            }
        }
    }

    private void writeMap(ExtendedEObjectOutputStream out, Map<?, ?> files, int keyMode, int valueMode) throws IOException {
        out.writeCompressedInt(files.size());
        block10: for (Map.Entry<?, ?> entry : files.entrySet()) {
            switch (keyMode) {
                case 3: {
                    out.writeURI((URI)entry.getKey());
                    break;
                }
                case 1: {
                    out.writePath((IPath)entry.getKey());
                }
            }
            switch (valueMode) {
                case 0: {
                    out.writeHashCode((HashCode)entry.getValue());
                    break;
                }
                case 1: {
                    out.writePath((IPath)entry.getValue());
                    break;
                }
                case 2: {
                    IPath[] pathArray = (IPath[])entry.getValue();
                    out.writeCompressedInt(pathArray.length);
                    IPath[] iPathArray = pathArray;
                    int n = pathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath path = iPathArray[n2];
                        out.writePath(path);
                        ++n2;
                    }
                    continue block10;
                }
                case 3: {
                    out.writeURI((URI)entry.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private <K, V> void readMap(ExtendedEObjectInputStream in, Map<K, V> map, int keyMode, Class<K> key, int valueMode, Class<V> value) throws IOException {
        int size = in.readCompressedInt();
        int i = 0;
        while (i < size) {
            K k;
            switch (keyMode) {
                case 3: {
                    k = key.cast(in.readURI());
                    break;
                }
                case 1: {
                    k = key.cast(in.readPath());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (valueMode) {
                case 0: {
                    map.put(k, value.cast(in.readHashCode()));
                    break;
                }
                case 1: {
                    map.put(k, value.cast(in.readPath()));
                    break;
                }
                case 2: {
                    IPath[] pathArray = new IPath[in.readCompressedInt()];
                    int j = 0;
                    while (j < pathArray.length) {
                        pathArray[j] = in.readPath();
                        ++j;
                    }
                    map.put(k, value.cast(pathArray));
                    break;
                }
                case 3: {
                    map.put(k, value.cast(in.readURI()));
                }
            }
            ++i;
        }
    }

    private void writeResourceDescriptions(ExtendedEObjectOutputStream out) throws IOException {
        out.writeCompressedInt(this.index.getAllURIs().size());
        for (IResourceDescription description : FluentIterable.from((Iterable)this.index.getAllResourceDescriptions()).toSortedList(Comparator.comparing(rd -> rd.getURI().toString()))) {
            if (description instanceof SerializableResourceDescription) {
                out.writeResourceDescription((SerializableResourceDescription)description);
                continue;
            }
            out.writeResourceDescription(SerializableResourceDescription.createCopy((IResourceDescription)description));
        }
    }

    private void writeIssues(ExtendedEObjectOutputStream out) throws IOException {
        int numberSources = this.issues.keySet().size();
        out.writeCompressedInt(numberSources);
        for (URI source : this.issues.keySet()) {
            Collection issues = this.issues.get((Object)source);
            out.writeURI(source);
            int numberIssues = issues.size();
            out.writeCompressedInt(numberIssues);
            for (Issue issue : issues) {
                StandaloneBuilderState.writeIssue(issue, out);
            }
        }
    }

    private static void writeIssue(Issue issue, ExtendedEObjectOutputStream out) throws IOException {
        out.writeCompressedInt(issue.getOffset());
        out.writeCompressedInt(issue.getLength());
        out.writeCompressedInt(issue.getColumn());
        out.writeCompressedInt(issue.getColumnEnd());
        out.writeCompressedInt(issue.getLineNumber());
        out.writeCompressedInt(issue.getLineNumberEnd());
        out.writeSegmentedString(issue.getCode());
        out.writeSegmentedString(issue.getMessage());
        URI uriToProblem = issue.getUriToProblem();
        if (uriToProblem == null) {
            out.writeURI(null, null);
        } else {
            out.writeURI(uriToProblem);
        }
        Severity severity = issue.getSeverity();
        int severityKey = severity == null ? -1 : severity.ordinal();
        out.writeCompressedInt(severityKey);
        CheckType checkType = issue.getType();
        int checkTypeKey = checkType == null ? -1 : checkType.ordinal();
        out.writeCompressedInt(checkTypeKey);
        String[] data = issue.getData();
        if (data == null) {
            out.writeCompressedInt(-1);
        } else {
            out.writeCompressedInt(data.length);
            String[] stringArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                out.writeSegmentedString(s);
                ++n2;
            }
        }
    }

    private static Issue readIssue(ExtendedEObjectInputStream in) throws IOException {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setOffset(Integer.valueOf(in.readCompressedInt()));
        issue.setLength(Integer.valueOf(in.readCompressedInt()));
        issue.setColumn(Integer.valueOf(in.readCompressedInt()));
        issue.setColumnEnd(Integer.valueOf(in.readCompressedInt()));
        issue.setLineNumber(Integer.valueOf(in.readCompressedInt()));
        issue.setLineNumberEnd(Integer.valueOf(in.readCompressedInt()));
        issue.setCode(in.readSegmentedString());
        issue.setMessage(in.readSegmentedString());
        issue.setUriToProblem(in.readURI());
        int severityKey = in.readCompressedInt();
        Severity severity = StandaloneBuilderState.severityFromKey(severityKey);
        issue.setSeverity(severity);
        int checkTypeKey = in.readCompressedInt();
        CheckType checkType = StandaloneBuilderState.checkTypeFromKey(checkTypeKey);
        issue.setType(checkType);
        int dataLength = in.readCompressedInt();
        if (dataLength >= 0) {
            String[] data = new String[dataLength];
            int i = 0;
            while (i < dataLength) {
                data[i] = in.readSegmentedString();
                ++i;
            }
            issue.setData(data);
        }
        return issue;
    }

    private static Severity severityFromKey(int severityKey) {
        switch (severityKey) {
            case -1: {
                return null;
            }
        }
        return severities[severityKey];
    }

    private static CheckType checkTypeFromKey(int checkTypeKey) {
        switch (checkTypeKey) {
            case -1: {
                return null;
            }
        }
        return checkTypes[checkTypeKey];
    }

    private Hasher newHasher() {
        return HASH_FUNCTION.newHasher();
    }
}

