/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.edit.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.databinding.internal.EMFListProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFEditListProperty
extends EMFListProperty {
    private final EditingDomain editingDomain;

    public EMFEditListProperty(EditingDomain editingDomain, EStructuralFeature eStructuralFeature) {
        super(eStructuralFeature);
        this.editingDomain = editingDomain;
    }

    protected void doSetList(Object source, List list, ListDiff diff) {
        final ListVisitorImpl visitor = new ListVisitorImpl((EObject)source, this.getFeature());
        diff.accept((ListDiffVisitor)visitor);
        this.editingDomain.getCommandStack().execute((Command)new CompoundCommand(){
            protected int index = 0;

            protected boolean prepare() {
                int size = visitor.commands.size();
                while (this.index < size) {
                    if (visitor.commands.get(this.index).canExecute()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            public void execute() {
                int size = visitor.commands.size();
                while (this.index < size) {
                    this.appendAndExecute(visitor.commands.get(this.index));
                    ++this.index;
                }
            }
        });
    }

    private class ListVisitorImpl
    extends ListDiffVisitor {
        private EObject eObj;
        private EStructuralFeature feature;
        protected final List<Command> commands = new ArrayList<Command>();

        private ListVisitorImpl(EObject eObj, EStructuralFeature feature) {
            this.eObj = eObj;
            this.feature = feature;
        }

        public void handleAdd(int index, Object element) {
            this.commands.add(AddCommand.create((EditingDomain)EMFEditListProperty.this.editingDomain, (Object)this.eObj, (Object)this.feature, (Object)element, (int)index));
        }

        public void handleMove(int oldIndex, int newIndex, Object element) {
            this.commands.add(MoveCommand.create((EditingDomain)EMFEditListProperty.this.editingDomain, (Object)this.eObj, (Object)this.feature, (Object)element, (int)newIndex));
        }

        public void handleReplace(int index, Object oldElement, Object newElement) {
            this.commands.add(ReplaceCommand.create((EditingDomain)EMFEditListProperty.this.editingDomain, (Object)this.eObj, (Object)this.feature, (Object)oldElement, Collections.singleton(newElement)));
        }

        public void handleRemove(int index, Object element) {
            this.commands.add(RemoveCommand.create((EditingDomain)EMFEditListProperty.this.editingDomain, (Object)this.eObj, (Object)this.feature, (Object)element));
        }
    }
}

