/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.anchor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.diagram.sequence.anchor.DebugFormat;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineElementTraceable;
import org.eclipse.uml2.diagram.sequence.anchor.LifelineSatisfyCondition;
import org.eclipse.uml2.diagram.sequence.anchor.PasteRange;
import org.eclipse.uml2.diagram.sequence.anchor.SDModelUtil;
import org.eclipse.uml2.diagram.sequence.anchor.UnknownElementException;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;
import org.eclipse.uml2.diagram.sequence.internal.missed.EmptyEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.missed.MissedMethods;
import org.eclipse.uml2.diagram.sequence.model.edit.SDAnchor;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracket;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracketContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDEntity;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDExecution;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrame;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInvocation;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLineElement;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDModel;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMountingRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchorProcessorInput {
    private static final LayoutPropertiesFactory ourNullFactory = new LayoutPropertiesFactory(){

        public ElementLayoutProperties createLayoutProperties(SDEntity entity, boolean topNotBottom) {
            return null;
        }
    };
    private final List<LifeLine> myLifelines;
    private final LifelineSatisfyCondition[] myCreationDestructionSatisfyConditions;
    private final LifelineElementTraceable[] myLifelineCreationTops;
    private final LifelineElementTraceable[] myLifelineDestructionBottoms;
    private final HashMap<SDLifeLineElement, LifelineImpl.BottomElement> myLifeLineElement2Bottom = new HashMap();
    private final List<SDLifeLine> myLifelinesEntities;
    private final Map<SDLifeLine, Integer> myLifelineEntity2Index;
    private final Set<SDBracket> myIgnoredElements;

    public AnchorProcessorInput(SDModel interactionEntity, Set<SDBracket> ignoreBrackets) {
        this(interactionEntity, ignoreBrackets, ourNullFactory);
    }

    public AnchorProcessorInput(SDModel interactionEntity, Set<SDBracket> ignoreBrackets, LayoutPropertiesFactory layoutPropertiesFactory) {
        FillInputSession fillInputSession;
        this.myLifelinesEntities = new ArrayList<SDLifeLine>((Collection<SDLifeLine>)interactionEntity.getLifelines());
        try {
            fillInputSession = new FillInputSession(this.myLifelinesEntities, ignoreBrackets, layoutPropertiesFactory);
        }
        catch (RuntimeException e) {
            throw new SDModelUtil.ModelProblemException("Failed to build AnchorProcessorInput, something wrong with interaction", e);
        }
        this.myLifelines = fillInputSession.getResultLifelines();
        this.myCreationDestructionSatisfyConditions = fillInputSession.createCreationDestructionSatisfyCondition();
        this.myLifelineCreationTops = fillInputSession.getLifelineCreationTops();
        this.myLifelineDestructionBottoms = fillInputSession.getLifelineDestructionBottoms();
        this.myLifelineEntity2Index = new HashMap<SDLifeLine, Integer>(this.myLifelines.size());
        int i = 0;
        while (i < this.myLifelinesEntities.size()) {
            SDLifeLine lifelineEntity = this.myLifelinesEntities.get(i);
            Integer res = this.myLifelineEntity2Index.put(lifelineEntity, new Integer(i));
            if (res != null) {
                throw new RuntimeException("One lifeline is listed twice");
            }
            ++i;
        }
        this.myIgnoredElements = ignoreBrackets;
    }

    public List<SDLifeLine> getLifeLinesEntities() {
        return this.myLifelinesEntities;
    }

    public List<LifeLine> lifeLinesList() {
        return this.myLifelines;
    }

    public LifelineSatisfyCondition[] getCreationDestructionSatisfyConditions() {
        return this.myCreationDestructionSatisfyConditions;
    }

    public LifelineSatisfyCondition[] getCreationDestructionSatisfyConditions(Set<SDLifeLine> essentialLifelines) {
        LifelineSatisfyCondition[] result = (LifelineSatisfyCondition[])this.myCreationDestructionSatisfyConditions.clone();
        int i = 0;
        while (i < result.length) {
            if (result[i] != null && !essentialLifelines.contains(this.getLifeLinesEntities().get(i))) {
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    public LifelineElementTraceable[] getLifelineCreationTops() {
        return this.myLifelineCreationTops;
    }

    public LifelineElementTraceable[] getLifelineDestructionBottoms() {
        return this.myLifelineDestructionBottoms;
    }

    public int getLifelineIndex(SDLifeLine lifelineEntity) {
        Integer index = this.myLifelineEntity2Index.get(lifelineEntity);
        if (index == null) {
            throw new RuntimeException("Cannot find lifeline in map");
        }
        return index;
    }

    public LifeLineElement getLifeLineElementBeforePoint(SDAnchor createTarget) throws UnknownElementException {
        if (createTarget.getAnchor() == null) {
            LifelineImpl.BottomElement containerBottomElement = this.getBottomElementImpl((SDLifeLineElement)createTarget.getContainer());
            if (createTarget.isAfterAnchor()) {
                return containerBottomElement.getTopElement();
            }
            return containerBottomElement.getPreviousElement();
        }
        LifelineImpl.BottomElement anchorBottomElement = this.getBottomElementImpl((SDLifeLineElement)createTarget.getAnchor());
        if (createTarget.isAfterAnchor()) {
            return anchorBottomElement;
        }
        return anchorBottomElement.getTopElement().getPreviousElement();
    }

    boolean doesInclude(PasteRange pasteRange, SDAnchor createTarget) throws UnknownElementException {
        int beforeTargetPos;
        LifelineImpl lifelineImpl = (LifelineImpl)pasteRange.getRangeLowerElement().getLifeLine();
        if (createTarget.getAnchor() == null) {
            LifelineImpl.BottomElement bottomElement = this.getBottomElementSecure((SDLifeLineElement)createTarget.getContainer(), lifelineImpl);
            beforeTargetPos = createTarget.isAfterAnchor() ? bottomElement.getTopElement().getNumber() : bottomElement.getNumber() - 1;
        } else {
            LifelineImpl.BottomElement anchorBottomElement = this.getBottomElementSecure((SDLifeLineElement)createTarget.getAnchor(), lifelineImpl);
            beforeTargetPos = createTarget.isAfterAnchor() ? anchorBottomElement.getNumber() : anchorBottomElement.getTopElement().getNumber() - 1;
        }
        LifelineImpl.BoundaryElement rangeUpperElement = (LifelineImpl.BoundaryElement)pasteRange.getRangeUpperElement();
        LifelineImpl.BoundaryElement rangeLowerElement = (LifelineImpl.BoundaryElement)pasteRange.getRangeLowerElement();
        return rangeUpperElement.getNumber() <= beforeTargetPos && beforeTargetPos < rangeLowerElement.getNumber();
    }

    boolean doesInclude(PasteRange pasteRange, SDLifeLineElement entity) throws UnknownElementException {
        LifelineImpl.BoundaryElement upperRangeElement = (LifelineImpl.BoundaryElement)pasteRange.getRangeUpperElement();
        LifelineImpl.BoundaryElement lowerRangeElement = (LifelineImpl.BoundaryElement)pasteRange.getRangeLowerElement();
        LifelineImpl.BottomElement bottomEntityElement = this.getBottomElementSecure(entity, upperRangeElement.getLifelineImpl());
        LifelineImpl.TopElement topEntityElement = bottomEntityElement.getTopElement();
        return upperRangeElement.getNumber() < topEntityElement.getNumber() && lowerRangeElement.getNumber() > bottomEntityElement.getNumber();
    }

    public SDAnchor findTargetByContainer(PasteRange pasteRange, SDBracketContainer container) {
        LifelineImpl.BoundaryElement upperBoundaryElement0 = (LifelineImpl.BoundaryElement)pasteRange.getRangeUpperElement();
        LifelineImpl.BoundaryElement lowerBoundaryElement0 = (LifelineImpl.BoundaryElement)pasteRange.getRangeLowerElement();
        LifelineImpl.BoundaryElement boundaryElement = upperBoundaryElement0;
        while (boundaryElement != lowerBoundaryElement0) {
            if (boundaryElement.isTopNotBottom()) {
                if (boundaryElement.getEntity() == container) {
                    return SDAnchor.firstChildFor((SDBracketContainer)container);
                }
            } else {
                SDLifeLineElement afterTheBottomMeansParent = boundaryElement.getEntityAfterElement();
                if (afterTheBottomMeansParent == container) {
                    return new SDAnchor(container, (SDBracket)boundaryElement.getEntity(), true);
                }
            }
            boundaryElement = boundaryElement.getNextBoundaryElement();
        }
        return null;
    }

    public LifeLineElement getLifeLineElement(SDLifeLineElement entity, boolean topNotBottom, int lifelineIndex) throws UnknownElementException {
        LifelineImpl.BottomElement bottomElement = this.getBottomElementImpl(entity);
        if (this.myLifelines.get(lifelineIndex) != bottomElement.getLifeLine()) {
            throw new RuntimeException("Element found, but on wrong lifeline");
        }
        if (topNotBottom) {
            return bottomElement.getTopElement();
        }
        return bottomElement;
    }

    /*
     * Unable to fully structure code
     */
    PasteRange getLimitedRange(PasteRange pasteRange, SDEntity destinationBoundary) {
        block5: {
            block6: {
                block4: {
                    upperElement = pasteRange.getRangeUpperElement();
                    lowerElement = pasteRange.getRangeLowerElement();
                    upperBoundaryElement0 = (LifelineImpl.BoundaryElement)upperElement;
                    lowerBoundaryElement0 = (LifelineImpl.BoundaryElement)lowerElement;
                    if (destinationBoundary != null) break block4;
                    upperBoundaryElement = upperBoundaryElement0;
                    lowerBoundaryElement = lowerBoundaryElement0;
                    break block5;
                }
                boundaryElement = upperBoundaryElement0;
                if (!SDModelUtil.isNested((SDEntity)upperBoundaryElement0.getEntity(), destinationBoundary)) ** GOTO lbl17
                upperBoundaryElement = upperBoundaryElement0;
                break block6;
lbl-1000:
                // 1 sources

                {
                    if (boundaryElement == lowerBoundaryElement0) {
                        return null;
                    }
                    boundaryElement = boundaryElement.getNextBoundaryElement();
lbl17:
                    // 2 sources

                    ** while (!boundaryElement.isTopNotBottom() || boundaryElement.getEntity() != destinationBoundary)
                }
lbl18:
                // 1 sources

                upperBoundaryElement = boundaryElement;
            }
            if (!SDModelUtil.isNested((SDEntity)lowerBoundaryElement0.getEntity(), destinationBoundary)) ** GOTO lbl26
            lowerBoundaryElement = lowerBoundaryElement0;
            break block5;
lbl-1000:
            // 1 sources

            {
                if (boundaryElement == lowerBoundaryElement0) {
                    return null;
                }
                boundaryElement = boundaryElement.getNextBoundaryElement();
lbl26:
                // 2 sources

                ** while (boundaryElement.isTopNotBottom() || boundaryElement.getEntity() != destinationBoundary)
            }
lbl27:
            // 1 sources

            lowerBoundaryElement = boundaryElement;
        }
        return new PasteRange(upperBoundaryElement, lowerBoundaryElement, this);
    }

    public SDAnchor getCreateTargetAfterPoint(LifeLineElement lineElementForAnchor) {
        LifelineImpl.BoundaryElement boundaryElement = (LifelineImpl.BoundaryElement)lineElementForAnchor;
        if (boundaryElement instanceof LifelineImpl.TopElement) {
            SDLifeLineElement containerOrSimple = boundaryElement.getEntity();
            LifelineImpl.BoundaryElement nextElement = boundaryElement.getNextBoundaryElement();
            if (nextElement instanceof LifelineImpl.TopElement) {
                SDBracket anchor = (SDBracket)nextElement.getEntity();
                return new SDAnchor(anchor.getBracketContainer(), anchor, true);
            }
            if (nextElement instanceof LifelineImpl.BottomElement) {
                if (containerOrSimple instanceof SDBracketContainer) {
                    return SDAnchor.firstChildFor((SDBracketContainer)((SDBracketContainer)containerOrSimple));
                }
                SDBracket simpleBracket = (SDBracket)containerOrSimple;
                return SDAnchor.after((SDBracket)simpleBracket);
            }
            throw new RuntimeException(MessageFormat.format("Bad lifeline element {0}", nextElement));
        }
        if (boundaryElement instanceof LifelineImpl.BottomElement) {
            SDLifeLineElement anchor = boundaryElement.getEntity();
            if (anchor instanceof SDLifeLine) {
                throw new RuntimeException("There is nothing after the end of lifeline");
            }
            return SDAnchor.after((SDBracket)((SDBracket)anchor));
        }
        throw new RuntimeException(MessageFormat.format("Bad lifeline element {0}", boundaryElement));
    }

    public LifelineSatisfyCondition getAfterEntitySatisfyCondition(SDLifeLineElement entity) throws UnknownElementException {
        LifelineImpl.BottomElement bottomElement = this.getBottomElementImpl(entity);
        class AfterEntitySatisfyCondition
        implements LifelineSatisfyCondition {
            private final /* synthetic */ LifelineImpl.BottomElement val$bottomElement;

            AfterEntitySatisfyCondition(LifelineImpl.BottomElement bottomElement) {
                this.val$bottomElement = bottomElement;
            }

            public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
                if (elementTraceable.getLifeLine() != this.getLifeline()) {
                    throw new IllegalArgumentException("Unexpected lifeline");
                }
                return this.val$bottomElement.getNumber() <= elementTraceable.getNumber();
            }

            public LifeLine getLifeline() {
                return this.val$bottomElement.getLifeLine();
            }
        }
        return new AfterEntitySatisfyCondition(bottomElement);
    }

    public LifelineSatisfyCondition getNotEarlierThanTargetSatisfyCondition(SDAnchor createTarget) throws UnknownElementException {
        LifelineElementTraceable beforeTargetElement = (LifelineElementTraceable)this.getLifeLineElementBeforePoint(createTarget);
        class NotEarlierThanTargetSatisfyCondition
        implements LifelineSatisfyCondition {
            private final /* synthetic */ LifelineElementTraceable val$beforeTargetElement;

            NotEarlierThanTargetSatisfyCondition(LifelineElementTraceable lifelineElementTraceable) {
                this.val$beforeTargetElement = lifelineElementTraceable;
            }

            public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
                if (elementTraceable.getLifeLine() != this.getLifeline()) {
                    throw new IllegalArgumentException("Unexpected lifeline");
                }
                return this.val$beforeTargetElement.getNumber() <= elementTraceable.getNumber();
            }

            public String toString() {
                return MessageFormat.format("NotEarlierThanTargetSatisfyCondition for {0}", this.val$beforeTargetElement);
            }

            public LifeLine getLifeline() {
                return this.val$beforeTargetElement.getLifeLine();
            }
        }
        return new NotEarlierThanTargetSatisfyCondition(beforeTargetElement);
    }

    private LifelineImpl.BottomElement getBottomElementSecure(SDLifeLineElement lifeLineElement, LifelineImpl lifeLineImpl) throws UnknownElementException {
        LifelineImpl.BottomElement bottomEntityElement = this.getBottomElementImpl(lifeLineElement);
        if (lifeLineImpl != bottomEntityElement.getLifelineImpl()) {
            throw new RuntimeException("Entity and paste range are from different lifelines");
        }
        return bottomEntityElement;
    }

    private LifelineImpl.BottomElement getBottomElementImpl(SDLifeLineElement lifeLineElement) throws UnknownElementException {
        assert (!this.myIgnoredElements.contains(lifeLineElement));
        LifelineImpl.BottomElement bottomEntityElement = this.myLifeLineElement2Bottom.get(lifeLineElement);
        if (bottomEntityElement == null) {
            throw new UnknownElementException(MessageFormat.format("Cannot find lifeline element for entity {0}", DebugFormat.debugFormatEntity((SDEntity)lifeLineElement)));
        }
        return bottomEntityElement;
    }

    public static interface ElementLayoutProperties {
        public int getPointOffset();

        public int getSize();

        public LifeLineElement.Position getPosition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FillInputSession {
        private final List<LifeLine> myResultLifelines;
        private final ArrayList<Runnable> myResolveRunnables = new ArrayList();
        private final HashMap<SDFrame, List<SDMountingRegion>> myFrame2listOfMountingRegions = new HashMap();
        private final Set<SDBracket> myIgnoreBrackets;
        private final LayoutPropertiesFactory myLayoutPropertiesFactory;
        private LifelineCreationDestructionCollector myCreationDestructionCollector;

        FillInputSession(List<SDLifeLine> lifeLinesEntities, Set<SDBracket> ignoreBrackets, LayoutPropertiesFactory layoutPropertiesFactory) {
            this.myLayoutPropertiesFactory = layoutPropertiesFactory;
            this.myResultLifelines = new ArrayList<LifeLine>(lifeLinesEntities.size());
            this.myIgnoreBrackets = ignoreBrackets;
            ArrayList<LifelineImpl.BoundaryElement> lifeLineTopElements = new ArrayList<LifelineImpl.BoundaryElement>(lifeLinesEntities.size());
            ArrayList<LifelineImpl.BoundaryElement> lifeLineBottomElements = new ArrayList<LifelineImpl.BoundaryElement>(lifeLinesEntities.size());
            this.myCreationDestructionCollector = new LifelineCreationDestructionCollector(lifeLinesEntities.size());
            for (SDLifeLine lifeLineEntity : lifeLinesEntities) {
                LifelineImpl lifeLineImpl = new LifelineImpl(NLS.bind((String)"<Lifeline{0}>", (Object[])new Object[]{DebugFormat.debugFormatEntity((SDEntity)lifeLineEntity)}));
                LifelineImpl.BottomElement bottomElement = this.traverseLifeLine(lifeLineEntity, lifeLineImpl);
                this.myResultLifelines.add(lifeLineImpl);
                lifeLineTopElements.add(bottomElement.getTopElement());
                lifeLineBottomElements.add(bottomElement);
            }
            int i = 0;
            while (i < this.myResolveRunnables.size()) {
                Runnable runnable = this.myResolveRunnables.get(i);
                runnable.run();
                ++i;
            }
            new HorizontalConstraintImpl(lifeLineTopElements);
            new HorizontalConstraintImpl(lifeLineBottomElements);
        }

        List<LifeLine> getResultLifelines() {
            return this.myResultLifelines;
        }

        LifelineSatisfyCondition[] createCreationDestructionSatisfyCondition() {
            return this.myCreationDestructionCollector.createCreationDestructionSatisfyConditions(this.myResultLifelines);
        }

        LifelineElementTraceable[] getLifelineCreationTops() {
            return this.myCreationDestructionCollector.getLifelineCreationTops();
        }

        LifelineElementTraceable[] getLifelineDestructionBottoms() {
            return this.myCreationDestructionCollector.getLifelineDestructionBottoms();
        }

        private LifelineImpl.BottomElement traverseLifeLine(SDLifeLine lifeLine, LifelineImpl lifeLineImpl) {
            LifelineImpl.TopElement topElement = lifeLineImpl.addTopLifelineElement((SDLifeLineElement)lifeLine, this.myLayoutPropertiesFactory);
            this.myCreationDestructionCollector.startLifeline(topElement);
            this.traverseLifeLineBracketChildren(lifeLine.getBrackets().iterator(), lifeLineImpl);
            LifelineImpl.BottomElement bottomElement = lifeLineImpl.addBottomLifelineElement(topElement, this.myLayoutPropertiesFactory);
            this.myCreationDestructionCollector.finishLifeline(bottomElement);
            AnchorProcessorInput.this.myLifeLineElement2Bottom.put(lifeLine, bottomElement);
            return bottomElement;
        }

        private void traverseLifeLineElement(SDBracket lifeLineElement, LifelineImpl lifeLineImpl) {
            SDFrame combinedFragment;
            if (this.myIgnoreBrackets.contains(lifeLineElement)) {
                return;
            }
            final LifelineImpl.TopElement topElement = lifeLineImpl.addTopLifelineElement((SDLifeLineElement)lifeLineElement, this.myLayoutPropertiesFactory);
            this.myCreationDestructionCollector.startElement(topElement);
            if (lifeLineElement instanceof SDBracketContainer) {
                SDBracketContainer bracketContainer = (SDBracketContainer)lifeLineElement;
                this.traverseLifeLineBracketChildren(bracketContainer.getBrackets().iterator(), lifeLineImpl);
            }
            final LifelineImpl.BottomElement bottomElement = lifeLineImpl.addBottomLifelineElement(topElement, this.myLayoutPropertiesFactory);
            this.myCreationDestructionCollector.finishElement(bottomElement);
            AnchorProcessorInput.this.myLifeLineElement2Bottom.put(lifeLineElement, bottomElement);
            if (lifeLineElement instanceof SDInvocation) {
                final SDExecution destination = ((SDInvocation)lifeLineElement).getReceiveExecution();
                if (destination != null) {
                    if (MissedMethods._executionSpecification().isAsynchronousInvocation((SDInvocation)lifeLineElement)) {
                        this.myResolveRunnables.add(new Runnable(){

                            public void run() {
                                LifelineImpl.BottomElement executionBottomElement = (LifelineImpl.BottomElement)AnchorProcessorInput.this.myLifeLineElement2Bottom.get(destination);
                                if (executionBottomElement == null) {
                                    return;
                                }
                                LifelineImpl.TopElement executionTopElement = executionBottomElement.getTopElement();
                                if (executionTopElement.getLifeLine() == topElement.getLifeLine()) {
                                    return;
                                }
                                new OrderingConstraintImpl(topElement, executionTopElement);
                            }
                        });
                    } else {
                        this.myResolveRunnables.add(new Runnable(){

                            public void run() {
                                LifelineImpl.BottomElement executionBottomElement = (LifelineImpl.BottomElement)AnchorProcessorInput.this.myLifeLineElement2Bottom.get(destination);
                                if (executionBottomElement == null) {
                                    return;
                                }
                                LifelineImpl.TopElement executionTopElement = executionBottomElement.getTopElement();
                                if (executionTopElement.getLifeLine() == topElement.getLifeLine()) {
                                    return;
                                }
                                new HorizontalConstraintImpl(new LifelineImpl.BoundaryElement[]{bottomElement, executionBottomElement});
                                new HorizontalConstraintImpl(new LifelineImpl.BoundaryElement[]{topElement, executionTopElement});
                            }
                        });
                    }
                }
            } else if (lifeLineElement instanceof SDMountingRegion && (combinedFragment = this.findMountingRegionFrame((SDMountingRegion)lifeLineElement)) != null) {
                List<SDMountingRegion> regions = this.myFrame2listOfMountingRegions.get(combinedFragment);
                if (regions == null) {
                    final ArrayList<SDMountingRegion> createdList = new ArrayList<SDMountingRegion>(3);
                    this.myResolveRunnables.add(new Runnable(){

                        public void run() {
                            ArrayList<LifelineImpl.BoundaryElement> topLifeLineElements = new ArrayList<LifelineImpl.BoundaryElement>(createdList.size());
                            ArrayList<LifelineImpl.BoundaryElement> bottomLifeLineElements = new ArrayList<LifelineImpl.BoundaryElement>(createdList.size());
                            int i = 0;
                            while (i < createdList.size()) {
                                SDMountingRegion mountingRegion = (SDMountingRegion)createdList.get(i);
                                LifelineImpl.BottomElement mountingRegionBottomElement = (LifelineImpl.BottomElement)AnchorProcessorInput.this.myLifeLineElement2Bottom.get(mountingRegion);
                                if (mountingRegionBottomElement != null) {
                                    LifelineImpl.TopElement mountingRegionTopElement = mountingRegionBottomElement.getTopElement();
                                    topLifeLineElements.add(mountingRegionTopElement);
                                    bottomLifeLineElements.add(mountingRegionBottomElement);
                                }
                                ++i;
                            }
                            new HorizontalConstraintImpl(topLifeLineElements);
                            new HorizontalConstraintImpl(bottomLifeLineElements);
                        }
                    });
                    this.myFrame2listOfMountingRegions.put(combinedFragment, createdList);
                    regions = createdList;
                }
                regions.add((SDMountingRegion)lifeLineElement);
            }
        }

        private void traverseLifeLineBracketChildren(Iterator<SDBracket> childElements, LifelineImpl lifeLineImpl) {
            while (childElements.hasNext()) {
                SDBracket nextBracket = childElements.next();
                this.traverseLifeLineElement(nextBracket, lifeLineImpl);
            }
        }

        private SDFrame findMountingRegionFrame(SDMountingRegion mountingRegion) {
            return mountingRegion.getFrame();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HorizontalConstraintImpl
    implements HorizontalConstraint {
        private final List<LifeLineElement> myLifeLineElementsList;

        HorizontalConstraintImpl(List<LifelineImpl.BoundaryElement> boundaryElementsList) {
            this.myLifeLineElementsList = new ArrayList<LifelineImpl.BoundaryElement>(boundaryElementsList);
            for (LifelineImpl.BoundaryElement boundaryElement : boundaryElementsList) {
                boundaryElement.setHorizontalConstraint(this);
            }
        }

        HorizontalConstraintImpl(LifelineImpl.BoundaryElement[] lifeLineElements) {
            this.myLifeLineElementsList = Arrays.asList(lifeLineElements);
            int i = 0;
            while (i < lifeLineElements.length) {
                lifeLineElements[i].setHorizontalConstraint(this);
                ++i;
            }
        }

        @Override
        public List<LifeLineElement> getLifeLineElementsList() {
            return this.myLifeLineElementsList;
        }

        @Override
        public void elementIsResolved(LifeLineElement lifeLineElement) {
        }

        @Override
        public void elementIsViolated(LifeLineElement lifeLineElement) {
        }
    }

    public class InEntityCondition
    implements LifelineSatisfyCondition {
        private final LifeLine myLifeLine;
        private final NumberCondition myNumberCondition;

        public InEntityCondition(SDLifeLineElement entity, boolean isBeforeOk, boolean isInsideOk, boolean isAfterOk) throws UnknownElementException {
            LifelineImpl.BottomElement bottomElement = AnchorProcessorInput.this.getBottomElementImpl(entity);
            this.myLifeLine = bottomElement.getLifeLine();
            final int topPos = bottomElement.getTopElement().getNumber();
            final int bottomPos = bottomElement.getNumber();
            if (isInsideOk) {
                final int topPosPlus = isBeforeOk ? topPos - 1 : topPos;
                final int bottomPosPlus = isAfterOk ? bottomPos + 1 : bottomPos;
                this.myNumberCondition = new NumberCondition(){

                    boolean isSatisfied(int number) {
                        return topPosPlus <= number && number < bottomPosPlus;
                    }
                };
            } else if (isBeforeOk) {
                this.myNumberCondition = isAfterOk ? new NumberCondition(){

                    boolean isSatisfied(int number) {
                        return topPos - 1 == number || number == bottomPos;
                    }
                } : new NumberCondition(){

                    boolean isSatisfied(int number) {
                        return topPos - 1 == number;
                    }
                };
            } else if (isAfterOk) {
                this.myNumberCondition = new NumberCondition(){

                    boolean isSatisfied(int number) {
                        return number == bottomPos;
                    }
                };
            } else {
                throw new IllegalArgumentException("All 3 flags are false");
            }
        }

        public LifeLine getLifeline() {
            return this.myLifeLine;
        }

        public boolean isSatisfied(LifelineElementTraceable beforePointElement) {
            LifelineImpl.BoundaryElement boundaryElement = (LifelineImpl.BoundaryElement)beforePointElement;
            if (boundaryElement.getLifeLine() != this.myLifeLine) {
                throw new IllegalArgumentException("Wrong lifeline");
            }
            return this.myNumberCondition.isSatisfied(boundaryElement.getNumber());
        }

        private abstract class NumberCondition {
            private NumberCondition() {
            }

            abstract boolean isSatisfied(int var1);
        }
    }

    public static interface LayoutPropertiesFactory {
        public ElementLayoutProperties createLayoutProperties(SDEntity var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class LifeLineElementAdapter
    implements LifeLineElement,
    LifelineElementTraceable {
        private HorizontalConstraint myHorizontalConstraint;
        private List<OrderingConstraint> myBeforeConstraintList = null;
        private List<OrderingConstraint> myAfterConstraintList = null;

        private LifeLineElementAdapter() {
        }

        @Override
        public void optimizeSize() {
        }

        @Override
        public HorizontalConstraint getHorizontalConstraint() {
            return this.myHorizontalConstraint;
        }

        void setHorizontalConstraint(HorizontalConstraint horizontalConstraint) {
            if (this.myHorizontalConstraint != null && horizontalConstraint != null) {
                throw new IllegalStateException("Horizontal constraint is already set");
            }
            this.myHorizontalConstraint = horizontalConstraint;
        }

        void addBeforeConstraints(OrderingConstraint orderingConstraint) {
            if (this.myBeforeConstraintList == null) {
                this.myBeforeConstraintList = new ArrayList<OrderingConstraint>();
            }
            this.myBeforeConstraintList.add(orderingConstraint);
        }

        void addAfterConstraints(OrderingConstraint orderingConstraint) {
            if (this.myAfterConstraintList == null) {
                this.myAfterConstraintList = new ArrayList<OrderingConstraint>();
            }
            this.myAfterConstraintList.add(orderingConstraint);
        }

        @Override
        public Enumeration<OrderingConstraint> beforeConstraints() {
            if (this.myBeforeConstraintList == null) {
                return EmptyEnumeration.getEnumeration();
            }
            return Collections.enumeration(this.myBeforeConstraintList);
        }

        @Override
        public Enumeration<OrderingConstraint> afterConstraints() {
            if (this.myAfterConstraintList == null) {
                return EmptyEnumeration.getEnumeration();
            }
            return Collections.enumeration(this.myAfterConstraintList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifelineCreationDestructionCollector {
        private final LifelineImpl.TopElement[] myLifelineCreation;
        private final LifelineImpl.BottomElement[] myLifelineDestruction;
        private int myCurrentLifelineIndex = -1;

        LifelineCreationDestructionCollector(int lifelineCount) {
            this.myLifelineCreation = new LifelineImpl.TopElement[lifelineCount];
            this.myLifelineDestruction = new LifelineImpl.BottomElement[lifelineCount];
        }

        void startLifeline(LifelineImpl.TopElement lifelineTop) {
            ++this.myCurrentLifelineIndex;
        }

        void finishLifeline(LifelineImpl.BottomElement lifelineBottom) {
        }

        void startElement(LifelineImpl.TopElement topElement) {
            if (this.myLifelineCreation[this.myCurrentLifelineIndex] != null) {
                return;
            }
            SDLifeLineElement entity = topElement.getEntity();
            if (entity instanceof SDExecution && MissedMethods._executionSpecification().isCreation((SDExecution)entity)) {
                this.myLifelineCreation[this.myCurrentLifelineIndex] = topElement;
            }
        }

        void finishElement(LifelineImpl.BottomElement bottomElement) {
            SDLifeLineElement entity = bottomElement.getEntity();
            if (entity instanceof SDExecution && MissedMethods._executionSpecification().isDestruction((SDExecution)entity)) {
                this.myLifelineDestruction[this.myCurrentLifelineIndex] = bottomElement;
            }
        }

        LifelineElementTraceable[] getLifelineCreationTops() {
            return this.myLifelineCreation;
        }

        LifelineElementTraceable[] getLifelineDestructionBottoms() {
            return this.myLifelineDestruction;
        }

        LifelineSatisfyCondition[] createCreationDestructionSatisfyConditions(List<LifeLine> lifeilneImplList) {
            LifelineSatisfyCondition[] result = new LifelineSatisfyCondition[lifeilneImplList.size()];
            int i = 0;
            while (i < this.myLifelineCreation.length) {
                if (this.myLifelineCreation[i] != null || this.myLifelineDestruction[i] != null) {
                    class NoElementsBeforeCreationOrAfterDestruction
                    implements LifelineSatisfyCondition {
                        private final LifelineImpl myLifeline;
                        private final LifelineImpl.TopElement myCreation;
                        private final LifelineImpl.BottomElement myDestruction;

                        NoElementsBeforeCreationOrAfterDestruction(LifelineImpl lifeline, LifelineImpl.TopElement creation, LifelineImpl.BottomElement destruction) {
                            this.myLifeline = lifeline;
                            this.myCreation = creation;
                            this.myDestruction = destruction;
                        }

                        public boolean isSatisfied(LifelineElementTraceable elementTraceable) {
                            if (this.myCreation != null && elementTraceable.getNumber() < this.myCreation.getNumber()) {
                                return false;
                            }
                            return this.myDestruction == null || this.myDestruction.getNumber() > elementTraceable.getNumber();
                        }

                        public LifeLine getLifeline() {
                            return this.myLifeline;
                        }
                    }
                    result[i] = new NoElementsBeforeCreationOrAfterDestruction((LifelineImpl)lifeilneImplList.get(i), this.myLifelineCreation[i], this.myLifelineDestruction[i]);
                }
                ++i;
            }
            return result;
        }
    }

    private class LifelineImpl
    implements LifeLine {
        private BoundaryElement myFirstElement = null;
        private BoundaryElement myLastElement = null;
        private int mySize = 0;
        private final String myName;

        LifelineImpl(String name) {
            this.myName = name;
        }

        public LifeLineIterator iterator() {
            return new LifeLineIterator(){
                private BoundaryElement myCurrentElement;
                {
                    this.myCurrentElement = LifelineImpl.this.myFirstElement;
                }

                public Integer nextClueValue() {
                    return NULL_CLUE;
                }

                public LifeLineElement nextElement() {
                    try {
                        BoundaryElement boundaryElement = this.myCurrentElement;
                        return boundaryElement;
                    }
                    finally {
                        this.myCurrentElement = this.myCurrentElement.nextElement;
                    }
                }

                public boolean hasNext() {
                    return this.myCurrentElement != null;
                }
            };
        }

        TopElement addTopLifelineElement(SDLifeLineElement entity, LayoutPropertiesFactory layoutPropertiesFactory) {
            TopElement result = new TopElement(entity, this.mySize, layoutPropertiesFactory.createLayoutProperties((SDEntity)entity, true));
            this.addElementToList(result);
            return result;
        }

        BottomElement addBottomLifelineElement(TopElement topElement, LayoutPropertiesFactory layoutPropertiesFactory) {
            BottomElement result = new BottomElement(topElement, this.mySize, layoutPropertiesFactory.createLayoutProperties((SDEntity)topElement.getEntity(), false));
            this.addElementToList(result);
            return result;
        }

        BoundaryElement getPreviousElement(BoundaryElement boundaryElement) {
            return boundaryElement.prevElement;
        }

        public String toString() {
            return MessageFormat.format("LL'{0}'", this.myName);
        }

        private void addElementToList(BoundaryElement boundaryElement) {
            if (this.myLastElement == null) {
                this.myLastElement = boundaryElement;
                this.myFirstElement = boundaryElement;
                boundaryElement.prevElement = null;
                boundaryElement.nextElement = null;
            } else {
                boundaryElement.prevElement = this.myLastElement;
                boundaryElement.nextElement = null;
                this.myLastElement.nextElement = boundaryElement;
                this.myLastElement = boundaryElement;
            }
            ++this.mySize;
        }

        private class BottomElement
        extends BoundaryElement {
            private final TopElement myTopElement;

            BottomElement(TopElement topElement, int number, ElementLayoutProperties elementLayoutProperties) {
                super(number, elementLayoutProperties);
                this.myTopElement = topElement;
            }

            public boolean isTopNotBottom() {
                return false;
            }

            SDLifeLineElement getEntity() {
                return this.myTopElement.getEntity();
            }

            TopElement getTopElement() {
                return this.myTopElement;
            }

            public SDLifeLineElement getEntityAfterElement() {
                if (this.getEntity() instanceof SDLifeLine) {
                    return null;
                }
                SDBracket bracket = (SDBracket)this.getEntity();
                return bracket.getBracketContainer();
            }

            public String toString() {
                return MessageFormat.format("[BottomOf({0}){1}]", DebugFormat.debugFormatEntity((SDEntity)this.getEntity()), this.getNumber());
            }
        }

        private abstract class BoundaryElement
        extends LifeLineElementAdapter {
            BoundaryElement nextElement;
            BoundaryElement prevElement;
            private final int myNumber;
            private final ElementLayoutProperties myElementLayoutProperties;

            BoundaryElement(int number, ElementLayoutProperties elementLayoutProperties) {
                this.myNumber = number;
                this.myElementLayoutProperties = elementLayoutProperties;
            }

            public LifeLine getLifeLine() {
                return LifelineImpl.this;
            }

            public LifelineImpl getLifelineImpl() {
                return LifelineImpl.this;
            }

            public abstract boolean isTopNotBottom();

            abstract SDLifeLineElement getEntity();

            public LifelineElementTraceable getPreviousElement() {
                return this.prevElement;
            }

            public LifelineElementTraceable getNextElement() {
                return this.nextElement;
            }

            public BoundaryElement getPreviousBoundaryElement() {
                return this.prevElement;
            }

            public BoundaryElement getNextBoundaryElement() {
                return this.nextElement;
            }

            public int getNumber() {
                return this.myNumber;
            }

            public int getPointOffset() {
                return this.myElementLayoutProperties.getPointOffset();
            }

            public int getSize() {
                return this.myElementLayoutProperties.getSize();
            }

            public LifeLineElement.Position getPosition() {
                return this.myElementLayoutProperties.getPosition();
            }
        }

        private class TopElement
        extends BoundaryElement {
            private final SDLifeLineElement myEntity;

            TopElement(SDLifeLineElement entity, int number, ElementLayoutProperties elementLayoutProperties) {
                super(number, elementLayoutProperties);
                this.myEntity = entity;
            }

            public boolean isTopNotBottom() {
                return true;
            }

            SDLifeLineElement getEntity() {
                return this.myEntity;
            }

            public String toString() {
                return MessageFormat.format("[TopOf({0}){1}]", DebugFormat.debugFormatEntity((SDEntity)this.getEntity()), this.getNumber());
            }

            public SDLifeLineElement getEntityAfterElement() {
                return this.myEntity;
            }
        }
    }

    private class OrderingConstraintImpl
    implements OrderingConstraint {
        private final LifeLineElement myBeforeLifeLineElement;
        private final LifeLineElement myAfterLifeLineElement;

        OrderingConstraintImpl(LifelineImpl.BoundaryElement beforeLifeLineElement, LifelineImpl.BoundaryElement afterLifeLineElement) {
            this.myBeforeLifeLineElement = beforeLifeLineElement;
            this.myAfterLifeLineElement = afterLifeLineElement;
            beforeLifeLineElement.addAfterConstraints(this);
            afterLifeLineElement.addBeforeConstraints(this);
        }

        public LifeLineElement getBeforeElement() {
            return this.myBeforeLifeLineElement;
        }

        public LifeLineElement getAfterElement() {
            return this.myAfterLifeLineElement;
        }

        public int getMinSlopeValue() {
            return 0;
        }

        public void setInvalid(boolean invalid) {
        }
    }
}

