/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui.AbstractNaryEditingDialog;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui.ModelCellsEditingSupport;
import org.eclipse.papyrus.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaryAttributeEditingDialog<T>
extends AbstractNaryEditingDialog<T> {
    private static final int NUM_COLUMNS = 2;
    private TableViewer featureValuesTableViewer;
    private final Object newValuePlaceholder = new Object();
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private final ColumnLabelProvider labelProvider = new ColumnLabelProvider(){
        private final LabelProvider delegateLabelProvider = new CustomizableLabelProvider();

        public Image getImage(Object element) {
            return this.delegateLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element == NaryAttributeEditingDialog.this.newValuePlaceholder) {
                return Messages.NaryAttributeEditingDialog_enterNewValuePlaceholder;
            }
            return this.delegateLabelProvider.getText(element);
        }

        public Color getForeground(Object element) {
            if (element == NaryAttributeEditingDialog.this.newValuePlaceholder) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }
    };

    public NaryAttributeEditingDialog(Shell shell, List<T> values, IModelCellEditHandler editHandler, EObject eObject, EStructuralFeature feature) {
        super(shell, values, editHandler, eObject, feature);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.NaryReferenceEditingDialog_shellTitle, (Object)this.getFeature().getName(), (Object)this.geteObject().eClass().getName()));
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if ((e.detail == 2 || e.detail == 4) && NaryAttributeEditingDialog.this.featureValuesTableViewer.isCellEditorActive()) {
                    e.doit = false;
                    NaryAttributeEditingDialog.this.featureValuesTableViewer.cancelEditing();
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 2;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createValuesPane(contents);
        this.createButtonsPane(contents);
        this.featureValuesTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NaryAttributeEditingDialog.this.editSelectedElement();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryAttributeEditingDialog.this.upButtonClicked();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryAttributeEditingDialog.this.downButtonClicked();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryAttributeEditingDialog.this.addButtonClicked();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryAttributeEditingDialog.this.removeButtonClicked();
            }
        });
        return contents;
    }

    private void addButtonClicked() {
        this.getValues().add(0, this.newValuePlaceholder);
        this.refresh();
        this.featureValuesTableViewer.editElement(this.newValuePlaceholder, 0);
    }

    private void removeButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.featureValuesTableViewer.getSelection();
        for (Object element : selection) {
            if (!this.getValues().contains(element)) continue;
            this.getValues().remove(element);
        }
        this.refresh();
    }

    private void spacer(Composite parent) {
        Label label = new Label(parent, 0);
    }

    private void createButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 4;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.spacer(buttonsComposite);
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText(Messages.NaryAttributeEditingDialog_add);
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.removeButton = new Button(buttonsComposite, 8);
        this.removeButton.setText(Messages.NaryAttributeEditingDialog_delete);
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        this.spacer(buttonsComposite);
        this.upButton = new Button(buttonsComposite, 8);
        this.upButton.setText(Messages.NaryReferenceEditingDialog_up);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(buttonsComposite, 8);
        this.downButton.setText(Messages.NaryReferenceEditingDialog_down);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
    }

    private void createValuesPane(Composite contents) {
        Composite featureComposite = new Composite(contents, 0);
        GridData featureCompositeData = new GridData(4, 4, true, true);
        featureCompositeData.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)featureCompositeData);
        GridLayout featureCompositeLayout = new GridLayout();
        featureCompositeData.horizontalAlignment = 4;
        featureCompositeLayout.marginHeight = 0;
        featureCompositeLayout.marginWidth = 0;
        featureCompositeLayout.numColumns = 1;
        featureComposite.setLayout((Layout)featureCompositeLayout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(Messages.NaryReferenceEditingDialog_values);
        GridData valuesLabelGridData = new GridData();
        valuesLabelGridData.horizontalSpan = 2;
        valuesLabelGridData.horizontalAlignment = 4;
        valuesLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)valuesLabelGridData);
        final Table table = new Table(featureComposite, 67586);
        GridData tableGridData = new GridData();
        tableGridData.widthHint = 200;
        tableGridData.heightHint = 250;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)tableGridData);
        final TableColumn tableColumn = new TableColumn(table, 0x1000000);
        table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                tableColumn.setWidth(table.getClientArea().width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.featureValuesTableViewer = new TableViewer(table);
        this.featureValuesTableViewer.setContentProvider((IContentProvider)new AbstractNaryEditingDialog.AssignedValuesContentProvider(this));
        this.featureValuesTableViewer.setInput(this.getValues());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.featureValuesTableViewer, tableColumn);
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
        tableViewerColumn.setEditingSupport(new ModelCellsEditingSupport((ColumnViewer)this.featureValuesTableViewer, this.getFeature(), this.geteObject(), this.newValuePlaceholder, this.getValues()));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    NaryAttributeEditingDialog.this.editSelectedElement();
                }
                if (e.keyCode == 127 && NaryAttributeEditingDialog.this.removeButton.isEnabled()) {
                    NaryAttributeEditingDialog.this.removeButton.notifyListeners(13, null);
                }
                if (e.keyCode == 0x1000001 && ((e.stateMask & 0x400000) != 0 || (e.stateMask & 0x40000) != 0) && NaryAttributeEditingDialog.this.upButton.isEnabled()) {
                    NaryAttributeEditingDialog.this.upButton.notifyListeners(13, null);
                }
                if (e.keyCode == 0x1000002 && ((e.stateMask & 0x400000) != 0 || (e.stateMask & 0x40000) != 0) && NaryAttributeEditingDialog.this.downButton.isEnabled()) {
                    NaryAttributeEditingDialog.this.downButton.notifyListeners(13, null);
                }
            }
        });
    }

    private void editSelectedElement() {
        IStructuredSelection structuredSelection;
        ISelection selection = this.featureValuesTableViewer.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() != null) {
            this.featureValuesTableViewer.editElement(structuredSelection.getFirstElement(), 0);
        }
    }

    @Override
    public void refresh() {
        this.featureValuesTableViewer.refresh();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    @Override
    public ISelection getSelection() {
        return this.featureValuesTableViewer.getSelection();
    }
}

