/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.preferences.EditorPreferences;
import org.eclipse.papyrus.infra.ui.internal.preferences.YesNo;
import org.eclipse.papyrus.junit.utils.GenericUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;

public class EditorUtils {
    private EditorUtils() {
    }

    public static final IEditorPart openEditor(IFile file) throws PartInitException {
        return EditorUtils.withoutLayoutStoragePopup(() -> {
            GenericUtils.closeIntroPart();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = null;
            editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
            Assert.assertNotNull((Object)editor);
            return editor;
        });
    }

    public static final IMultiDiagramEditor openPapyrusEditor(IFile file) throws PartInitException {
        return EditorUtils.withoutLayoutStoragePopup(() -> {
            GenericUtils.closeIntroPart();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = null;
            editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)"org.eclipse.papyrus.infra.core.papyrusEditor");
            Assert.assertNotNull((Object)editor);
            return (IMultiDiagramEditor)editor;
        });
    }

    private static <E extends IEditorPart> E withoutLayoutStoragePopup(EditorOpener<E> editorOpener) throws PartInitException {
        E result;
        boolean posted = false;
        YesNo originalPreference = EditorPreferences.getInstance().getConvertSharedPageLayoutToPrivate();
        EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(YesNo.NO);
        try {
            result = editorOpener.openEditor();
            result.getSite().getShell().getDisplay().asyncExec(() -> EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(originalPreference));
            posted = true;
        }
        finally {
            if (!posted) {
                EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(originalPreference);
            }
        }
        return result;
    }

    @FunctionalInterface
    private static interface EditorOpener<E extends IEditorPart> {
        public E openEditor() throws PartInitException;
    }
}

