/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.gmfdiag.style.StylePackage;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class DiagramUtils {
    public static Diagram getDiagramFrom(EditPart part) {
        for (EditPart current = part; current != null; current = current.getParent()) {
            Object model = current.getModel();
            if (model instanceof Diagram) {
                return (Diagram)model;
            }
            if (current.getParent() != null) {
                continue;
            }
            if (current.getChildren().isEmpty()) {
                return null;
            }
            model = (current = (EditPart)current.getChildren().get(0)).getModel();
            return model instanceof Diagram ? (Diagram)model : null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DiagramEditPart getDiagramEditPartFrom(EditPart part) {
        if (part == null) {
            return null;
        }
        EditPart current = part;
        while (!(current instanceof DiagramEditPart)) {
            if (current.getParent() == null) {
                return null;
            }
            current = current.getParent();
        }
        return (DiagramEditPart)current;
    }

    public static EObject getOwner(Diagram diagram) {
        EObject value;
        PapyrusDiagramStyle pvs = DiagramUtils.getPapyrusDiagramStyle(diagram);
        if (pvs != null && (value = pvs.getOwner()) != null) {
            return value;
        }
        return diagram.getElement();
    }

    public static void setOwner(Diagram diagram, EObject owner) {
        PapyrusDiagramStyle pvs = DiagramUtils.getPapyrusDiagramStyle(diagram);
        if (pvs != null) {
            pvs.setOwner(owner);
        } else {
            pvs = (PapyrusDiagramStyle)diagram.createStyle(StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE);
            pvs.setOwner(owner);
        }
    }

    public static final PapyrusDiagramStyle getPapyrusDiagramStyle(Diagram diagram) {
        for (Style ownedStyle : diagram.getStyles()) {
            if (!(ownedStyle instanceof PapyrusDiagramStyle)) continue;
            return (PapyrusDiagramStyle)ownedStyle;
        }
        return null;
    }

    public static ViewPrototype getPrototype(Diagram diagram) {
        return DiagramUtils.getPrototype(diagram, true);
    }

    public static ViewPrototype getPrototype(Diagram diagram, boolean checkViewpoint) {
        PolicyChecker checker = PolicyChecker.getFor((EObject)diagram);
        return DiagramUtils.getPrototype(diagram, checker, checkViewpoint);
    }

    public static ViewPrototype getPrototype(Diagram diagram, PolicyChecker checker) {
        return DiagramUtils.getPrototype(diagram, checker, true);
    }

    public static ViewPrototype getPrototype(Diagram diagram, PolicyChecker checker, boolean checkViewpoint) {
        PapyrusDiagramStyle pvs = DiagramUtils.getPapyrusDiagramStyle(diagram);
        if (pvs != null) {
            ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
            PapyrusDiagram repKind = null;
            String diagramKindId = pvs.getDiagramKindId();
            if (manager.getRepresentationKindById(diagramKindId) instanceof PapyrusDiagram) {
                repKind = (PapyrusDiagram)manager.getRepresentationKindById(diagramKindId);
            } else {
                Activator.log.info("Unexpected diagram kind: " + diagramKindId + " Your notation file might be broken or created with a previous version of the architecture framework.");
            }
            if (repKind != null) {
                if (!checkViewpoint || checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
                    return ViewPrototype.get((PapyrusRepresentationKind)repKind);
                }
                PapyrusRepresentationKind diagramParentView = repKind.getParent();
                while (diagramParentView != null && !checker.isInViewpoint(diagramParentView)) {
                    diagramParentView = diagramParentView.getParent();
                }
                if (diagramParentView != null) {
                    return ViewPrototype.get((PapyrusRepresentationKind)diagramParentView);
                }
                String diagramConfigName = repKind.getName();
                if (diagramConfigName != null) {
                    for (MergedArchitectureViewpoint viewpoint : checker.getViewpoints()) {
                        for (RepresentationKind representationKind : viewpoint.getRepresentationKinds()) {
                            if (!(representationKind instanceof PapyrusRepresentationKind)) continue;
                            PapyrusRepresentationKind papyrusRepresentationKind = (PapyrusRepresentationKind)representationKind;
                            if (diagramConfigName.equals(papyrusRepresentationKind.getName())) {
                                ViewPrototype.get((PapyrusRepresentationKind)papyrusRepresentationKind);
                            }
                            PapyrusRepresentationKind parentPapyrusRepresentationKind = papyrusRepresentationKind.getParent();
                            while (parentPapyrusRepresentationKind != null && !diagramConfigName.equals(parentPapyrusRepresentationKind.getName())) {
                                parentPapyrusRepresentationKind = parentPapyrusRepresentationKind.getParent();
                            }
                            if (parentPapyrusRepresentationKind == null) continue;
                            return ViewPrototype.get((PapyrusRepresentationKind)papyrusRepresentationKind);
                        }
                    }
                }
            }
            return ViewPrototype.get((PolicyChecker)checker, (String)diagram.getType(), (EObject)pvs.getOwner(), (EObject)diagram.getElement());
        }
        return ViewPrototype.get((PolicyChecker)checker, (String)diagram.getType(), (EObject)diagram.getElement(), (EObject)diagram.getElement());
    }

    public static void setPrototype(Diagram diagram, DiagramPrototype prototype) {
        if (diagram.getType() == null || diagram.getType().equals(prototype.getRepresentationKind().getImplementationID())) {
            PapyrusDiagramStyle pvs = DiagramUtils.getPapyrusDiagramStyle(diagram);
            if (pvs != null) {
                pvs.setDiagramKindId(prototype.getRepresentationKind().getId());
            } else {
                pvs = (PapyrusDiagramStyle)diagram.createStyle(StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE);
                pvs.setDiagramKindId(prototype.getRepresentationKind().getId());
            }
        } else {
            throw new IllegalArgumentException(String.format("The diagram type (=%s) differs from the prototype's implementation id (=%s)", diagram.getType(), prototype.getRepresentationKind().getImplementationID()));
        }
    }

    public static List<Diagram> getAssociatedDiagrams(EObject element, ResourceSet resourceSet) {
        if (resourceSet == null && element != null && element.eResource() != null) {
            resourceSet = element.eResource().getResourceSet();
        }
        if (resourceSet instanceof ModelSet) {
            Resource notationResource = NotationUtils.getNotationResource((ModelSet)resourceSet);
            return DiagramUtils.getAssociatedDiagramsFromNotationResource(element, notationResource);
        }
        return Collections.emptyList();
    }

    public static List<Diagram> getAssociatedDiagramsFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
            for (EObject eObj : notationResource.getContents()) {
                Diagram diagram;
                if (!(eObj instanceof Diagram) || !element.equals((diagram = (Diagram)eObj).getElement())) continue;
                diagrams.add(diagram);
            }
            return diagrams;
        }
        return Collections.emptyList();
    }

    public static Diagram getContainingDiagram(View view) {
        if (view instanceof Diagram) {
            return (Diagram)view;
        }
        EObject eContainer = view.eContainer();
        if (eContainer instanceof View) {
            return DiagramUtils.getContainingDiagram((View)eContainer);
        }
        return null;
    }

    public static String getContainingDiagramType(View view) {
        Diagram containingDiagram = DiagramUtils.getContainingDiagram(view);
        if (containingDiagram != null) {
            return containingDiagram.getType();
        }
        return null;
    }

    public static String getContainingDiagramKindId(View view) {
        PapyrusDiagramStyle pvs;
        Diagram containingDiagram = DiagramUtils.getContainingDiagram(view);
        if (containingDiagram != null && (pvs = DiagramUtils.getPapyrusDiagramStyle(containingDiagram)) != null) {
            return pvs.getDiagramKindId();
        }
        return null;
    }
}

