/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationFactory;
import org.eclipse.papyrus.infra.internationalization.InternationalizationLibrary;
import org.eclipse.papyrus.infra.internationalization.controlmode.Activator;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

public class ControlPropertiesCommand
extends AbstractControlCommand {
    private static final String COMMAND_TITLE = "Properties control command";
    private InternationalizationModelResource internationalizationModelResource = null;
    private Resource oldNotationResource = null;

    public ControlPropertiesCommand(ControlModeRequest request) {
        this(COMMAND_TITLE, request);
    }

    public ControlPropertiesCommand(String commandTitle, ControlModeRequest request) {
        super(commandTitle, null, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        HashSet<Resource> createdResources = new HashSet<Resource>();
        Map createdPropertiesResources = (Map)this.getRequest().getParameter("createdPropertiesResources");
        for (Locale locale : createdPropertiesResources.keySet()) {
            List<InternationalizationEntry> entries;
            Resource newPropertiesResource = (Resource)createdPropertiesResources.get(locale);
            if (newPropertiesResource == null) {
                return CommandResult.newErrorCommandResult((String)"The properties model has not been created");
            }
            InternationalizationLibrary library = null;
            for (EObject objectContant : newPropertiesResource.getContents()) {
                if (!(objectContant instanceof InternationalizationLibrary)) continue;
                library = (InternationalizationLibrary)objectContant;
            }
            if (library == null) {
                library = InternationalizationFactory.eINSTANCE.createInternationalizationLibrary();
                newPropertiesResource.getContents().add((Object)library);
            }
            if (!(entries = this.getInternationalizationEntries(locale)).isEmpty()) {
                for (InternationalizationEntry entry : entries) {
                    library.getEntries().add((Object)((InternationalizationEntry)EcoreUtil.copy((EObject)entry)));
                }
                Resource oldPropertiesResource = this.getOldPropertiesResource(locale);
                if (oldPropertiesResource != null && !oldPropertiesResource.getContents().isEmpty()) {
                    InternationalizationLibrary oldLibrary = (InternationalizationLibrary)oldPropertiesResource.getContents().get(0);
                    oldLibrary.getEntries().removeAll(entries);
                }
            }
            createdResources.add(newPropertiesResource);
        }
        return CommandResult.newOKCommandResult(createdResources);
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(monitor, info).getStatus();
    }

    protected List<InternationalizationEntry> getInternationalizationEntries(Locale locale) throws ExecutionException {
        ArrayList<InternationalizationEntry> entries = new ArrayList<InternationalizationEntry>();
        this.getInternationalizationModelResource();
        if (this.internationalizationModelResource != null) {
            EObject targetObject = this.getRequest().getTargetObject();
            InternationalizationEntry entryForKey = this.internationalizationModelResource.getEntryForKey(this.getOldPropertiesURI(), (Object)targetObject, locale);
            if (entryForKey != null) {
                entries.add(entryForKey);
            }
            TreeIterator eAllContents = EcoreUtil.getAllProperContents((EObject)targetObject, (boolean)true);
            while (eAllContents.hasNext()) {
                EObject content = (EObject)eAllContents.next();
                entryForKey = this.internationalizationModelResource.getEntryForKey(this.getOldPropertiesURI(), (Object)content, locale);
                if (entryForKey == null) continue;
                entries.add(entryForKey);
            }
            Resource oldNotationResource = this.getOldNotationResource();
            for (Diagram diagram : NotationUtils.getDiagrams((Resource)oldNotationResource, (EObject)this.getRequest().getTargetObject())) {
                entryForKey = this.internationalizationModelResource.getEntryForKey(this.getOldPropertiesURI(), (Object)diagram, locale);
                if (entryForKey == null) continue;
                entries.add(entryForKey);
            }
            for (Table table : this.getTables(oldNotationResource, this.getRequest().getTargetObject())) {
                entryForKey = this.internationalizationModelResource.getEntryForKey(this.getOldPropertiesURI(), (Object)table, locale);
                if (entryForKey == null) continue;
                entries.add(entryForKey);
            }
        }
        return entries;
    }

    protected List<Table> getTables(Resource notationResource, EObject eObject) {
        LinkedList<Table> tables = new LinkedList<Table>();
        if (notationResource != null) {
            for (EObject obj : notationResource.getContents()) {
                Table table;
                if (!(obj instanceof Table) || !EcoreUtil.isAncestor((EObject)eObject, (EObject)(table = (Table)obj).getOwner())) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    protected InternationalizationModelResource getInternationalizationModelResource() {
        if (this.internationalizationModelResource == null) {
            try {
                this.internationalizationModelResource = (InternationalizationModelResource)this.getRequest().getModelSet().getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
            }
            catch (Exception e) {
                Activator.log.error("Unable to retrieve old properties resource", (Throwable)e);
            }
        }
        return this.internationalizationModelResource;
    }

    private Resource getOldPropertiesResource(Locale locale) {
        Resource resource = null;
        this.getInternationalizationModelResource();
        try {
            resource = this.internationalizationModelResource.getResourceForURIAndLocale(this.getOldPropertiesURI(), locale);
        }
        catch (Exception e) {
            Activator.log.error("Unable to retrieve old notation resource", (Throwable)e);
        }
        return resource;
    }

    protected URI getOldPropertiesURI() throws ExecutionException {
        URI uri = this.getRequest().getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("properties");
        }
        throw new ExecutionException("Unable to retreive URI of the old properties model");
    }

    private Resource getOldNotationResource() {
        if (this.oldNotationResource == null) {
            try {
                this.oldNotationResource = this.getRequest().getModelSet().getResource(this.getOldNotationURI(), true);
            }
            catch (Exception e) {
                Activator.log.error("Unable to retrieve old notation resource", (Throwable)e);
            }
        }
        return this.oldNotationResource;
    }

    protected URI getOldNotationURI() throws ExecutionException {
        URI uri = this.getRequest().getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("notation");
        }
        throw new ExecutionException("Unable to retreive URI of the old notation model");
    }
}

