/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.kind.RepresentationKindComposite;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelWizardData;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserComposite;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.SelectModelTemplateComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.NamedElement;

public class SelectRepresentationKindPage
extends WizardPage {
    public static final String PAGE_ID = "SelectDiagramKind";
    private Text nameText;
    private boolean nameTextModified;
    private Optional<SelectModelTemplateComposite> selectTemplateComposite;
    private boolean showTemplateChooser = true;
    private Optional<RepresentationKindComposite> representationKindComposite;
    private boolean showRepresentationKinds = true;
    private Optional<ProfileChooserComposite> profileChooserComposite;
    private boolean showProfileChooser = true;
    private final ContextProvider myContextProvider;
    private final boolean allowTemplates;
    private final ICreationCommandRegistry myCreationCommandRegistry;
    private NewModelWizardData wizardData;
    private IValueChangeListener<String> defaultModelNameListener;
    private static EObject modelRoot;
    public static final ICreationCommandRegistry DEFAULT_CREATION_COMMAND_REGISTRY;

    static {
        DEFAULT_CREATION_COMMAND_REGISTRY = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.ui");
    }

    public SelectRepresentationKindPage(ContextProvider contextProvider) {
        this(true, contextProvider, DEFAULT_CREATION_COMMAND_REGISTRY);
    }

    public SelectRepresentationKindPage(boolean allowTemplates, ContextProvider contextProvider, ICreationCommandRegistry creationCommandRegistry) {
        super(PAGE_ID);
        this.setTitle(Messages.SelectRepresentationKindPage_page_title);
        this.setDescription(Messages.SelectRepresentationKindPage_page_desc);
        this.allowTemplates = allowTemplates;
        this.myContextProvider = contextProvider;
        this.myCreationCommandRegistry = creationCommandRegistry;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout());
        pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite nameFormParent = new Composite(pageComposite, 0);
        nameFormParent.setLayout((Layout)new GridLayout());
        nameFormParent.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText = this.createNameForm(nameFormParent);
        if (this.isShowRepresentationKinds()) {
            Composite representationKindParent = new Composite(pageComposite, 0);
            representationKindParent.setLayout((Layout)new GridLayout());
            representationKindParent.setLayoutData((Object)new GridData(4, 4, true, true));
            this.representationKindComposite = Optional.of(this.createPresentationKindForm(representationKindParent));
        } else {
            this.representationKindComposite = Optional.empty();
        }
        if (this.isShowTemplateChooser()) {
            Composite modelTemplateParent = new Composite(pageComposite, 0);
            modelTemplateParent.setLayout((Layout)new GridLayout());
            modelTemplateParent.setLayoutData((Object)new GridData(4, 4, true, false));
            this.selectTemplateComposite = Optional.of(this.createModelTemplateComposite(modelTemplateParent));
        } else {
            this.selectTemplateComposite = Optional.empty();
        }
        if (this.isShowProfileChooser()) {
            Composite profileChooserParent = new Composite(pageComposite, 0);
            profileChooserParent.setLayout((Layout)new GridLayout());
            profileChooserParent.setLayoutData((Object)new GridData(4, 4, true, false));
            this.profileChooserComposite = Optional.of(this.createProfileFileChooser(profileChooserParent));
        } else {
            this.profileChooserComposite = Optional.empty();
        }
        this.setControl((Control)pageComposite);
        this.fillInTables(this.getContexts(), this.getViewpoints());
    }

    private ProfileChooserComposite createProfileFileChooser(Composite parent) {
        Group group = SelectRepresentationKindPage.createGroup(parent, Messages.SelectRepresentationKindPage_0);
        ProfileChooserComposite result = new ProfileChooserComposite((Composite)group);
        result.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                SelectRepresentationKindPage.this.validatePage();
            }
        });
        return result;
    }

    public boolean isShowProfileChooser() {
        return this.showProfileChooser;
    }

    public void setShowProfileChooser(boolean showProfileChooser) {
        this.showProfileChooser = showProfileChooser;
    }

    @Deprecated
    public String getProfileURI() {
        return this.profileChooserComposite.map(ProfileChooserComposite::getProfileURI).orElse(null);
    }

    public List<String> getProfilesURI() {
        return this.profileChooserComposite.map(ProfileChooserComposite::getProfilesURI).orElse(Collections.emptyList());
    }

    public IStatus getProfileDefinitionStatus() {
        return this.profileChooserComposite.map(ProfileChooserComposite::getProfileDefinitionStatus).orElse(Status.OK_STATUS);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillInTables(this.getContexts(), this.getViewpoints());
            this.validatePage();
            this.selectTemplateComposite.ifPresent(stc -> {
                Combo templateCombo = stc.getTemplateCombo();
                if (templateCombo.getItemCount() == 0) {
                    templateCombo.setEnabled(false);
                } else {
                    templateCombo.setEnabled(true);
                }
                if (!this.allowTemplates) {
                    stc.disable();
                }
            });
        }
    }

    private void fillInTables(String[] contexts, String[] viewpoints) {
        if (viewpoints == null || contexts == null) {
            return;
        }
        this.representationKindComposite.ifPresent(rkc -> rkc.setInput(viewpoints));
        this.selectTemplateComposite.ifPresent(stc -> stc.setInput(contexts));
    }

    public String getTemplatePath() {
        return this.selectTemplateComposite.map(SelectModelTemplateComposite::getTemplatePath).orElse(null);
    }

    public String getNotationTemplatePath() {
        return this.selectTemplateComposite.map(SelectModelTemplateComposite::getNotationTemplatePath).orElse(null);
    }

    public String getDiTemplatePath() {
        return this.selectTemplateComposite.map(SelectModelTemplateComposite::getDiTemplatePath).orElse(null);
    }

    public String getTemplatePluginId() {
        return this.selectTemplateComposite.map(SelectModelTemplateComposite::getTemplatePluginId).orElse(null);
    }

    private String[] getContexts() {
        return this.myContextProvider.getCurrentContexts();
    }

    private String[] getViewpoints() {
        return this.myContextProvider.getCurrentViewpoints();
    }

    public List<String> getDiagramName() {
        return this.representationKindComposite.map(RepresentationKindComposite::getDiagramName).orElse(Collections.emptyList());
    }

    public String getRootElementName() {
        return this.nameText.getText();
    }

    public boolean templatesEnabled() {
        return this.allowTemplates && this.selectTemplateComposite.isPresent();
    }

    public List<RepresentationKind> getSelectedRepresentationKinds(String contextId) {
        MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById(contextId);
        HashSet allowedKinds = new HashSet();
        for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
            allowedKinds.addAll(viewpoint.getRepresentationKinds());
        }
        ArrayList<RepresentationKind> selectedKinds = new ArrayList<RepresentationKind>();
        RepresentationKind[] representationKindArray = this.getSelectedRepresentationKinds();
        int n = representationKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepresentationKind kind = representationKindArray[n2];
            if (allowedKinds.contains(kind)) {
                selectedKinds.add(kind);
            }
            ++n2;
        }
        return selectedKinds;
    }

    private SelectModelTemplateComposite createModelTemplateComposite(Composite parent) {
        Group group = SelectRepresentationKindPage.createGroup(parent, Messages.SelectRepresentationKindPage_load_template_group);
        return new SelectModelTemplateComposite((Composite)group);
    }

    public boolean isShowTemplateChooser() {
        return this.showTemplateChooser;
    }

    public void setShowTemplateChooser(boolean showTemplateChooser) {
        this.showTemplateChooser = showTemplateChooser;
    }

    private RepresentationKindComposite createPresentationKindForm(Composite parent) {
        Group group = SelectRepresentationKindPage.createGroup(parent, Messages.SelectRepresentationKindPage_select_kind_group);
        return new RepresentationKindComposite((Composite)group);
    }

    public boolean isShowRepresentationKinds() {
        return this.showRepresentationKinds;
    }

    public void setShowRepresentationKinds(boolean showRepresentationKinds) {
        this.showRepresentationKinds = showRepresentationKinds;
    }

    protected IBaseLabelProvider createDiagramKindLabelProvider() {
        return new DiagramKindLabelProvider();
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    private Text createNameForm(Composite parent) {
        IFile selectedIFile;
        IStructuredSelection sSelection;
        Object selectedObject;
        Group group = SelectRepresentationKindPage.createGroup(parent, Messages.SelectRepresentationKindPage_diagram_name_group);
        Text result = new Text((Composite)group, 2048);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.setText((String)this.getDefaultModelName().getValue());
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0 && (selectedObject = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (selectedIFile = (IFile)((IAdaptable)selectedObject).getAdapter(IFile.class)) != null) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createURI((String)selectedIFile.getLocationURI().toString()), true);
                if (resource.getContents().size() > 0) {
                    modelRoot = (EObject)resource.getContents().get(0);
                    if (modelRoot instanceof NamedElement) {
                        NamedElement element = (NamedElement)modelRoot;
                        if (element.getName() != null) {
                            result.setText(element.getName());
                        }
                    } else {
                        modelRoot = null;
                    }
                }
            }
            catch (Exception e) {
                this.setErrorMessage(Messages.SelectRepresentationKindPage_Set_Root_Name_Error);
                Activator.log.error((Throwable)e);
            }
        }
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectRepresentationKindPage.this.validatePage();
            }
        });
        return result;
    }

    public static EObject getModelRoot() {
        return modelRoot;
    }

    private boolean validatePage() {
        IStatus profileStatus;
        if (!Objects.equals(this.nameText.getText(), this.getDefaultModelName().getValue())) {
            this.nameTextModified = true;
        }
        if (!(profileStatus = this.getProfileDefinitionStatus()).isOK()) {
            this.setErrorMessage(profileStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.SelectRepresentationKindPage_page_desc);
        return true;
    }

    public String[] getSelectedDiagramKinds(String categoryId) {
        return new String[0];
    }

    protected RepresentationKind[] getSelectedRepresentationKinds() {
        List checked = this.representationKindComposite.map(RepresentationKindComposite::getCheckElement).orElseGet(ArrayList::new);
        RepresentationKind[] result = checked.toArray(new RepresentationKind[checked.size()]);
        return result;
    }

    protected final ICreationCommandRegistry getCreationCommandRegistry() {
        return this.myCreationCommandRegistry;
    }

    public List<ModelTemplateDescription> getTemplateTransfo() {
        return this.selectTemplateComposite.map(SelectModelTemplateComposite::getTemplateTransfoPath).orElse(Collections.emptyList());
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.Kind");
    }

    public void setNewModelWizardData(NewModelWizardData wizardData) {
        if (this.wizardData == wizardData) {
            return;
        }
        if (this.getDefaultModelName() != null && this.defaultModelNameListener != null) {
            this.getDefaultModelName().removeValueChangeListener(this.defaultModelNameListener);
        }
        this.wizardData = wizardData;
        if (this.getDefaultModelName() != null) {
            this.getDefaultModelName().addValueChangeListener(this.getDefaultModelNameListener());
            this.updateDefaultModelName();
        }
    }

    protected IObservableValue<String> getDefaultModelName() {
        return this.wizardData == null ? null : this.wizardData.getDefaultModelName();
    }

    private IValueChangeListener<String> getDefaultModelNameListener() {
        if (this.defaultModelNameListener == null) {
            this.defaultModelNameListener = event -> this.updateDefaultModelName((String)event.diff.getNewValue());
        }
        return this.defaultModelNameListener;
    }

    protected void updateDefaultModelName(String newName) {
        if (this.nameText != null && !this.nameTextModified) {
            this.nameText.setText(newName);
            this.nameText.selectAll();
        }
    }

    private void updateDefaultModelName() {
        if (this.getDefaultModelName() != null) {
            this.updateDefaultModelName((String)this.getDefaultModelName().getValue());
        }
    }

    public static interface ContextProvider {
        public String[] getCurrentContexts();

        public String[] getCurrentViewpoints();
    }
}

