/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IBorderItemWithLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.BorderDisplayEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusConnectionHandleEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusResizableShapeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.LinkLFSVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeService;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.PapyrusDragEditPartsTrackerEx;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.editparts.LinkLFBorderedShapeEditPart;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.svg.SVGDocument;

public abstract class NodeEditPart
extends LinkLFBorderedShapeEditPart
implements IPapyrusEditPart {
    protected SVGNodePlateFigure svgNodePlate;
    protected IFigure shape;

    public NodeEditPart(View view) {
        super(view);
    }

    protected NodeFigure createMainFigure() {
        return this.createNodeFigure();
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof IBorderItemWithLocator) {
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)((IBorderItemWithLocator)borderItemEditPart).getNewBorderItemLocator(this.getMainFigure()));
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected void refreshSVGPath() {
        View view = this.getNotationView();
        if (this.svgNodePlate != null) {
            if (ShapeService.getInstance().hasShapeToDisplay((EObject)this.getNotationView())) {
                List<SVGDocument> svgToDisplay = ShapeService.getInstance().getSVGDocumentToDisplay((EObject)this.getNotationView());
                int documentNumber = svgToDisplay.size();
                if (documentNumber == 1) {
                    this.svgNodePlate.setSVGDocument(svgToDisplay.get(0));
                } else {
                    this.svgNodePlate.setSVGDocument(null);
                }
            } else {
                this.svgNodePlate.setSVGDocument(null);
            }
            BooleanValueStyle followStyle = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "followSVGSymbol");
            if (followStyle != null) {
                this.svgNodePlate.setFollowSVGPapyrusPath(followStyle.isBooleanValue());
            }
        }
    }

    @Override
    public abstract IPapyrusNodeFigure getPrimaryShape();

    public boolean supportsGradient() {
        return true;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (this.getModel() != null && this.getModel() == event.getNotifier()) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
                this.refreshLineType();
            }
        }
        if (this.resolveSemanticElement() != null) {
            this.refreshShadow();
            if (AppearanceHelper.showShadow((EModelElement)((View)this.getModel())) && this.getRoot() != null) {
                this.getRoot().refresh();
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshShadow();
        this.refreshLineType();
        this.refreshLineWidth();
        this.refreshTransparency();
        this.refreshSVGPath();
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        this.getPrimaryShape().setLineWidth(width);
    }

    protected void setLineType(int style) {
        this.getPrimaryShape().setLineStyle(style);
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        IPapyrusNodeFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    protected void setFontColor(Color color) {
    }

    protected void setForegroundColor(Color color) {
        this.getPrimaryShape().setForegroundColor(color);
    }

    protected final void refreshShadow() {
        this.getPrimaryShape().setShadow(AppearanceHelper.showShadow((EModelElement)((View)this.getModel())));
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("BORDER_DISPLAY_EDITPOLICY", (EditPolicy)new BorderDisplayEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new PapyrusConnectionHandleEditPolicy());
        this.removeEditPolicy("PopupBarEditPolicy");
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PapyrusPopupBarEditPolicy());
    }

    protected abstract IFigure createNodePlate();

    protected abstract IFigure createNodeShape();

    protected abstract IFigure setupContentPane(IFigure var1);

    protected NodeFigure createSVGNodePlate() {
        this.svgNodePlate = new LinkLFSVGNodePlateFigure((GraphicalEditPart)this, -1, -1).withLinkLFEnabled();
        this.svgNodePlate.setDefaultNodePlate(this.createNodePlate());
        return this.svgNodePlate;
    }

    protected NodeFigure createMainFigureWithSVG() {
        NodeFigure figure = this.createSVGNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        this.shape = this.createNodeShape();
        figure.add(this.shape);
        this.setupContentPane(this.shape);
        return figure;
    }

    public IFigure getContentPane() {
        if (this.shape != null) {
            IFigure contentPane = this.setupContentPane(this.shape);
            return contentPane;
        }
        return super.getContentPane();
    }

    public DragTracker getDragTracker(Request request) {
        return new PapyrusDragEditPartsTrackerEx((EditPart)this, true, false, false);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new PapyrusResizableShapeEditPolicy();
    }
}

