/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.datatype;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.uml.properties.datatype.DataTypeObservableValue;

public class DataTypeProvider {
    private final Map<String, Class<? extends DataTypeObservableValue>> observableDataTypes = new HashMap<String, Class<? extends DataTypeObservableValue>>();
    public static final String EXTENSION_ID = "org.eclipse.papyrus.uml.properties.datatype";
    public static final DataTypeProvider instance = new DataTypeProvider();

    private DataTypeProvider() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String dataTypeName = e.getAttribute("dataType");
            String observableClassName = e.getAttribute("observable");
            Class observableClass = ClassLoaderHelper.loadClass((String)observableClassName, DataTypeObservableValue.class);
            if (observableClass != null) {
                this.observableDataTypes.put(dataTypeName, observableClass);
            }
            ++n2;
        }
    }

    public DataTypeObservableValue getObservableDataType(EDataType dataType) {
        for (String key : this.observableDataTypes.keySet()) {
            if (!key.equals(dataType.getName())) continue;
            return (DataTypeObservableValue)ClassLoaderHelper.newInstance(this.observableDataTypes.get(key));
        }
        return null;
    }

    public boolean canHandle(EDataType eType) {
        return this.observableDataTypes.containsKey(eType.getName());
    }
}

