/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.inputcontent.internal;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManagerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFInputContentPapyrusReferenceDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.inputcontent.internal.InputContentPapyrusReferenceLifecycleManager;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class InputContentPapyrusReferenceLifecycleManagerProvider
implements IEEFLifecycleManagerProvider {
    public boolean canHandle(EEFControlDescription controlDescription) {
        return controlDescription instanceof EEFInputContentPapyrusReferenceDescription;
    }

    public IEEFLifecycleManager getLifecycleManager(EEFControlDescription controlDescription, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        EReference eReference;
        EStructuralFeature eStructuralFeature;
        if (!(controlDescription instanceof EEFInputContentPapyrusReferenceDescription) || Util.isBlank((String)((EEFInputContentPapyrusReferenceDescription)controlDescription).getInputContentExpression())) {
            return null;
        }
        InputContentPapyrusReferenceLifecycleManager lifecycleManager = null;
        EEFInputContentPapyrusReferenceDescription description = (EEFInputContentPapyrusReferenceDescription)controlDescription;
        EObject target = this.getTarget((EEFExtReferenceDescription)description, interpreter, variableManager);
        String inputContentExpression = Optional.ofNullable(description.getInputContentExpression()).orElse("");
        String referenceName = this.getReferenceName((EEFExtReferenceDescription)description, interpreter, variableManager);
        if (target != null && !Util.isBlank((String)inputContentExpression) && !Util.isBlank((String)referenceName) && (eStructuralFeature = target.eClass().getEStructuralFeature(referenceName)) instanceof EReference && (eReference = (EReference)eStructuralFeature).isMany()) {
            lifecycleManager = new InputContentPapyrusReferenceLifecycleManager(description, target, eReference, variableManager, interpreter, editingContextAdapter);
        }
        return lifecycleManager;
    }

    private EObject getTarget(EEFExtReferenceDescription description, IInterpreter interpreter, IVariableManager variableManager) {
        EObject self = null;
        if (!Util.isBlank((String)description.getReferenceOwnerExpression())) {
            Collection eObjects;
            IEvaluationResult result = interpreter.evaluateExpression(variableManager.getVariables(), description.getReferenceOwnerExpression());
            if (result.success() && (eObjects = result.asEObjects()).size() > 0) {
                self = (EObject)eObjects.iterator().next();
            }
        } else {
            Object selfVariable = variableManager.getVariables().get("self");
            if (selfVariable instanceof EObject) {
                self = (EObject)selfVariable;
            }
        }
        return self;
    }

    private String getReferenceName(EEFExtReferenceDescription description, IInterpreter interpreter, IVariableManager variableManager) {
        IEvaluationResult evaluationResult = interpreter.evaluateExpression(variableManager.getVariables(), description.getReferenceNameExpression());
        if (evaluationResult.success()) {
            return evaluationResult.asString();
        }
        return "";
    }
}

