/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorWizardModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class GeneratorIncrementalBlock {
    private GeneratorWizardModel model;
    private Group incrementalGroup;
    private Button isIncremental;
    private Button removeDeleted;

    public GeneratorIncrementalBlock(GeneratorWizardModel model) {
        this.model = model;
    }

    void createControl(Composite parent) {
        this.incrementalGroup = new Group(parent, 0);
        this.incrementalGroup.setText("Incremental Generation");
        this.incrementalGroup.setLayout((Layout)new GridLayout(1, true));
        this.incrementalGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.isIncremental = new Button((Composite)this.incrementalGroup, 32);
        this.isIncremental.setText("Incremental updates");
        this.isIncremental.setSelection(this.model.isIncremental());
        this.isIncremental.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorIncrementalBlock.this.model.setIncremental(GeneratorIncrementalBlock.this.isIncremental.getSelection());
                GeneratorIncrementalBlock.this.model.validatePage();
            }
        });
        this.removeDeleted = new Button((Composite)this.incrementalGroup, 32);
        this.removeDeleted.setText("Delete obsolete element type configurations");
        this.removeDeleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorIncrementalBlock.this.model.setDeleteObsoleteTypes(GeneratorIncrementalBlock.this.removeDeleted.getSelection());
                GeneratorIncrementalBlock.this.model.validatePage();
            }
        });
        this.removeDeleted.setSelection(this.model.isDeleteObsoleteTypes());
    }

    void validatePage() {
        boolean groupEnabled = this.model.getOutputModelFile().exists();
        this.incrementalGroup.setEnabled(groupEnabled);
        this.isIncremental.setEnabled(groupEnabled);
        this.removeDeleted.setEnabled(groupEnabled && this.isIncremental.getSelection());
    }
}

