/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.UMLService;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class OccurrenceSpecificationHelper {
    public static Interaction getInteraction(Element element) {
        Interaction result = null;
        Element next = element;
        while (next != null && result == null) {
            if (next instanceof Interaction) {
                result = (Interaction)next;
            }
            next = next.getOwner();
        }
        return result;
    }

    public static Stream<TimeConstraint> getTimeConstraints(Interaction interaction, Element constrained) {
        if (interaction == null) {
            return Stream.empty();
        }
        return CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)constrained).stream().filter(setting -> setting.getEStructuralFeature() == UMLPackage.Literals.CONSTRAINT__CONSTRAINED_ELEMENT).map(setting -> (Constraint)setting.getEObject()).filter(TimeConstraint.class::isInstance).filter(c -> c.getConstrainedElements().size() == 1).filter(c -> OccurrenceSpecificationHelper.getInteraction((Element)c) == interaction).map(TimeConstraint.class::cast);
    }

    public static Stream<TimeObservation> getTimeObservations(Interaction interaction, Element observed) {
        if (interaction == null) {
            return Stream.empty();
        }
        return CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)observed).stream().filter(setting -> setting.getEStructuralFeature() == UMLPackage.Literals.TIME_OBSERVATION__EVENT).map(setting -> (TimeObservation)setting.getEObject());
    }

    public static boolean shouldDestroyWithExecution(ExecutionSpecification es, OccurrenceSpecification os, ECrossReferenceAdapter crossReferenceAdapter) {
        return os != null && !(os instanceof MessageOccurrenceSpecification) && (os instanceof ExecutionOccurrenceSpecification || UMLService.isOnlyUsage((EObject)os, (EObject)es, crossReferenceAdapter));
    }

    public static NamedElement findEnclosingElement(OccurrenceSpecification occurrenceSpecification) {
        Objects.requireNonNull(occurrenceSpecification);
        Lifeline coveredLifeline = occurrenceSpecification.getCovered();
        Lifeline enclosingElement = null;
        if (coveredLifeline != null) {
            enclosingElement = coveredLifeline;
            List<Object> fragments = occurrenceSpecification.getEnclosingInteraction() != null ? occurrenceSpecification.getEnclosingInteraction().getFragments().stream().filter(i -> i.getCovereds().contains((Object)coveredLifeline)).toList() : (occurrenceSpecification.getEnclosingOperand() != null ? occurrenceSpecification.getEnclosingOperand().getFragments().stream().filter(i -> i.getCovereds().contains((Object)coveredLifeline)).toList() : List.of());
            ExecutionSpecification enclosingExecutionSpecification = OccurrenceSpecificationHelper.getStartingOrFinishingExecution(occurrenceSpecification);
            if (enclosingExecutionSpecification == null) {
                for (InteractionFragment fragment : fragments) {
                    if (fragment == occurrenceSpecification) break;
                    if (fragment instanceof ExecutionSpecification) {
                        enclosingExecutionSpecification = (ExecutionSpecification)fragment;
                        continue;
                    }
                    if (!(fragment instanceof OccurrenceSpecification)) continue;
                    OccurrenceSpecification occurrenceSpecificationFragment = (OccurrenceSpecification)fragment;
                    if (enclosingExecutionSpecification == null || !Objects.equals(enclosingExecutionSpecification.getFinish(), occurrenceSpecificationFragment)) continue;
                    enclosingExecutionSpecification = null;
                }
            }
            if (enclosingExecutionSpecification != null) {
                enclosingElement = enclosingExecutionSpecification;
            }
        }
        return enclosingElement;
    }

    private static ExecutionSpecification getStartingOrFinishingExecution(OccurrenceSpecification occurrence) {
        return OccurrenceSpecificationHelper.getExecutionFromStartOccurrence(occurrence).orElseGet(() -> OccurrenceSpecificationHelper.getExecutionFromFinishOccurrence(occurrence).orElse(null));
    }

    public static boolean isExecutionStartOccurrence(OccurrenceSpecification occurrence) {
        return OccurrenceSpecificationHelper.getExecutionFromStartOccurrence(occurrence).isPresent();
    }

    public static boolean isExecutionFinishOccurrence(OccurrenceSpecification occurrence) {
        return OccurrenceSpecificationHelper.getExecutionFromFinishOccurrence(occurrence).isPresent();
    }

    public static Optional<ExecutionSpecification> getExecutionFromStartOccurrence(OccurrenceSpecification occurrence) {
        return OccurrenceSpecificationHelper.getExecutionFromOccurrence(occurrence, UMLPackage.eINSTANCE.getExecutionSpecification_Start());
    }

    public static Optional<ExecutionSpecification> getExecutionFromFinishOccurrence(OccurrenceSpecification occurrence) {
        return OccurrenceSpecificationHelper.getExecutionFromOccurrence(occurrence, UMLPackage.eINSTANCE.getExecutionSpecification_Finish());
    }

    private static Optional<ExecutionSpecification> getExecutionFromOccurrence(OccurrenceSpecification occurrence, EReference executionReference) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)occurrence);
        Collection settings = crossReferenceAdapter.getInverseReferences((EObject)occurrence, executionReference, true);
        return settings.stream().map(EStructuralFeature.Setting::getEObject).filter(ExecutionSpecification.class::isInstance).map(ExecutionSpecification.class::cast).findFirst();
    }
}

