/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard.widget;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.ExtensionFilter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileChooser
extends Composite
implements SelectionListener,
Listener {
    private Text text;
    private Button browse;
    private IFile currentFile;
    private Map<String, String> filters = new LinkedHashMap<String, String>();
    private Set<Listener> listeners = new HashSet<Listener>();
    private boolean newFile;
    private IObservableValue<String> textObservable;

    public FileChooser(Composite parent, boolean newFile) {
        super(parent, 0);
        this.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text.addListener(16, (Listener)this);
        this.browse = new Button((Composite)this, 8);
        this.browse.setText(Messages.FileChooser_browseWorkspace);
        this.browse.addSelectionListener((SelectionListener)this);
        this.newFile = newFile;
        IWidgetValueProperty prop = WidgetProperties.text((int)24);
        this.textObservable = prop.observeDelayed(600, (Widget)this.text);
    }

    public String getFilePath() {
        if (this.text.isDisposed()) {
            return null;
        }
        String path = this.text.getText();
        if (path.trim().equals("")) {
            return null;
        }
        return path.trim();
    }

    public void setFilterExtensions(String[] extensions) {
        this.filters.clear();
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.filters.put(ext, ext);
            ++n2;
        }
    }

    public void setFilterExtensions(Map<String, String> extensions) {
        this.filters.clear();
        this.filters.putAll(extensions);
    }

    public void handleEvent(Event event) {
        this.notifyChange();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        Object file;
        Object[] result = new Object[]{};
        if (this.newFile) {
            List<ExtensionFilter> viewerFilter = Collections.singletonList(new ExtensionFilter(this.filters.keySet().toArray(new String[0])));
            IFile file2 = WorkspaceResourceDialog.openNewFile((Shell)this.getShell(), null, null, null, viewerFilter);
            if (file2 != null) {
                result = new IFile[]{file2};
            }
        } else {
            int code;
            LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
            try {
                labelProviderService.startService();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
            ILabelProvider labelProvider = labelProviderService.getLabelProvider();
            IFile currentFile = FileUtil.getIFile((String)this.text.getText());
            TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
            dialog.setTitle("File Selection");
            WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
            contentProvider.setExtensionFilters(this.filters);
            dialog.setContentProvider((ITreeContentProvider)contentProvider);
            dialog.setLabelProvider(labelProvider);
            if (currentFile != null && currentFile.exists()) {
                dialog.setInitialSelections((Object[])new IFile[]{currentFile});
            }
            if ((code = dialog.open()) == 0) {
                result = dialog.getResult();
            }
            try {
                labelProviderService.disposeService();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (result.length > 0 && (file = result[0]) instanceof IFile) {
            this.setFile((IFile)file);
        }
    }

    private void notifyChange() {
        for (Listener listener : this.listeners) {
            listener.handleEvent(null);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public IObservableValue getObservableValue() {
        return this.textObservable;
    }

    public void setText(String s) {
        this.text.setText(s);
    }

    public void setFile(IFile file) {
        if (!Objects.equals(file, this.currentFile) && !this.text.isDisposed()) {
            this.currentFile = file;
            if (file == null) {
                this.text.setText("");
            } else {
                this.text.setText(file.getFullPath().toString());
            }
            this.getObservableValue().getValue();
            this.notifyChange();
        }
    }
}

