/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2document.internal.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.core.internal.logger.DefaultModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatusDialogHelper;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2document.Activator;
import org.eclipse.papyrus.model2doc.emf.template2document.internal.generators.Template2DocumentGeneratorUI;
import org.eclipse.papyrus.model2doc.emf.template2document.internal.messages.Messages;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateStructureAndDocumentHandler
extends AbstractHandler {
    private Template2DocumentGeneratorUI generator = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGenerationStatus status = this.generate((IModel2DocLogger)new DefaultModel2DocLogger(Activator.log));
        GenerationStatusDialogHelper.INSTANCE.openMessageDialog(status);
        return status;
    }

    protected IGenerationStatus generate(IModel2DocLogger logger) {
        IGenerationStatus resultStatus = this.generator.generate(logger);
        return resultStatus;
    }

    public final void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.computeEnable(evaluationContext));
    }

    protected boolean computeEnable(Object evaluationContext) {
        boolean enable;
        DocumentTemplate template = this.getSelectedDocumentTemplate();
        String menuLabel = "noGenerator";
        boolean bl = enable = template != null;
        if (enable) {
            this.generator = new Template2DocumentGeneratorUI(template, (IModel2DocLogger)new DefaultModel2DocLogger(Activator.log));
            if (enable && evaluationContext instanceof IEvaluationContext) {
                ArrayList<String> labels = new ArrayList<String>();
                labels.add(this.generator.getTemplate2StructureGeneratorMenuLabel());
                labels.add(this.generator.getStructure2DocumentGeneratorMenuLabel());
                menuLabel = this.createMenuLabel(labels);
            }
        }
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            iEvaluationContext.addVariable("generatorMenuLabel", (Object)menuLabel);
        }
        return enable;
    }

    protected String createMenuLabel(List<String> labels) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = labels.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(Messages.GenerateStructureAndDocumentHandler_PlusSymbole);
        }
        return builder.toString();
    }

    private DocumentTemplate getSelectedDocumentTemplate() {
        ISelection selection;
        ISelectionService ss;
        IWorkbenchWindow wW;
        Object firstSelectedElement = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wW = wb.getActiveWorkbenchWindow()) != null && (ss = wW.getSelectionService()) != null && (selection = ss.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            firstSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelectedElement instanceof IAdaptable) {
            firstSelectedElement = ((IAdaptable)firstSelectedElement).getAdapter(EObject.class);
        }
        if (firstSelectedElement instanceof DocumentTemplate) {
            return (DocumentTemplate)firstSelectedElement;
        }
        return null;
    }
}

