/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 4096;

    public static void extract(ZipInputStream zip, File target) throws IOException {
        try {
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                int count;
                File file = new File(target, entry.getName());
                if (!file.toPath().normalize().startsWith(target.toPath())) {
                    throw new IOException("Bad zip entry");
                }
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                byte[] buffer = new byte[4096];
                file.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                while ((count = zip.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                out.close();
            }
        }
        finally {
            zip.close();
        }
    }
}

