/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.internal.operations;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypeTemplate;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeTemplateOperations {
    public static final EObject getFirstMatchingStereotypeApplication(StereotypeTemplate stereotypePartTemplate, EObject element) {
        if (!(element instanceof Element)) {
            return null;
        }
        Element el = (Element)element;
        Stereotype matchingStereotype = StereotypeTemplateOperations.getFirstMatchingAppliedStereotype(stereotypePartTemplate, el);
        if (matchingStereotype == null) {
            return null;
        }
        return el.getStereotypeApplication(matchingStereotype);
    }

    private static final Stereotype getFirstMatchingAppliedStereotype(StereotypeTemplate stereotypePartTemplate, Element element) {
        Stereotype matchingStereotype = null;
        Iterator steIter = element.getAppliedStereotypes().iterator();
        while (steIter.hasNext() && matchingStereotype == null) {
            Stereotype stereotype = (Stereotype)steIter.next();
            String stereotypeQualifiedName = stereotypePartTemplate.getStereotypeQualifiedName() == null ? "" : stereotypePartTemplate.getStereotypeQualifiedName();
            switch (stereotypePartTemplate.getStereotypeFilterRule()) {
                case STEREOTYPE_TYPE_OF: {
                    if (!stereotypeQualifiedName.equals(stereotype.getQualifiedName())) break;
                    matchingStereotype = stereotype;
                    break;
                }
                case STEREOTYPE_KIND_OF: {
                    if (stereotypeQualifiedName.equals(stereotype.getQualifiedName())) {
                        matchingStereotype = stereotype;
                        break;
                    }
                    Optional<Stereotype> firstMatchingParent = stereotype.allParents().stream().filter(Stereotype.class::isInstance).map(Stereotype.class::cast).filter(s -> s.getQualifiedName().equals(stereotypeQualifiedName)).findFirst();
                    matchingStereotype = firstMatchingParent.orElse(null);
                    break;
                }
            }
        }
        return matchingStereotype;
    }
}

