/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.providers;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.views.properties.toolsmiths.providers.AbstractContextualContentProvider;

public class PropertyContentProvider
extends AbstractContextualContentProvider
implements IHierarchicContentProvider {
    public PropertyContentProvider(EObject source) {
        super(source);
    }

    public Object[] getElements() {
        return this.contexts.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Context) {
            Context parent = (Context)parentElement;
            return parent.getDataContexts().toArray();
        }
        if (parentElement instanceof DataContextElement) {
            LinkedList result = new LinkedList();
            if (parentElement instanceof DataContextPackage) {
                DataContextPackage contextPackage = (DataContextPackage)parentElement;
                result.addAll(contextPackage.getElements());
            }
            DataContextElement element = (DataContextElement)parentElement;
            result.addAll(element.getProperties());
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                if (!this.isEmpty(value)) continue;
                it.remove();
            }
            return result.toArray();
        }
        return new Object[0];
    }

    protected boolean isEmpty(Object element) {
        if (element instanceof DataContextPackage) {
            DataContextPackage dcPackage = (DataContextPackage)element;
            return dcPackage.getElements().isEmpty() && dcPackage.getProperties().isEmpty();
        }
        if (element instanceof DataContextElement) {
            return ((DataContextElement)element).getProperties().isEmpty();
        }
        if (element instanceof Context) {
            return ((Context)element).getDataContexts().isEmpty();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof Property) {
            return ((Property)element).getContextElement();
        }
        if (element instanceof DataContextElement) {
            return ((DataContextElement)element).getPackage();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public boolean isValidValue(Object element) {
        return element instanceof Property;
    }
}

