/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.handles.CompartmentResizeHandle;

public class CResizableCompartmentEditPolicy
extends ResizableCompartmentEditPolicy {
    public CResizableCompartmentEditPolicy() {
        super(true);
    }

    protected void addCollapsableHandles() {
        this.removeSelectionHandles();
        IFigure layer = this.getLayer("Handle Layer");
        this.handles = this.createCollapseHandles();
        int i = 0;
        while (i < this.handles.size()) {
            layer.add((IFigure)this.handles.get(i));
            ++i;
        }
    }

    protected List createSelectionHandles() {
        ArrayList<CompartmentResizeHandle> selectionHandles = new ArrayList<CompartmentResizeHandle>();
        IGraphicalEditPart part = (IGraphicalEditPart)this.getHost();
        int d1 = this.isHorizontal() ? 8 : 1;
        int d2 = this.isHorizontal() ? 16 : 4;
        selectionHandles.addAll(this.createCollapseHandles());
        selectionHandles.add(new CompartmentResizeHandle(part, d1));
        selectionHandles.add(new CompartmentResizeHandle(part, d2));
        ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), selectionHandles, (int)4);
        return selectionHandles;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        int indexOfTheLast = this.getHost().getParent().getChildren().size() - 1;
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts((EditPart)this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        if (this.getHost().getParent().getChildren().indexOf(this.getHost()) == indexOfTheLast) {
            req.setEditParts(this.getHost().getParent());
            return this.getHost().getParent().getParent().getCommand((Request)req);
        }
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    protected void showSelection() {
        if (this.getHost().getSelected() == 0) {
            this.addCollapsableHandles();
        }
        if (this.getHost().getSelected() == 2) {
            super.showSelection();
        }
    }
}

