/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.PapyrusRoundedEditPartHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;
import org.eclipse.papyrus.uml.diagram.common.editparts.BorderNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AllowResizeAffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PortResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public abstract class RoundedBorderNamedElementEditPart
extends BorderNamedElementEditPart
implements NamedStyleProperties {
    private static final int DEFAULT_BORDER_STYLE = 1;
    private static final int DEFAULT_CORNER_HEIGHT = 0;
    private static final int DEFAULT_CORNER_WIDTH = 0;
    private static final int[] DEFAULT_CUTOM_DASH = new int[]{5, 5};
    private static final int DEFAULT_FLOATING_LABEL_OFFSET_HEIGHT = 0;
    private static final int DEFAULT_FLOATING_LABEL_OFFSET_WIDTH = 0;
    private static final boolean DEFAULT_IS_FLOATING_LABEL_CONSTRAINED = false;
    private static final boolean DEFAULT_IS_OVAL = false;
    private static final boolean DEFAULT_USE_ORIGINAL_COLORS = true;
    private static final boolean DEFAULT_HAS_HEADER = false;
    private static final String DEFAULT_PORT_POSITION_VALUE = PortPositionEnum.ONLINE.toString();
    IChangeListener namedStyleListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            RoundedBorderNamedElementEditPart.this.refresh();
        }
    };
    private IObservableValue ovalObservable;
    private IObservableValue radiusObservableHeight;
    private IObservableValue radiusObservableWidth;
    private IObservableList customDashObservable;
    private IObservableValue shadowWidthObservable;
    private IObservableValue shadowColorObservable;
    private IObservableValue positionObservable;
    private IObservableValue borderStyleObservable;

    public RoundedBorderNamedElementEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PortResizableEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AllowResizeAffixedNodeAlignmentEditPolicy());
    }

    protected int getDefaultBorderStyle() {
        return 1;
    }

    protected int getDefaultCornerHeight() {
        return 0;
    }

    protected int getDefaultCornerWidth() {
        return 0;
    }

    private int[] getDefaultCutomDash() {
        return DEFAULT_CUTOM_DASH;
    }

    protected int getDefaultFloatingLabelOffsetHeight() {
        return 0;
    }

    protected int getDefaultFloatingLabelOffsetWidth() {
        return 0;
    }

    protected boolean getDefaultIsFloatingNameConstrained() {
        return false;
    }

    protected boolean getDefaultIsOvalValue() {
        return false;
    }

    private boolean getDefaultUseOriginalColors() {
        return true;
    }

    @Override
    protected void refreshVisuals() {
        PapyrusRoundedEditPartHelper.refreshRadius((IPapyrusEditPart)this, (int)this.getDefaultCornerWidth(), (int)this.getDefaultCornerHeight());
        PapyrusRoundedEditPartHelper.refreshOval((IPapyrusEditPart)this, (boolean)this.getDefaultIsOvalValue());
        PapyrusRoundedEditPartHelper.refreshBorderStyle((IPapyrusEditPart)this, (int)this.getDefaultBorderStyle(), (int[])this.getDefaultCutomDash());
        PapyrusRoundedEditPartHelper.refreshShadowColor((IPapyrusEditPart)this, (String)this.getDefaultShadowColor());
        this.refreshPortPosition();
        super.refreshVisuals();
    }

    protected int getLineType() {
        return PapyrusRoundedEditPartHelper.getNotationBorderStyle((IPapyrusEditPart)this, (int)this.getDefaultBorderStyle());
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        View view = (View)this.getModel();
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)view);
        this.radiusObservableWidth = new CustomIntStyleObservableValue(view, domain, "radiusWidth");
        this.radiusObservableWidth.addChangeListener(this.namedStyleListener);
        this.radiusObservableHeight = new CustomIntStyleObservableValue(view, domain, "radiusHeight");
        this.radiusObservableHeight.addChangeListener(this.namedStyleListener);
        this.ovalObservable = new CustomBooleanStyleObservableValue(view, domain, "isOval");
        this.ovalObservable.addChangeListener(this.namedStyleListener);
        this.customDashObservable = new CustomStringStyleObservableList(view, domain, "customDash");
        this.customDashObservable.addChangeListener(this.namedStyleListener);
        this.shadowWidthObservable = new CustomIntStyleObservableValue(view, domain, "shadowWidth");
        this.shadowWidthObservable.addChangeListener(this.namedStyleListener);
        this.shadowColorObservable = new CustomStringStyleObservableValue(view, domain, "shadowColor");
        this.shadowColorObservable.addChangeListener(this.namedStyleListener);
        this.positionObservable = new CustomStringStyleObservableValue(view, domain, "portPosition");
        this.positionObservable.addChangeListener(this.namedStyleListener);
        this.borderStyleObservable = new CustomStringStyleObservableValue(view, domain, "borderStyle");
        this.borderStyleObservable.addChangeListener(this.namedStyleListener);
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.radiusObservableWidth.dispose();
        this.radiusObservableHeight.dispose();
        this.ovalObservable.dispose();
        this.customDashObservable.dispose();
        this.shadowWidthObservable.dispose();
        this.shadowColorObservable.dispose();
        this.positionObservable.dispose();
        this.borderStyleObservable.dispose();
    }

    private String getDefaultShadowColor() {
        return null;
    }

    private void refreshPortPosition() {
        Object constraint;
        if (this.getPrimaryShape() instanceof IRoundedRectangleFigure && this.getModel() instanceof View && this.getParent() instanceof AbstractBorderedShapeEditPart && (constraint = ((AbstractBorderedShapeEditPart)this.getParent()).getBorderedFigure().getBorderItemContainer().getLayoutManager().getConstraint(this.getFigure())) instanceof PortPositionLocator) {
            PortPositionLocator portLocator = (PortPositionLocator)constraint;
            String position = NotationUtils.getStringValue((View)((View)this.getModel()), (String)"portPosition", (String)this.getDefaultPortPosition());
            portLocator.setPortPosition(position);
        }
    }

    protected String getDefaultPortPosition() {
        return DEFAULT_PORT_POSITION_VALUE;
    }

    protected boolean getDefaultHasHeader() {
        return false;
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        IBorderItemLocator locator;
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) | NotationPackage.eINSTANCE.getSize_Height().equals(feature) && (locator = this.getBorderItemLocator()) != null) {
            locator.relocate(this.getFigure());
        }
    }

    @Override
    protected abstract IFigure createNodePlate();

    @Override
    protected abstract IFigure createNodeShape();

    @Override
    protected abstract IFigure setupContentPane(IFigure var1);
}

