/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;

public class ElementTypeConfigurationUtil {
    public static boolean isTypeOf(ElementTypeConfiguration elementType, ElementTypeConfiguration elementTypeConfiguration) {
        List<ElementTypeConfiguration> supers;
        boolean isTypeOf = false;
        if (elementTypeConfiguration.equals(elementType)) {
            isTypeOf = true;
        }
        if ((supers = ElementTypeConfigurationUtil.getAllSpecializedTypes(elementType)).contains(elementTypeConfiguration)) {
            isTypeOf = true;
        }
        return isTypeOf;
    }

    public static List<ElementTypeConfiguration> getAllSpecializedTypes(ElementTypeConfiguration elementType) {
        EList specializedTypes;
        ArrayList<ElementTypeConfiguration> result = new ArrayList<ElementTypeConfiguration>();
        result.add(elementType);
        if (elementType instanceof SpecializationTypeConfiguration && !(specializedTypes = ((SpecializationTypeConfiguration)elementType).getSpecializedTypes()).isEmpty()) {
            for (ElementTypeConfiguration elementTypeConfiguration : specializedTypes) {
                result.addAll(ElementTypeConfigurationUtil.getAllSpecializedTypes(elementTypeConfiguration));
            }
        }
        return result;
    }

    public static EClass getFirstCreatedElementEClass(SpecializationTypeConfiguration elementType) {
        EClass eClass = null;
        Optional<MetamodelTypeConfiguration> findFirst = ElementTypeConfigurationUtil.getAllSpecializedTypes((ElementTypeConfiguration)elementType).stream().filter(MetamodelTypeConfiguration.class::isInstance).map(MetamodelTypeConfiguration.class::cast).distinct().findFirst();
        if (findFirst.isPresent()) {
            MetamodelTypeConfiguration elementTypeConfiguration = findFirst.get();
            eClass = elementTypeConfiguration.getEClass();
        }
        return eClass;
    }
}

