/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BorderPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionConfigAttributes;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    public SelectionLayerPainter(Color gridColor) {
        super(gridColor);
    }

    public SelectionLayerPainter() {
    }

    public SelectionLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
    }

    public SelectionLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        boolean insideBorder;
        int iy;
        int rowPosition;
        int ix;
        int columnPosition;
        BorderPainter.PaintModeEnum paintMode;
        BorderPainter.BorderCell[][] borderCells;
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPositionOffset = positionRectangle.x;
        int rowPositionOffset = positionRectangle.y;
        if (positionRectangle.width <= 0 || positionRectangle.height <= 0) {
            return;
        }
        boolean atLeastOne = false;
        if (positionRectangle.width <= 2 && positionRectangle.height <= 2) {
            borderCells = new BorderPainter.BorderCell[positionRectangle.height + 2][positionRectangle.width + 2];
            paintMode = BorderPainter.PaintModeEnum.NO_EXTERNAL_BORDERS;
            columnPosition = columnPositionOffset - 1;
            ix = 0;
            while (columnPosition < columnPositionOffset + positionRectangle.width + 1) {
                rowPosition = rowPositionOffset - 1;
                iy = 0;
                while (rowPosition < rowPositionOffset + positionRectangle.height + 1) {
                    BorderPainter.BorderCell borderCell;
                    boolean toBeConsidered;
                    insideBorder = false;
                    Rectangle cellBounds = null;
                    ILayerCell currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                    if (currentCell != null && (toBeConsidered = this.isInCurrentLayer(ix, iy, xOffset, yOffset, cellBounds = currentCell.getBounds(), borderCells)) && this.isSelected(currentCell)) {
                        insideBorder = true;
                        atLeastOne = true;
                    }
                    Rectangle fixedBounds = this.fixBoundsInGridLines(cellBounds, xOffset, yOffset);
                    borderCells[iy][ix] = borderCell = new BorderPainter.BorderCell(fixedBounds, insideBorder);
                    ++rowPosition;
                    ++iy;
                }
                ++columnPosition;
                ++ix;
            }
        } else {
            borderCells = new BorderPainter.BorderCell[positionRectangle.height][positionRectangle.width];
            paintMode = BorderPainter.PaintModeEnum.ALL;
            columnPosition = columnPositionOffset;
            ix = 0;
            while (columnPosition < columnPositionOffset + positionRectangle.width) {
                rowPosition = rowPositionOffset;
                iy = 0;
                while (rowPosition < rowPositionOffset + positionRectangle.height) {
                    BorderPainter.BorderCell borderCell;
                    insideBorder = false;
                    Rectangle cellBounds = null;
                    ILayerCell currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                    if (currentCell != null) {
                        cellBounds = currentCell.getBounds();
                        if (this.isSelected(currentCell)) {
                            insideBorder = true;
                            atLeastOne = true;
                        }
                    }
                    Rectangle fixedBounds = this.fixBoundsInGridLines(cellBounds, xOffset, yOffset);
                    borderCells[iy][ix] = borderCell = new BorderPainter.BorderCell(fixedBounds, insideBorder);
                    ++rowPosition;
                    ++iy;
                }
                ++columnPosition;
                ++ix;
            }
        }
        if (atLeastOne) {
            int originalLineStyle = gc.getLineStyle();
            int originalLineWidth = gc.getLineWidth();
            Color originalForeground = gc.getForeground();
            BorderStyle borderStyle = this.getBorderStyle(configRegistry);
            BorderPainter borderPainter = new BorderPainter(borderCells, borderStyle, paintMode);
            borderPainter.paintBorder(gc);
            gc.setLineStyle(originalLineStyle);
            gc.setLineWidth(originalLineWidth);
            gc.setForeground(originalForeground);
        }
    }

    private boolean isSelected(ILayerCell cell) {
        return cell.getDisplayMode() == "SELECT" || cell.getDisplayMode() == "SELECT_HOVER";
    }

    protected Rectangle fixBoundsInGridLines(Rectangle cellBounds, int xOffset, int yOffset) {
        if (cellBounds == null) {
            return null;
        }
        Rectangle fixedBounds = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
        if (this.renderGridLines && fixedBounds.x != 0 && fixedBounds.x != xOffset) {
            --fixedBounds.x;
            ++fixedBounds.width;
        }
        if (this.renderGridLines && fixedBounds.y != 0 && fixedBounds.y != yOffset) {
            --fixedBounds.y;
            ++fixedBounds.height;
        }
        return fixedBounds;
    }

    protected boolean isInCurrentLayer(int ix, int iy, int xOffset, int yOffset, Rectangle cellBounds, BorderPainter.BorderCell[][] borderCells) {
        Rectangle prevCellBounds;
        if (ix == 0 && cellBounds.x + cellBounds.width <= xOffset) {
            return false;
        }
        if (iy == 0 && cellBounds.y + cellBounds.height <= yOffset) {
            return false;
        }
        if (ix == 1 && borderCells[iy][ix - 1].isInsideBorder) {
            prevCellBounds = borderCells[iy][ix - 1].bounds;
            if (prevCellBounds.x + prevCellBounds.width > cellBounds.x) {
                borderCells[iy][ix - 1].isInsideBorder = false;
            }
        }
        if (iy == 1 && borderCells[iy - 1][ix].isInsideBorder) {
            prevCellBounds = borderCells[iy - 1][ix].bounds;
            if (prevCellBounds.y + prevCellBounds.height > cellBounds.y) {
                borderCells[iy - 1][ix].isInsideBorder = false;
            }
        }
        if (ix == borderCells[iy].length - 1) {
            prevCellBounds = borderCells[iy][ix - 1].bounds;
            if (prevCellBounds.x + prevCellBounds.width > cellBounds.x) {
                return false;
            }
        }
        if (iy == borderCells.length - 1) {
            prevCellBounds = borderCells[iy - 1][ix].bounds;
            if (prevCellBounds.y + prevCellBounds.height > cellBounds.y) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    protected void applyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(SelectionConfigAttributes.SELECTION_GRID_LINE_STYLE, "SELECT", new String[0]);
        if (borderStyle == null) {
            IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
            BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        }
        if (borderStyle == null) {
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{1, 1});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }

    protected BorderStyle getBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(SelectionConfigAttributes.SELECTION_GRID_LINE_STYLE, "SELECT", new String[0]);
        if (borderStyle == null) {
            IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
            BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        }
        if (borderStyle == null) {
            borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DOTTED, BorderStyle.BorderModeEnum.CENTERED);
        }
        return borderStyle;
    }
}

