/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.newchild.Activator;
import org.eclipse.papyrus.infra.newchild.CreationMenuListener;
import org.eclipse.papyrus.infra.newchild.SetTargetAndRelationshipCommand;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreateRelationshipMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreationMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Separator;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.ui.providers.DelegatingPapyrusContentProvider;
import org.eclipse.papyrus.infra.ui.providers.ISemanticContentProviderFactory;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;

public class CreationMenuFactory {
    private TransactionalEditingDomain editingDomain;
    private Map<String, org.eclipse.swt.widgets.Menu> folderMenus = new HashMap<String, org.eclipse.swt.widgets.Menu>();

    public CreationMenuFactory(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean populateMenu(org.eclipse.swt.widgets.Menu menu, Folder folder, EObject selectedObject, int index, Map<?, ?> adviceCache) {
        MenuItem topMenuItem;
        boolean createdNewMenu;
        if (selectedObject == null || folder == null || !folder.isVisible() || !this.filterMatches(folder, selectedObject)) {
            return false;
        }
        org.eclipse.swt.widgets.Menu topMenu = this.folderMenus.get(folder.getLabel());
        if (topMenu != null) {
            createdNewMenu = false;
            topMenuItem = topMenu.getParentItem();
        } else {
            createdNewMenu = true;
            topMenuItem = new MenuItem(menu, 64, index);
            topMenuItem.setText(folder.getLabel());
            topMenu = new org.eclipse.swt.widgets.Menu(topMenuItem);
            topMenuItem.setMenu(topMenu);
            this.folderMenus.put(folder.getLabel(), topMenu);
        }
        if (topMenuItem.getImage() == null && folder.getIcon() != null && folder.getIcon().length() > 0) {
            URI iconURI = EMFHelper.getImageURI((EObject)folder, (String)folder.getIcon());
            URL url = null;
            try {
                url = new URL(iconURI.toString());
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                topMenuItem.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
            }
            catch (MalformedURLException e) {
                Activator.log.debug(String.format("Invalid folder icon URL '%s': %s", folder.getIcon(), e.getMessage()));
            }
        }
        boolean addedItems = false;
        for (Menu currentMenu : folder.getMenu()) {
            if (currentMenu instanceof Separator) {
                this.constructSeparator(topMenu);
                continue;
            }
            if (currentMenu instanceof Folder) {
                Map<String, org.eclipse.swt.widgets.Menu> folderMenusAtThisLevel = this.folderMenus;
                this.folderMenus = new HashMap<String, org.eclipse.swt.widgets.Menu>();
                try {
                    addedItems |= this.populateMenu(topMenu, (Folder)currentMenu, selectedObject, topMenu.getItemCount(), adviceCache);
                    continue;
                }
                finally {
                    this.folderMenus = folderMenusAtThisLevel;
                }
            }
            if (!(currentMenu instanceof CreationMenu) || !((CreationMenu)currentMenu).isVisible() || !this.filterMatches(currentMenu, selectedObject)) continue;
            CreationMenu currentCreationMenu = (CreationMenu)currentMenu;
            EReference reference = null;
            String role = currentCreationMenu.getRole();
            if (role != null && !role.isEmpty()) {
                EStructuralFeature feature = selectedObject.eClass().getEStructuralFeature(role);
                if (!(feature instanceof EReference)) continue;
                reference = (EReference)feature;
                addedItems |= this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference, adviceCache);
                continue;
            }
            if (currentCreationMenu.isDisplayAllRoles()) {
                addedItems |= this.constructMenu(selectedObject, topMenu, currentCreationMenu, adviceCache);
                continue;
            }
            addedItems |= this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference, adviceCache);
        }
        if (createdNewMenu && !addedItems) {
            this.folderMenus.remove(folder.getLabel());
            topMenu.dispose();
            topMenuItem.dispose();
        }
        return createdNewMenu && addedItems;
    }

    protected void constructSeparator(org.eclipse.swt.widgets.Menu topMenu) {
        new MenuItem(topMenu, 2);
    }

    protected boolean filterMatches(Menu menu, EObject selectedObject) {
        Filter filter = menu.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.matches((Object)selectedObject);
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu menu, CreationMenu currentCreationMenu, Map<?, ?> adviceCache) {
        IClientContext context = null;
        try {
            context = TypeContext.getContext((EObject)selectedObject);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (context != null) {
            EObject target = ElementEditServiceUtils.getTargetFromContext((TransactionalEditingDomain)this.editingDomain, (EObject)selectedObject, (IEditCommandRequest)this.buildRequest(null, selectedObject, currentCreationMenu, adviceCache, context));
            if (target == null) {
                return false;
            }
            ArrayList<EStructuralFeature> possibleEFeatures = this.getEreferences(target, currentCreationMenu, context);
            if (possibleEFeatures.size() == 1) {
                Command cmd = this.buildCommand(null, target, currentCreationMenu, adviceCache, context);
                if (cmd.canExecute()) {
                    MenuItem item = new MenuItem(menu, 0);
                    this.fillIcon(currentCreationMenu, item, context);
                    item.setEnabled(true);
                    item.setText(currentCreationMenu.getLabel());
                    item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
                    return true;
                }
                return false;
            }
            if (possibleEFeatures.size() > 1) {
                MenuItem topMenuItem = new MenuItem(menu, 64);
                topMenuItem.setText(currentCreationMenu.getLabel());
                this.fillIcon(currentCreationMenu, topMenuItem, context);
                org.eclipse.swt.widgets.Menu topMenu = new org.eclipse.swt.widgets.Menu(menu);
                topMenuItem.setMenu(topMenu);
                for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
                    Command cmd = this.buildCommand((EReference)eStructuralFeature, target, currentCreationMenu, adviceCache, context);
                    if (!cmd.canExecute()) continue;
                    MenuItem item = new MenuItem(topMenu, 0);
                    this.fillIcon(currentCreationMenu, item, context);
                    item.setEnabled(true);
                    item.setText("As " + eStructuralFeature.getName());
                    item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
                }
                if (topMenu.getItemCount() == 0) {
                    topMenu.dispose();
                    topMenuItem.dispose();
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fillIcon(CreationMenu currentCreationMenu, MenuItem item, IClientContext context) {
        if (currentCreationMenu.getIcon() != null && !currentCreationMenu.getIcon().isBlank()) {
            URI iconURI = EMFHelper.getImageURI((EObject)currentCreationMenu, (String)currentCreationMenu.getIcon());
            try {
                URL url = new URL(iconURI.toString());
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                item.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
            }
            catch (MalformedURLException e) {
                Activator.log.debug(String.format("Invalid creation menu icon URL '%s': %s", currentCreationMenu.getIcon(), e.getMessage()));
            }
        } else {
            this.createIconFromElementType(currentCreationMenu, item, context);
        }
    }

    protected ArrayList<EStructuralFeature> getEreferences(EObject selectedObject, CreationMenu currentCreationMenu, IClientContext context) {
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = selectedObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : featureList) {
            IElementType menuType;
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || (menuType = this.getElementType(currentCreationMenu.getElementType(), context)) == null || !this.isSubClass(ref.getEType(), menuType.getEClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        return possibleEFeatures;
    }

    protected boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    protected void createIconFromElementType(CreationMenu currentCreationMenu, MenuItem item, IClientContext context) {
        URL iconURL;
        IElementType elementType = this.getElementType(currentCreationMenu.getElementType(), context);
        if (elementType != null && (iconURL = elementType.getIconURL()) != null) {
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)iconURL);
            item.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
        }
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu topMenu, CreationMenu currentCreationMenu, EReference reference, Map<?, ?> adviceCache) {
        IClientContext context = null;
        try {
            context = TypeContext.getContext((EObject)selectedObject);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (context != null) {
            boolean oneDisplayedMenu = false;
            Command cmd = this.buildCommand(reference, selectedObject, currentCreationMenu, adviceCache, context);
            if (cmd.canExecute()) {
                oneDisplayedMenu = true;
                MenuItem item = new MenuItem(topMenu, 0);
                this.fillIcon(currentCreationMenu, item, context);
                item.setEnabled(true);
                item.setText(currentCreationMenu.getLabel());
                item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
            }
            return oneDisplayedMenu;
        }
        return false;
    }

    protected IElementType getElementType(ElementTypeConfiguration elementTypeConfiguration, IClientContext context) {
        IElementType type = ElementTypeRegistry.getInstance().getType(elementTypeConfiguration.getIdentifier());
        return type != null && context.includes(type) ? type : null;
    }

    protected Command buildCommand(EReference reference, EObject container, CreationMenu creationMenu, Map<?, ?> adviceCache, IClientContext context) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container, (IClientContext)context);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        IElementType elementType = this.getElementType(creationMenu.getElementType(), context);
        if (elementType == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Object createGMFCommand = null;
        if (creationMenu instanceof CreateRelationshipMenu) {
            IElementEditService serviceProvider = ElementEditServiceUtils.getCommandProvider((Object)elementType, (IClientContext)context);
            TreeSelectorDialog dialog = this.getTargetTreeSelectorDialog(container, serviceProvider, this.editingDomain, reference, container, elementType);
            if (dialog != null) {
                createGMFCommand = new SetTargetAndRelationshipCommand(this.editingDomain, "Create " + elementType.getDisplayName(), serviceProvider, reference, container, elementType, (ITreeSelectorDialog)dialog);
            }
        } else {
            CreateElementRequest request = this.buildRequest(reference, container, creationMenu, adviceCache, context);
            if (request != null) {
                createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
            } else {
                return UnexecutableCommand.INSTANCE;
            }
        }
        if (createGMFCommand != null) {
            Command emfCommand = GMFtoEMFCommandWrapper.wrap((ICommand)createGMFCommand);
            return emfCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CreateElementRequest buildRequest(EReference reference, EObject container, CreationMenu creationMenu, Map<?, ?> adviceCache, IClientContext context) {
        IElementType elementtype = this.getElementType(creationMenu.getElementType(), context);
        Object request = null;
        request = reference == null ? (creationMenu instanceof CreateRelationshipMenu ? new CreateRelationshipRequest(this.editingDomain, null, container, null, elementtype) : new CreateElementRequest(this.editingDomain, container, elementtype)) : (creationMenu instanceof CreateRelationshipMenu ? new CreateRelationshipRequest(this.editingDomain, null, container, null, elementtype, reference) : new CreateElementRequest(this.editingDomain, container, elementtype, reference));
        request.setParameter("Cache_Maps", adviceCache);
        return request;
    }

    protected CreateElementRequest buildRequest(EReference reference, EObject container, CreationMenu creationMenu, IClientContext context) {
        IElementType elementtype = this.getElementType(creationMenu.getElementType(), context);
        if (elementtype != null) {
            if (reference == null) {
                if (creationMenu instanceof CreateRelationshipMenu) {
                    CreateRelationshipRequest createRelationshipRequest = new CreateRelationshipRequest(this.editingDomain, null, container, null, elementtype);
                    return createRelationshipRequest;
                }
                return new CreateElementRequest(this.editingDomain, container, elementtype);
            }
            if (creationMenu instanceof CreateRelationshipMenu) {
                CreateRelationshipRequest createRelationshipRequest = new CreateRelationshipRequest(this.editingDomain, null, container, null, elementtype, reference);
                return createRelationshipRequest;
            }
            return new CreateElementRequest(this.editingDomain, container, elementtype, reference);
        }
        return null;
    }

    protected TreeSelectorDialog getTargetTreeSelectorDialog(EObject eobject, final IElementEditService provider, final TransactionalEditingDomain ted, final EReference reference, final EObject container, final IElementType et) {
        ILabelProvider labelProvider = null;
        try {
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eobject)).getLabelProvider();
        }
        catch (Exception ex) {
            Activator.log.error("Impossible to get a label provider from object " + eobject, (Throwable)ex);
            return null;
        }
        SemanticService semanticService = null;
        try {
            semanticService = (SemanticService)ServiceUtilsForEObject.getInstance().getService(SemanticService.class, (Object)eobject);
        }
        catch (Exception e) {
            Activator.log.error("Could not get the SemanticService for " + eobject, (Throwable)e);
            return null;
        }
        IModel[] models = semanticService.getSemanticIModels();
        Optional<ISemanticContentProviderFactory> factory = Stream.of(models).map(m -> (ISemanticContentProviderFactory)m.getAdapter(ISemanticContentProviderFactory.class)).filter(Objects::nonNull).reduce(ISemanticContentProviderFactory::compose);
        ResourceSet rs = eobject.eResource().getResourceSet();
        ITreeContentProvider delegate = factory.orElse(SemanticEMFContentProvider::new).createSemanticContentProvider(rs);
        DelegatingPapyrusContentProvider contentProvider = new DelegatingPapyrusContentProvider(delegate){

            public boolean isValidValue(Object element) {
                if (element == null) {
                    return false;
                }
                EObject eobject = EMFHelper.getEObject((Object)element);
                CreateRelationshipRequest buildRequest = null;
                buildRequest = reference == null ? new CreateRelationshipRequest(ted, null, container, eobject, et) : new CreateRelationshipRequest(ted, null, container, eobject, et);
                ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)buildRequest);
                if (createGMFCommand == null) {
                    return false;
                }
                boolean canExecute = createGMFCommand.canExecute();
                return canExecute;
            }
        };
        EMFGraphicalContentProvider graphicalContentProvider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)"target");
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        dialog.setContentProvider((ITreeContentProvider)graphicalContentProvider);
        dialog.setLabelProvider(labelProvider);
        dialog.setMessage("Choose the target element");
        dialog.setTitle("Target Element Selection");
        dialog.setInput((Object)EcoreUtil.getRootContainer((EObject)eobject));
        return dialog;
    }
}

