/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Anna Karjakina (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.actions.CreateShortcutAction;
import impl.diagram.editparts.CompartmentEditPart;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import parsers.PredefinedParser;
import xpt.application.ActionBarAdvisor;
import xpt.application.WizardNewFileCreationPage;
import xpt.application.WorkbenchWindowAdvisor;
import xpt.diagram.editpolicies.OpenDiagram;
import xpt.editor.CreationWizard;
import xpt.editor.CreationWizardPage;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.DocumentProvider;
import xpt.editor.Editor;
import xpt.editor.ElementChooser;
import xpt.editor.InitDiagramFileAction;
import xpt.editor.ModelElementSelectionPage;
import xpt.editor.NewDiagramFileWizard;
import xpt.editor.ShortcutCreationWizard;
import xpt.editor.ValidateAction;
import xpt.editor.palette.PaletteFactory;
import xpt.navigator.NavigatorActionProvider;
import xpt.navigator.NavigatorContentProvider;
import xpt.providers.ModelingAssistantProvider;

@Singleton
@SuppressWarnings("all")
public class Externalizer {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private CreateShortcutAction createShortcutAction;
  
  @Inject
  private CreationWizard creationWizard;
  
  @Inject
  private CreationWizardPage creationWizardPage;
  
  @Inject
  private DiagramEditorUtil diagramEditorUtil;
  
  @Inject
  private DocumentProvider documentProvider;
  
  @Inject
  private InitDiagramFileAction initDiagramFileAction;
  
  @Inject
  private NewDiagramFileWizard newDiagramFileWizard;
  
  @Inject
  private Editor editor;
  
  @Inject
  private ElementChooser elementChooser;
  
  @Inject
  private ShortcutCreationWizard shortcutCreationWizard;
  
  @Inject
  private ModelElementSelectionPage modelElementSelectionPage;
  
  @Inject
  private ValidateAction validateAction;
  
  @Inject
  private PaletteFactory paletteFactory;
  
  @Inject
  private ActionBarAdvisor actionBarAdvisor;
  
  @Inject
  private WorkbenchWindowAdvisor workbenchWindowAdvisor;
  
  @Inject
  private WizardNewFileCreationPage wizardNewFileCreationPage;
  
  @Inject
  private CompartmentEditPart compartmentEditPart;
  
  @Inject
  private OpenDiagram openDiagram;
  
  @Inject
  private NavigatorContentProvider navigatorContentProvider;
  
  @Inject
  private NavigatorActionProvider navigatorActionProvider;
  
  @Inject
  private PredefinedParser predefinedParser;
  
  @Inject
  private ModelingAssistantProvider modelingAssistantProvider;
  
  @MetaDef
  public CharSequence accessorCall(final GenEditorGenerator it, final String key) {
    StringConcatenation _builder = new StringConcatenation();
    String _externalizerPackageName = this._externalizerUtils_qvto.getExternalizerPackageName(it);
    _builder.append(_externalizerPackageName);
    _builder.append(".");
    CharSequence _accessClassName = this.accessClassName(it);
    _builder.append(_accessClassName);
    _builder.append(".");
    String _escapeIllegalKeySymbols = this._externalizerUtils_qvto.escapeIllegalKeySymbols(key);
    _builder.append(_escapeIllegalKeySymbols);
    return _builder;
  }
  
  @MetaDef
  public CharSequence accessorField(final String key) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    String _escapeIllegalKeySymbols = this._externalizerUtils_qvto.escapeIllegalKeySymbols(key);
    _builder.append(_escapeIllegalKeySymbols);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence messageEntry(final String key, final String message) {
    StringConcatenation _builder = new StringConcatenation();
    String _escapeIllegalKeySymbols = this._externalizerUtils_qvto.escapeIllegalKeySymbols(key);
    _builder.append(_escapeIllegalKeySymbols);
    _builder.append("=");
    String _escapeIllegalMessageSymbols = this._externalizerUtils_qvto.escapeIllegalMessageSymbols(message);
    _builder.append(_escapeIllegalMessageSymbols);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence accessClassName(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _externalizerClassName = this._externalizerUtils_qvto.getExternalizerClassName();
    _builder.append(_externalizerClassName);
    return _builder;
  }
  
  public CharSequence accessPackageName(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _externalizerPackageName = this._externalizerUtils_qvto.getExternalizerPackageName(it);
    _builder.append(_externalizerPackageName);
    return _builder;
  }
  
  public CharSequence Access(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it);
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _accessPackageName = this.accessPackageName(it);
    _builder.append(_accessPackageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _accessClassName = this.accessClassName(it);
    _builder.append(_accessClassName);
    _builder.append(" extends org.eclipse.osgi.util.NLS {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("static {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.osgi.util.NLS.initializeMessages(\"");
    String _lowerCase = this.accessClassName(it).toString().toLowerCase();
    _builder.append(_lowerCase, "\t\t");
    _builder.append("\", ");
    CharSequence _accessClassName_1 = this.accessClassName(it);
    _builder.append(_accessClassName_1, "\t\t");
    _builder.append(".class); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private ");
    CharSequence _accessClassName_2 = this.accessClassName(it);
    _builder.append(_accessClassName_2, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _Fields = this.Fields(it);
    _builder.append(_Fields, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("//TODO: put accessor fields manually\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence Fields(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _i18nAccessors = this.createShortcutAction.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_1 = this.creationWizard.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_1);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_2 = this.creationWizardPage.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_2);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_3 = this.diagramEditorUtil.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_3);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_4 = this.documentProvider.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_4);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_5 = this.initDiagramFileAction.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_5);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_6 = this.newDiagramFileWizard.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_6);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_7 = this.editor.i18nAccessors(it.getEditor());
    _builder.append(_i18nAccessors_7);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_8 = this.elementChooser.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_8);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_9 = this.shortcutCreationWizard.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_9);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_10 = this.modelElementSelectionPage.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_10);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_11 = this.validateAction.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_11);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_12 = this.paletteFactory.i18nAccessors(it.getDiagram().getPalette());
    _builder.append(_i18nAccessors_12);
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getApplication();
      boolean _notEquals = (!Objects.equal(_application, null));
      if (_notEquals) {
        CharSequence _i18nAccessors_13 = this.actionBarAdvisor.i18nAccessors(it.getApplication());
        _builder.append(_i18nAccessors_13);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nAccessors_14 = this.workbenchWindowAdvisor.i18nAccessors(it.getApplication());
        _builder.append(_i18nAccessors_14);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nAccessors_15 = this.wizardNewFileCreationPage.i18nAccessors(it.getApplication());
        _builder.append(_i18nAccessors_15);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _i18nAccessors_16 = this.compartmentEditPart.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_16);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_17 = this.openDiagram.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_17);
    _builder.newLineIfNotEmpty();
    {
      GenNavigator _navigator = it.getNavigator();
      boolean _notEquals_1 = (!Objects.equal(_navigator, null));
      if (_notEquals_1) {
        CharSequence _i18nAccessors_18 = this.navigatorContentProvider.i18nAccessors(it.getNavigator());
        _builder.append(_i18nAccessors_18);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nAccessors_19 = this.navigatorActionProvider.i18nAccessors(it.getNavigator());
        _builder.append(_i18nAccessors_19);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      GenParsers _labelParsers = it.getLabelParsers();
      boolean _notEquals_2 = (!Objects.equal(_labelParsers, null));
      if (_notEquals_2) {
        CharSequence _i18nAccessors_20 = this.predefinedParser.i18nAccessors(it.getLabelParsers());
        _builder.append(_i18nAccessors_20);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _i18nAccessors_21 = this.modelingAssistantProvider.i18nAccessors(it.getDiagram());
    _builder.append(_i18nAccessors_21);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence Values(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append("# TODO: manually put keys and values");
    _builder.newLine();
    CharSequence _i18nValues = this.createShortcutAction.i18nValues(it.getDiagram());
    _builder.append(_i18nValues);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_1 = this.creationWizard.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_1);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_2 = this.creationWizardPage.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_2);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_3 = this.diagramEditorUtil.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_3);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_4 = this.documentProvider.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_4);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_5 = this.initDiagramFileAction.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_5);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_6 = this.newDiagramFileWizard.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_6);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_7 = this.editor.i18nValues(it.getEditor());
    _builder.append(_i18nValues_7);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_8 = this.elementChooser.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_8);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_9 = this.shortcutCreationWizard.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_9);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_10 = this.modelElementSelectionPage.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_10);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_11 = this.validateAction.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_11);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_12 = this.paletteFactory.i18nValues(it.getDiagram().getPalette());
    _builder.append(_i18nValues_12);
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getApplication();
      boolean _notEquals = (!Objects.equal(_application, null));
      if (_notEquals) {
        CharSequence _i18nValues_13 = this.actionBarAdvisor.i18nValues(it.getApplication());
        _builder.append(_i18nValues_13);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nValues_14 = this.workbenchWindowAdvisor.i18nValues(it.getApplication());
        _builder.append(_i18nValues_14);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nValues_15 = this.wizardNewFileCreationPage.i18nValues(it.getApplication());
        _builder.append(_i18nValues_15);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _i18nValues_16 = this.compartmentEditPart.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_16);
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_17 = this.openDiagram.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_17);
    _builder.newLineIfNotEmpty();
    {
      GenNavigator _navigator = it.getNavigator();
      boolean _notEquals_1 = (!Objects.equal(_navigator, null));
      if (_notEquals_1) {
        CharSequence _i18nValues_18 = this.navigatorContentProvider.i18nValues(it.getNavigator());
        _builder.append(_i18nValues_18);
        _builder.newLineIfNotEmpty();
        CharSequence _i18nValues_19 = this.navigatorActionProvider.i18nValues(it.getNavigator());
        _builder.append(_i18nValues_19);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      GenParsers _labelParsers = it.getLabelParsers();
      boolean _notEquals_2 = (!Objects.equal(_labelParsers, null));
      if (_notEquals_2) {
        CharSequence _i18nValues_20 = this.predefinedParser.i18nValues(it.getLabelParsers());
        _builder.append(_i18nValues_20);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _i18nValues_21 = this.modelingAssistantProvider.i18nValues(it.getDiagram());
    _builder.append(_i18nValues_21);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
