/*******************************************************************************
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, ARTAL
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *     Borland - initial API and implementation
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 ******************************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.gmf.internal.bridge.trace.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.internal.bridge.trace.AbstractTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenChildNodeTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenCompartmentTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkLabelTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeLabelTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.MatchingTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.ToolGroupTrace;
import org.eclipse.papyrus.gmf.internal.bridge.trace.TraceModel;
import org.eclipse.papyrus.gmf.internal.bridge.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.TracePackage
 * @generated
 */
public class TraceAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TracePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TracePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TraceSwitch<Adapter> modelSwitch =
		new TraceSwitch<Adapter>() {
			@Override
			public Adapter caseTraceModel(TraceModel object) {
				return createTraceModelAdapter();
			}
			@Override
			public Adapter caseAbstractTrace(AbstractTrace object) {
				return createAbstractTraceAdapter();
			}
			@Override
			public Adapter caseMatchingTrace(MatchingTrace object) {
				return createMatchingTraceAdapter();
			}
			@Override
			public Adapter caseGenNodeTrace(GenNodeTrace object) {
				return createGenNodeTraceAdapter();
			}
			@Override
			public Adapter caseGenChildNodeTrace(GenChildNodeTrace object) {
				return createGenChildNodeTraceAdapter();
			}
			@Override
			public Adapter caseGenNodeLabelTrace(GenNodeLabelTrace object) {
				return createGenNodeLabelTraceAdapter();
			}
			@Override
			public Adapter caseGenLinkTrace(GenLinkTrace object) {
				return createGenLinkTraceAdapter();
			}
			@Override
			public Adapter caseGenCompartmentTrace(GenCompartmentTrace object) {
				return createGenCompartmentTraceAdapter();
			}
			@Override
			public Adapter caseGenLinkLabelTrace(GenLinkLabelTrace object) {
				return createGenLinkLabelTraceAdapter();
			}
			@Override
			public Adapter caseToolGroupTrace(ToolGroupTrace object) {
				return createToolGroupTraceAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.TraceModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.TraceModel
	 * @generated
	 */
	public Adapter createTraceModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.AbstractTrace <em>Abstract Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.AbstractTrace
	 * @generated
	 */
	public Adapter createAbstractTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.MatchingTrace <em>Matching Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.MatchingTrace
	 * @generated
	 */
	public Adapter createMatchingTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeTrace <em>Gen Node Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeTrace
	 * @generated
	 */
	public Adapter createGenNodeTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenChildNodeTrace <em>Gen Child Node Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenChildNodeTrace
	 * @generated
	 */
	public Adapter createGenChildNodeTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeLabelTrace <em>Gen Node Label Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenNodeLabelTrace
	 * @generated
	 */
	public Adapter createGenNodeLabelTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkTrace <em>Gen Link Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkTrace
	 * @generated
	 */
	public Adapter createGenLinkTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenCompartmentTrace <em>Gen Compartment Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenCompartmentTrace
	 * @generated
	 */
	public Adapter createGenCompartmentTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkLabelTrace <em>Gen Link Label Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.GenLinkLabelTrace
	 * @generated
	 */
	public Adapter createGenLinkLabelTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.gmf.internal.bridge.trace.ToolGroupTrace <em>Tool Group Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.gmf.internal.bridge.trace.ToolGroupTrace
	 * @generated
	 */
	public Adapter createToolGroupTraceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //TraceAdapterFactory
