/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.ExpressionHelper;

public class ErrorStatement
extends Statement {
    private final ExpressionHelper message;

    public ErrorStatement(int start, int end, int line, OCLExpressionCS msg) {
        super(start, end, line);
        this.message = new ExpressionHelper(msg, this);
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        this.message.analyze(ctx, issues);
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        String result = String.valueOf(this.message.evaluate(ctx));
        throw new RuntimeException(MessageFormat.format("Error in {0}:{1}: {2}", this.getFileName(), this.getLine(), result));
    }

    ExpressionHelper getMessage() {
        return this.message;
    }
}

