/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.Activator;
import org.eclipse.papyrus.uml.tools.utils.StaticProfileUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LocalProfileIndex {
    private final ResourceSet resourceSet;
    private boolean workspaceLoaded;
    private final Map<String, Profile> profilesByName = new HashMap<String, Profile>();
    private final Map<String, Profile> profilesByURI = new HashMap<String, Profile>();
    private final Map<String, Stereotype> stereotypesByName = new HashMap<String, Stereotype>();

    private LocalProfileIndex(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    static LocalProfileIndex getInstance(EObject eObject, Map<Object, Object> context) {
        return (LocalProfileIndex)context.computeIfAbsent(LocalProfileIndex.class, __ -> LocalProfileIndex.getInstance(eObject.eResource().getResourceSet()));
    }

    static LocalProfileIndex getInstance(ResourceSet resourceSet) {
        return Attachment.getIndex(resourceSet);
    }

    void reset() {
        this.workspaceLoaded = false;
        this.profilesByName.clear();
        this.profilesByURI.clear();
        this.stereotypesByName.clear();
    }

    public Profile getProfile(String qualifiedName, EObject context) {
        Profile result = this.profilesByName.get(qualifiedName);
        if (result == null) {
            block2: for (URI registeredProfile : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
                try {
                    Resource resource = this.resourceSet.getResource(registeredProfile.trimFragment(), true);
                    Collection loadedProfiles = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PROFILE);
                    for (Profile profile : loadedProfiles) {
                        if (!qualifiedName.equals(profile.getQualifiedName())) continue;
                        result = profile;
                        this.profilesByName.put(qualifiedName, result);
                        break block2;
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Failed to load registered profile.", (Throwable)e);
                }
            }
            if (result == null) {
                this.loadWorkspace();
                result = this.profilesByName.get(qualifiedName);
            }
        }
        return result;
    }

    public Profile getProfileByURI(String profileURI, EObject context) {
        Profile result = this.profilesByURI.get(profileURI);
        if (result == null) {
            ResourceSet rset = context.eResource().getResourceSet();
            EPackage ePackage = rset.getPackageRegistry().getEPackage(profileURI);
            Profile profile = result = ePackage != null ? UMLUtil.getProfile((EPackage)ePackage, (EObject)context) : null;
            if (result != null) {
                this.profilesByURI.put(profileURI, result);
            } else {
                this.loadWorkspace();
                result = this.profilesByURI.get(profileURI);
            }
        }
        return result;
    }

    public Stereotype getStereotype(String qualifiedName, Collection<String> profileQualifiedNames, EObject context) {
        Stereotype result = null;
        Iterator<String> iter = profileQualifiedNames.iterator();
        while (iter.hasNext() && result == null) {
            Profile profile;
            String profileName = iter.next();
            if (!qualifiedName.startsWith(String.valueOf(profileName) + "::") || (profile = this.getProfile(profileName, context)) == null) continue;
            result = this.getStereotype(qualifiedName, profile, context);
        }
        if (result == null) {
            this.loadWorkspace();
            result = this.stereotypesByName.get(qualifiedName);
        }
        return result;
    }

    public Stereotype getStereotype(String qualifiedName, Profile profile, EObject context) {
        return UMLUtil.findNamedElements((Resource)profile.eResource(), (String)qualifiedName, (boolean)false, (EClass)UMLPackage.Literals.STEREOTYPE).stream().findAny().orElse(null);
    }

    public Stereotype getStereotype(String qualifiedName, EObject context) {
        Stereotype result;
        int profileNameLength = qualifiedName.lastIndexOf("::");
        if (profileNameLength < 0) {
            result = null;
        } else {
            String profileQualifiedName = qualifiedName.substring(0, profileNameLength);
            Profile profile = this.getProfile(profileQualifiedName, context);
            if (profile != null) {
                result = this.getStereotype(qualifiedName, profile, context);
            } else {
                this.loadWorkspace();
                result = this.stereotypesByName.get(qualifiedName);
            }
        }
        return result;
    }

    private void loadWorkspace() {
        if (!this.workspaceLoaded) {
            this.workspaceLoaded = true;
            ModelResourceMapper profileMapper = new ModelResourceMapper((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            profileMapper.map(ModelResourceMapper.byExtension((String)"uml"), __ -> this.resourceSet, ModelResourceMapper.rootsOfType(Profile.class)).values().stream().distinct().forEach(this::mapProfile);
        }
    }

    private void mapProfile(Profile profile) {
        String uri;
        String qName = profile.getQualifiedName();
        if (qName != null && !qName.isBlank()) {
            this.profilesByName.put(qName, profile);
            for (Stereotype stereo : profile.getOwnedStereotypes()) {
                String stereoName = stereo.getQualifiedName();
                if (stereoName == null || stereoName.isBlank()) continue;
                this.stereotypesByName.put(stereoName, stereo);
            }
        }
        if ((uri = LocalProfileIndex.getProfileURI(profile)) != null && !uri.isBlank()) {
            this.profilesByURI.put(uri, profile);
        }
        for (Package nested : profile.getNestedPackages()) {
            if (!(nested instanceof Profile)) continue;
            this.mapProfile((Profile)nested);
        }
    }

    private static String getProfileURI(Profile profile) {
        return new StaticProfileUtil(profile).getDefinition().getNsURI();
    }

    private static final class Attachment
    extends AdapterImpl {
        private final LocalProfileIndex index;

        Attachment(LocalProfileIndex index) {
            this.index = index;
        }

        static LocalProfileIndex getIndex(ResourceSet rset) {
            Attachment attachment = (Attachment)EcoreUtil.getAdapter((List)rset.eAdapters(), LocalProfileIndex.class);
            if (attachment == null) {
                attachment = new Attachment(new LocalProfileIndex(rset));
                rset.eAdapters().add((Object)attachment);
            }
            return attachment.getIndex();
        }

        public boolean isAdapterForType(Object type) {
            return type == LocalProfileIndex.class;
        }

        LocalProfileIndex getIndex() {
            return this.index;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof ResourceSet && msg.getFeatureID(ResourceSet.class) == 0) {
                this.getIndex().reset();
            }
        }
    }
}

