/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureCommandUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationPackage;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureDependencies;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitecturePluginXMLValidator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;

public class ArchitecturePluginChecker {
    public static final String ARCHITECTURE_EXTENSION = "architecture";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.architecture");

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").withReferencedResources(ArchitecturePluginChecker.createIconProvider());
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(ArchitecturePluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").addRequirements(ArchitecturePluginChecker::getRequiredCommandBundleDependencies).withReferencedResources(ArchitecturePluginChecker.createOpaqueResourceProvider(project));
    }

    private static OpaqueResourceProvider.EMF createIconProvider() {
        return OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.ICON, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (EAttribute)ArchitecturePackage.Literals.AD_ELEMENT__ICON).and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.ICON, (String)"http://www.eclipse.org/papyrus/infra/gmfdiag/representation", (EAttribute)ArchitecturePackage.Literals.REPRESENTATION_KIND__GRAYED_ICON));
    }

    private static OpaqueResourceProvider.EMF createOpaqueResourceProvider(IProject project) {
        ArchitectureDependencies dependencies = new ArchitectureDependencies(project);
        return ArchitecturePluginChecker.createIconProvider().and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (EAttribute)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS, dependencies::getClassURI)).and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (EAttribute)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS, dependencies::getClassURI)).and(OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.CLASS, (String)"http://www.eclipse.org/papyrus/infra/gmfdiag/representation", (EAttribute)RepresentationPackage.Literals.PAPYRUS_DIAGRAM__CREATION_COMMAND_CLASS, dependencies::getClassURI));
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<ArchitectureDomain, PluginErrorReporter<ArchitectureDomain>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection domains = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ArchitecturePackage.Literals.ARCHITECTURE_DOMAIN);
        return new ExtensionsChecker(project, modelFile, domains, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", ArchitecturePluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<ArchitectureDomain> createPluginErrorReporter(IFile pluginXML, IFile modelFile, ArchitectureDomain model) {
        ArchitecturePluginXMLValidator validator = new ArchitecturePluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", domain -> domain.getId()).requireExtensionPoint("org.eclipse.papyrus.infra.architecture.models", validator::matchExtension, null, validator::problemID);
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").withValidator("http://www.eclipse.org/papyrus/infra/core/architecture", ArchitectureCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/infra/gmfdiag/representation", ArchitectureCustomValidator::new);
    }

    private static Set<String> getRequiredCommandBundleDependencies(Resource modelResource) {
        return modelResource.getContents().stream().map(ArchitectureCommandUtils::getRequiredCommandBundleDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

