/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureCommandUtils;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class ArchitectureDependencies {
    private final String hostBundle;

    ArchitectureDependencies(IProject project) {
        this.hostBundle = Optional.ofNullable(PluginRegistry.findModel((IProject)project)).map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName).orElse(project.getName());
    }

    URI getClassURI(EObject owner, EAttribute attribute, String className) {
        Optional<Object> bundleName;
        Object commandClass = ArchitectureCommandUtils.getCommandClass((EObject)owner, (EStructuralFeature)attribute);
        if (commandClass instanceof Class) {
            Bundle bundle = FrameworkUtil.getBundle((Class)((Class)commandClass));
            bundleName = Optional.ofNullable(bundle).map(Bundle::getSymbolicName);
        } else if (commandClass instanceof IType) {
            Optional<IPluginModelBase> plugin = Optional.empty();
            IType commandType = (IType)commandClass;
            if (commandType.isBinary()) {
                IPackageFragmentRoot jar = (IPackageFragmentRoot)commandType.getAncestor(3);
                if (jar != null) {
                    IPath jarPath = jar.getPath();
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(jarPath);
                    if (file != null && file.isAccessible()) {
                        plugin = Optional.ofNullable(PluginRegistry.findModel((IProject)file.getProject()));
                    } else {
                        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getExternalModels();
                        int n = iPluginModelBaseArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPluginModelBase next = iPluginModelBaseArray[n2];
                            Path path = new Path(next.getInstallLocation());
                            if (jarPath.equals((Object)path) || path.isPrefixOf(jarPath)) {
                                plugin = Optional.of(next);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            } else {
                plugin = Optional.of(((IType)commandClass).getJavaProject()).map(IJavaProject::getProject).map(PluginRegistry::findModel);
            }
            bundleName = plugin.map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName);
        } else {
            bundleName = Optional.empty();
        }
        return URI.createURI((String)String.format("bundleclass://%s/%s", bundleName.orElse(this.hostBundle), className));
    }
}

