/*
 * Decompiled with CFR 0.152.
 */
package xpt.navigator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.editor.VisualIDRegistry;
import xpt.navigator.AbstractNavigatorItem;
import xpt.navigator.NavigatorGroup;
import xpt.navigator.NavigatorItem;
import xpt.navigator.Utils_qvto;
import xpt.navigator.getEditorInput;

@Singleton
public class NavigatorLinkHelper {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private Activator xptActivator;
    @Inject
    private getEditorInput xptGetEditorInput;
    @Inject
    private AbstractNavigatorItem abstractNavigatorItem;
    @Inject
    private NavigatorGroup navigatorGroup;
    @Inject
    private NavigatorItem xptNavigatorItem;

    public CharSequence className(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _linkHelperClassName = it.getLinkHelperClassName();
        _builder.append(_linkHelperClassName);
        return _builder;
    }

    public CharSequence packageName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence NavigatorLinkHelper(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" implements org.eclipse.ui.navigator.ILinkHelper {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _editorInput = this.xptGetEditorInput.getEditorInput(it.getEditorGen());
        _builder.append((Object)_editorInput, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _findSelection = this.findSelection(it);
        _builder.append((Object)_findSelection, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _activateEditor = this.activateEditor(it);
        _builder.append((Object)_activateEditor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence findSelection(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.jface.viewers.IStructuredSelection findSelection(org.eclipse.ui.IEditorInput anInput) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _defineDiagramDocument = this.defineDiagramDocument(it.getEditorGen().getPlugin());
        _builder.append((Object)_defineDiagramDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _findSelectionBody = this.findSelectionBody(it);
        _builder.append((Object)_findSelectionBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence defineDiagramDocument(GenPlugin it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = ");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".getInstance().getDocumentProvider().getDiagramDocument(anInput);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence findSelectionBody(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramSelection = this.getDiagramSelection(this._utils_qvto.getDiagramTopReference(it));
        _builder.append((Object)_diagramSelection);
        _builder.newLineIfNotEmpty();
        _builder.append("return org.eclipse.jface.viewers.StructuredSelection.EMPTY;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDiagramSelection(GenNavigatorChildReference it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagram = this.getDiagram(it.getNavigator().getEditorGen());
        _builder.append((Object)_diagram);
        _builder.newLineIfNotEmpty();
        _builder.append("if (diagram == null || diagram.eResource() == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.jface.viewers.StructuredSelection.EMPTY;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(diagram.eResource());");
        _builder.newLine();
        _builder.append("if (file != null) {");
        _builder.newLine();
        boolean _isInsideGroup = it.isInsideGroup();
        if (_isInsideGroup) {
            _builder.append("\t");
            CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it.getNavigator());
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append(" parentGroup = new ");
            CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it.getNavigator());
            _builder.append((Object)_qualifiedClassName_1, "\t");
            _builder.append("(\"");
            String _groupName = it.getGroupName();
            _builder.append(_groupName, "\t");
            _builder.append("\", \"");
            String _groupIcon = it.getGroupIcon();
            _builder.append(_groupIcon, "\t");
            _builder.append("\", ");
            CharSequence _modelID = VisualIDRegistry.modelID(it.getNavigator().getEditorGen().getDiagram());
            _builder.append((Object)_modelID, "\t");
            _builder.append(", file);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it.getNavigator());
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(" item = new ");
        CharSequence _qualifiedClassName_3 = this.xptNavigatorItem.qualifiedClassName(it.getNavigator());
        _builder.append((Object)_qualifiedClassName_3, "\t");
        _builder.append("(diagram, ");
        boolean _isInsideGroup_1 = it.isInsideGroup();
        if (_isInsideGroup_1) {
            _builder.append("parentGroup");
        } else {
            _builder.append("file");
        }
        _builder.append(", false);");
        _builder.newLineIfNotEmpty();
        boolean _isInsideGroup_2 = it.isInsideGroup();
        if (_isInsideGroup_2) {
            _builder.append("\t");
            _builder.append("parentGroup.addChild(item);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return new org.eclipse.jface.viewers.StructuredSelection(");
        boolean _isInsideGroup_3 = it.isInsideGroup();
        if (_isInsideGroup_3) {
            _builder.append("parentGroup");
        } else {
            _builder.append("item");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDiagram(GenEditorGenerator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (document == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.jface.viewers.StructuredSelection.EMPTY;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = document.getDiagram();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence activateEditor(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public void activateEditor(org.eclipse.ui.IWorkbenchPage aPage, org.eclipse.jface.viewers.IStructuredSelection aSelection) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (aSelection == null || aSelection.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (false == aSelection.getFirstElement() instanceof ");
        CharSequence _qualifiedClassName = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(" abstractNavigatorItem = (");
        CharSequence _qualifiedClassName_2 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append(") aSelection.getFirstElement();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View navigatorView = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (abstractNavigatorItem instanceof ");
        CharSequence _qualifiedClassName_3 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_3, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("navigatorView = ((");
        CharSequence _qualifiedClassName_4 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_4, "\t\t");
        _builder.append(") abstractNavigatorItem).getView();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} else if (abstractNavigatorItem instanceof ");
        CharSequence _qualifiedClassName_5 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_5, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_6 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_6, "\t\t");
        _builder.append(" navigatorGroup = (");
        CharSequence _qualifiedClassName_7 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_7, "\t\t");
        _builder.append(") abstractNavigatorItem;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (navigatorGroup.getParent() instanceof ");
        CharSequence _qualifiedClassName_8 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_8, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("navigatorView = ((");
        CharSequence _qualifiedClassName_9 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_9, "\t\t\t");
        _builder.append(") navigatorGroup.getParent()).getView();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        CharSequence _viewFromShortcut = this.getViewFromShortcut(it);
        _builder.append((Object)_viewFromShortcut, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (navigatorView == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.ui.IEditorInput editorInput = getEditorInput(navigatorView.getDiagram());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.ui.IEditorPart editor = aPage.findEditor(editorInput);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (editor == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("aPage.bringToTop(editor);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (editor instanceof ");
        CharSequence _diagramEditorClassFQName = this.diagramEditorClassFQName(it);
        _builder.append((Object)_diagramEditorClassFQName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _diagramEditorClassFQName_1 = this.diagramEditorClassFQName(it);
        _builder.append((Object)_diagramEditorClassFQName_1, "\t\t");
        _builder.append(" diagramEditor = (");
        CharSequence _diagramEditorClassFQName_2 = this.diagramEditorClassFQName(it);
        _builder.append((Object)_diagramEditorClassFQName_2, "\t\t");
        _builder.append(") editor;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.resource.ResourceSet diagramEditorResourceSet = diagramEditor.getEditingDomain().getResourceSet();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.EObject selectedView = diagramEditorResourceSet.getEObject(org.eclipse.emf.ecore.util.EcoreUtil.getURI(navigatorView), true);\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (selectedView == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.GraphicalViewer graphicalViewer = (org.eclipse.gef.GraphicalViewer) diagramEditor.getAdapter(org.eclipse.gef.GraphicalViewer.class);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPart selectedEditPart = (org.eclipse.gef.EditPart) graphicalViewer.getEditPartRegistry().get(selectedView);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (selectedEditPart != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("graphicalViewer.select(selectedEditPart);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getViewFromShortcut(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
        if (_generateShortcutIcon) {
            _builder.append("else if (navigatorGroup.getParent() instanceof org.eclipse.core.runtime.IAdaptable) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("navigatorView = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) navigatorGroup.getParent()).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence diagramEditorClassFQName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor");
        return _builder;
    }

    public CharSequence additions(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }
}

