/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor.palette;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Separator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntryKind;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.editor.palette.Utils_qvto;
import xpt.providers.ElementTypes;

@Singleton
public class PaletteFactory {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private Externalizer xptExternalizer;

    public CharSequence className(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        String _factoryClassName = it.getFactoryClassName();
        _builder.append(_factoryClassName);
        return _builder;
    }

    public CharSequence packageName(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    @Deprecated
    public CharSequence Factory(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _PaletteFactory = this.PaletteFactory(it);
        _builder.append((Object)_PaletteFactory);
        return _builder;
    }

    public CharSequence PaletteFactory(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void fillPalette(org.eclipse.gef.palette.PaletteRoot paletteRoot) {");
        _builder.newLine();
        boolean _definesStandardTools = it.definesStandardTools();
        if (_definesStandardTools) {
            _builder.append("cleanStandardTools(paletteRoot);");
            _builder.newLine();
        }
        EList _groups = it.getGroups();
        for (ToolGroup group : _groups) {
            CharSequence _addEntry = this.addEntry((ToolGroupItem)group, "paletteRoot");
            _builder.append((Object)_addEntry);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _definesStandardTools_1 = it.definesStandardTools();
        if (_definesStandardTools_1) {
            CharSequence _cleanStandardToolsHack = this.cleanStandardToolsHack(it);
            _builder.append((Object)_cleanStandardToolsHack);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group_1 : _collectGroups) {
            CharSequence _createGroup = this.createGroup(group_1);
            _builder.append((Object)_createGroup);
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _createEntry = this.createEntry(tool);
            _builder.append((Object)_createEntry);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (this._utils_qvto.needsNodeToolEntryClass(it) && this.shouldGenerateToolEntryClasses()) {
            CharSequence _nodeToolEntry = this.nodeToolEntry(it);
            _builder.append((Object)_nodeToolEntry);
        }
        _builder.newLineIfNotEmpty();
        if (this._utils_qvto.needsLinkToolEntryClass(it) && this.shouldGenerateToolEntryClasses()) {
            CharSequence _linkToolEntry = this.linkToolEntry(it);
            _builder.append((Object)_linkToolEntry);
        }
        _builder.newLineIfNotEmpty();
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions);
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createGroup(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        String _plus = "Creates \"" + _title;
        String _plus_1 = String.valueOf(_plus) + "\" palette tool group";
        CharSequence _generatedMemberComment = this._common.generatedMemberComment(_plus_1);
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.gef.palette.PaletteContainer ");
        String _createMethodName = it.getCreateMethodName();
        _builder.append(_createMethodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _newContainer = this.newContainer(it, "paletteContainer");
        _builder.append((Object)_newContainer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setIdentity = this.setIdentity((EntryBase)it, "paletteContainer");
        _builder.append((Object)_setIdentity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setDescription = this.setDescription(it, "paletteContainer");
        _builder.append((Object)_setDescription, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setSmallImage = this.setSmallImage((EntryBase)it, "paletteContainer", it.getPalette());
        _builder.append((Object)_setSmallImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setLargeImage = this.setLargeImage((EntryBase)it, "paletteContainer", it.getPalette());
        _builder.append((Object)_setLargeImage, "\t");
        _builder.newLineIfNotEmpty();
        EList _entries = it.getEntries();
        for (ToolGroupItem entry : _entries) {
            _builder.append("\t");
            CharSequence _addEntry = this.addEntry(entry, "paletteContainer");
            _builder.append((Object)_addEntry, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return paletteContainer;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence newContainer(ToolGroup it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        if (it.isCollapse() && it.isToolsOnly()) {
            _builder.append("org.eclipse.gef.palette.PaletteDrawer ");
            _builder.append(varName);
            _builder.append(" = new org.eclipse.gef.palette.PaletteDrawer(");
            CharSequence _i18nTitle = this.i18nTitle((EObject)it);
            _builder.append((Object)_i18nTitle);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _isStack = it.isStack();
            if (_isStack) {
                _builder.append("org.eclipse.gef.palette.PaletteStack ");
                _builder.append(varName);
                _builder.append(" = new org.eclipse.gef.palette.PaletteStack(");
                CharSequence _i18nTitle_1 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_1);
                _builder.append(", null, null);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("org.eclipse.gef.palette.PaletteGroup ");
                _builder.append(varName);
                _builder.append(" = new org.eclipse.gef.palette.PaletteGroup(");
                CharSequence _i18nTitle_2 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_2);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence setDescription(ToolGroup gr, String varName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _description = gr.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append(varName);
            _builder.append(".setDescription(");
            CharSequence _i18nDesc = this.i18nDesc((EObject)gr);
            _builder.append((Object)_i18nDesc);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _addEntry(ToolGroupItem it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("abstract addEntry(ToolGroupItem,String) template for" + it);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addEntry(AbstractToolEntry it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(".add(");
        String _createMethodName = it.getCreateMethodName();
        _builder.append(_createMethodName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        if (it.isDefault() && it.getGroup().isStack()) {
            _builder.append(varName);
            _builder.append(".setActiveEntry((org.eclipse.gef.palette.ToolEntry) paletteContainer.getChildren().get(paletteContainer.getChildren().size() - 1));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _addEntry(Separator it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(".add(new org.eclipse.gef.palette.PaletteSeparator());");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addEntry(ToolGroup it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(".add(");
        String _createMethodName = it.getCreateMethodName();
        _builder.append(_createMethodName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence createEntry(AbstractToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.gef.palette.ToolEntry ");
        String _createMethodName = it.getCreateMethodName();
        _builder.append(_createMethodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _newEntry = this.newEntry(it, "entry");
        _builder.append((Object)_newEntry, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setIdentity = this.setIdentity((EntryBase)it, "entry");
        _builder.append((Object)_setIdentity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setSmallImage = this.setSmallImage((EntryBase)it, "entry", it.getGroup().getPalette());
        _builder.append((Object)_setSmallImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setLargeImage = this.setLargeImage((EntryBase)it, "entry", it.getGroup().getPalette());
        _builder.append((Object)_setLargeImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setToolClass = this.setToolClass(it, "entry");
        _builder.append((Object)_setToolClass, "\t");
        _builder.newLineIfNotEmpty();
        EMap _properties = it.getProperties();
        for (Map.Entry prop : _properties) {
            _builder.append("\t");
            CharSequence _setToolProperty = this.setToolProperty(prop, "entry");
            _builder.append((Object)_setToolProperty, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return entry;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected String toolEntryClass(ToolEntry entry) {
        String _xifexpression = null;
        boolean _isEmpty = entry.getGenNodes().isEmpty();
        _xifexpression = _isEmpty ? this.linkToolEntryClassName() : this.nodeToolEntryClassName();
        return _xifexpression;
    }

    protected String getLinkToolEntryGeneratedClassName() {
        return "LinkToolEntry";
    }

    protected String getNodeToolEntryGeneratedClassName() {
        return "NodeToolEntry";
    }

    protected String getDefaultLinkToolEntryClassName() {
        return "org.eclipse.gmf.tooling.runtime.part.DefaultLinkToolEntry";
    }

    protected String getDefaultNodeToolEntryClassName() {
        return "org.eclipse.gmf.tooling.runtime.part.DefaultNodeToolEntry";
    }

    private String linkToolEntryClassName() {
        String _xifexpression = null;
        boolean _shouldGenerateToolEntryClasses = this.shouldGenerateToolEntryClasses();
        _xifexpression = _shouldGenerateToolEntryClasses ? this.getLinkToolEntryGeneratedClassName() : this.getDefaultLinkToolEntryClassName();
        return _xifexpression;
    }

    private String nodeToolEntryClassName() {
        String _xifexpression = null;
        boolean _shouldGenerateToolEntryClasses = this.shouldGenerateToolEntryClasses();
        _xifexpression = _shouldGenerateToolEntryClasses ? this.getNodeToolEntryGeneratedClassName() : this.getDefaultNodeToolEntryClassName();
        return _xifexpression;
    }

    protected CharSequence _newEntry(AbstractToolEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("abstract newEntry(AbstractToolEntry,String) template for: " + it);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _newEntry(ToolEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = it.getElements().isEmpty();
        if (_isEmpty) {
            _builder.append("org.eclipse.gef.palette.ToolEntry ");
            _builder.append(toolVarName);
            _builder.append(" = new org.eclipse.gef.palette.ToolEntry(");
            CharSequence _i18nTitle = this.i18nTitle((EObject)it);
            _builder.append((Object)_i18nTitle);
            _builder.append(", ");
            CharSequence _i18nDesc = this.i18nDesc((EObject)it);
            _builder.append((Object)_i18nDesc);
            _builder.append(", null, null) {};");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan;
            int _size = it.getElements().size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                _builder.append("java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType>(");
                int _size_1 = it.getElements().size();
                _builder.append((Object)_size_1);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                EList _elements = it.getElements();
                for (GenCommonBase e : _elements) {
                    _builder.append("types.add(");
                    CharSequence _accessElementType = this.xptElementTypes.accessElementType(e);
                    _builder.append((Object)_accessElementType);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                String _olEntryClass = this.toolEntryClass(it);
                _builder.append(_olEntryClass);
                _builder.append(" ");
                _builder.append(toolVarName);
                _builder.append(" = new ");
                String _olEntryClass_1 = this.toolEntryClass(it);
                _builder.append(_olEntryClass_1);
                _builder.append("(");
                CharSequence _i18nTitle_1 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_1);
                _builder.append(", ");
                CharSequence _i18nDesc_1 = this.i18nDesc((EObject)it);
                _builder.append((Object)_i18nDesc_1);
                _builder.append(", types);");
                _builder.newLineIfNotEmpty();
            } else {
                String _olEntryClass_2 = this.toolEntryClass(it);
                _builder.append(_olEntryClass_2);
                _builder.append(" ");
                _builder.append(toolVarName);
                _builder.append(" = new ");
                String _olEntryClass_3 = this.toolEntryClass(it);
                _builder.append(_olEntryClass_3);
                _builder.append("(");
                CharSequence _i18nTitle_2 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_2);
                _builder.append(", ");
                CharSequence _i18nDesc_2 = this.i18nDesc((EObject)it);
                _builder.append((Object)_i18nDesc_2);
                _builder.append(", java.util.Collections.singletonList(");
                CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType((GenCommonBase)IterableExtensions.head((Iterable)it.getElements()));
                _builder.append((Object)_accessElementType_1);
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence _newEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        StandardEntryKind _kind = it.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)StandardEntryKind.SELECT_LITERAL);
        if (_equals) {
            CharSequence _newStdSelectEntry = this.newStdSelectEntry(it, toolVarName);
            _builder.append((Object)_newStdSelectEntry);
            _builder.newLineIfNotEmpty();
        } else {
            StandardEntryKind _kind_1 = it.getKind();
            boolean _equals_1 = Objects.equal((Object)_kind_1, (Object)StandardEntryKind.MARQUEE_LITERAL);
            if (_equals_1) {
                CharSequence _newStdMarqueeEntry = this.newStdMarqueeEntry(it, toolVarName);
                _builder.append((Object)_newStdMarqueeEntry);
                _builder.newLineIfNotEmpty();
            } else {
                StandardEntryKind _kind_2 = it.getKind();
                boolean _equals_2 = Objects.equal((Object)_kind_2, (Object)StandardEntryKind.ZOOM_LITERAL);
                if (_equals_2) {
                    CharSequence _newStdZoomEntry = this.newStdZoomEntry(it, toolVarName);
                    _builder.append((Object)_newStdZoomEntry);
                    _builder.newLineIfNotEmpty();
                } else {
                    CharSequence _newStdOtherEntry = this.newStdOtherEntry(it, toolVarName);
                    _builder.append((Object)_newStdOtherEntry);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence newStdSelectEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gef.palette.PanningSelectionToolEntry ");
        _builder.append(toolVarName);
        _builder.append(" = new org.eclipse.gef.palette.PanningSelectionToolEntry();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence newStdMarqueeEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gef.palette.MarqueeToolEntry ");
        _builder.append(toolVarName);
        _builder.append(" = new org.eclipse.gef.palette.MarqueeToolEntry();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence newStdZoomEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FIXME");
        _builder.newLine();
        return _builder;
    }

    public CharSequence newStdOtherEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        StandardEntryKind _kind = it.getKind();
        String _plus = "override newStdOtherEntry(StandardEntry, String) for kind " + _kind;
        this._common_qvto.ERROR(_plus);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence setSmallImage(EntryBase it, String toolVarName, Palette palette) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _smallIconPath = it.getSmallIconPath();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_smallIconPath);
        if (_notEquals) {
            _builder.append(toolVarName);
            _builder.append(".setSmallIcon(");
            String _activatorFQN = this._utils_qvto.activatorFQN((EObject)palette);
            _builder.append(_activatorFQN);
            _builder.append(".findImageDescriptor(\"");
            String _smallIconPath_1 = it.getSmallIconPath();
            _builder.append(_smallIconPath_1);
            _builder.append("\")); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
            if (_oclIsKindOf) {
                boolean _notEquals_1;
                GenCommonBase _head = (GenCommonBase)IterableExtensions.head((Iterable)((ToolEntry)it).getElements());
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_head, null);
                if (_notEquals_1) {
                    _builder.append(toolVarName);
                    _builder.append(".setSmallIcon(");
                    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(palette.getDiagram());
                    _builder.append((Object)_qualifiedClassName);
                    _builder.append(".getImageDescriptor(");
                    CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)IterableExtensions.head((Iterable)((ToolEntry)it).getElements()));
                    _builder.append((Object)_accessElementType);
                    _builder.append("));");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence setLargeImage(EntryBase it, String toolVarName, Palette palette) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _largeIconPath = it.getLargeIconPath();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_largeIconPath);
        if (_notEquals) {
            _builder.append(toolVarName);
            _builder.append(".setLargeIcon(");
            String _activatorFQN = this._utils_qvto.activatorFQN((EObject)palette);
            _builder.append(_activatorFQN);
            _builder.append(".findImageDescriptor(\"");
            String _largeIconPath_1 = it.getLargeIconPath();
            _builder.append(_largeIconPath_1);
            _builder.append("\")); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
            if (_oclIsKindOf) {
                boolean _notEquals_1;
                GenCommonBase _head = (GenCommonBase)IterableExtensions.head((Iterable)((ToolEntry)it).getElements());
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_head, null);
                if (_notEquals_1) {
                    _builder.append(toolVarName);
                    _builder.append(".setLargeIcon(");
                    _builder.append(toolVarName);
                    _builder.append(".getSmallIcon());");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence setToolClass(AbstractToolEntry it, String toolVarName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedToolName = it.getQualifiedToolName();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_qualifiedToolName);
        if (_notEquals) {
            _builder.append(toolVarName);
            _builder.append(".setToolClass(");
            String _qualifiedToolName_1 = it.getQualifiedToolName();
            _builder.append(_qualifiedToolName_1);
            _builder.append(".class);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setToolProperty(Map.Entry<String, String> it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(toolVarName);
        _builder.append(".setToolProperty(");
        String _key = it.getKey();
        _builder.append(_key);
        _builder.append(", ");
        String _value = it.getValue();
        _builder.append(_value);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    protected CharSequence _i18nTitle(ToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean _equals = Objects.equal((Object)_title, null);
        if (_equals) {
            _builder.append("null");
        } else {
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getGroup().getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nTitleKey((EntryBase)it));
            _builder.append((Object)_accessorCall);
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nTitle(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean _equals = Objects.equal((Object)_title, null);
        if (_equals) {
            _builder.append("null");
        } else {
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nTitleKey((EntryBase)it));
            _builder.append((Object)_accessorCall);
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nDesc(ToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _description = it.getDescription();
        boolean _equals = Objects.equal((Object)_description, null);
        if (_equals) {
            _builder.append("null");
        } else {
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getGroup().getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nDescKey((EntryBase)it));
            _builder.append((Object)_accessorCall);
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nDesc(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _description = it.getDescription();
        boolean _equals = Objects.equal((Object)_description, null);
        if (_equals) {
            _builder.append("null");
        } else {
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nDescKey((EntryBase)it));
            _builder.append((Object)_accessorCall);
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group : _collectGroups) {
            CharSequence _internal_i18n_accessors = this.internal_i18n_accessors((EntryBase)group);
            _builder.append((Object)_internal_i18n_accessors);
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _internal_i18n_accessors_1 = this.internal_i18n_accessors((EntryBase)tool);
            _builder.append((Object)_internal_i18n_accessors_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group : _collectGroups) {
            CharSequence _internal_i18n_values = this.internal_i18n_values((EntryBase)group);
            _builder.append((Object)_internal_i18n_values);
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _internal_i18n_values_1 = this.internal_i18n_values((EntryBase)tool);
            _builder.append((Object)_internal_i18n_values_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Localization
    protected CharSequence internal_i18n_accessors(EntryBase it) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_title);
        if (_notEquals) {
            CharSequence _accessorField = this.xptExternalizer.accessorField(this._utils_qvto.i18nTitleKey(it));
            _builder.append((Object)_accessorField);
        }
        _builder.newLineIfNotEmpty();
        String _description = it.getDescription();
        boolean bl2 = _notEquals_1 = !Objects.equal(null, (Object)_description);
        if (_notEquals_1) {
            CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._utils_qvto.i18nDescKey(it));
            _builder.append((Object)_accessorField_1);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    protected CharSequence internal_i18n_values(EntryBase it) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_title);
        if (_notEquals) {
            CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._utils_qvto.i18nTitleKey(it), it.getTitle());
            _builder.append((Object)_messageEntry);
        }
        _builder.newLineIfNotEmpty();
        String _description = it.getDescription();
        boolean bl2 = _notEquals_1 = !Objects.equal(null, (Object)_description);
        if (_notEquals_1) {
            CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._utils_qvto.i18nDescKey(it), it.getDescription());
            _builder.append((Object)_messageEntry_1);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence cleanStandardToolsHack(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Workaround for https://bugs.eclipse.org/bugs/show_bug.cgi?id=159289");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private void cleanStandardTools(org.eclipse.gef.palette.PaletteRoot paletteRoot) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator it = paletteRoot.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.palette.PaletteEntry entry = (org.eclipse.gef.palette.PaletteEntry) it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!\"standardGroup\".equals(entry.getId())) { ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (java.util.Iterator it2 = ((org.eclipse.gef.palette.PaletteContainer) entry).getChildren().iterator(); it2.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gef.palette.PaletteEntry entry2 = (org.eclipse.gef.palette.PaletteEntry) it2.next();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (\"zoomTool\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("it2.remove();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else if (\"noteStack\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_2 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("it2.remove();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else if (\"selectionTool\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_3 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_3, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("it2.remove();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (paletteRoot.getDefaultEntry() == entry2) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("paletteRoot.setDefaultEntry(null);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence nodeToolEntry(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static class ");
        String _nodeToolEntryGeneratedClassName = this.getNodeToolEntryGeneratedClassName();
        _builder.append(_nodeToolEntryGeneratedClassName);
        _builder.append(" extends ");
        String _defaultNodeToolEntryClassName = this.getDefaultNodeToolEntryClassName();
        _builder.append(_defaultNodeToolEntryClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private NodeToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super(title, description, elementTypes);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence linkToolEntry(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static class ");
        String _linkToolEntryGeneratedClassName = this.getLinkToolEntryGeneratedClassName();
        _builder.append(_linkToolEntryGeneratedClassName);
        _builder.append(" extends ");
        String _defaultLinkToolEntryClassName = this.getDefaultLinkToolEntryClassName();
        _builder.append(_defaultLinkToolEntryClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private LinkToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super(title, description, elementTypes);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public boolean shouldGenerateToolEntryClasses() {
        return false;
    }

    public CharSequence setIdentity(EntryBase it, String toolVarName) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getId());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(toolVarName);
            _builder.append(".setId(");
            String _id = it.getId();
            _builder.append(_id);
            _builder.append(");");
            if (it.getId().startsWith("\"") && it.getId().endsWith("\"")) {
                _builder.append(" ");
                CharSequence _nonNLS = this._common.nonNLS(1);
                _builder.append((Object)_nonNLS);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence additions(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence addEntry(ToolGroupItem it, String varName) {
        if (it instanceof AbstractToolEntry) {
            return this._addEntry((AbstractToolEntry)it, varName);
        }
        if (it instanceof Separator) {
            return this._addEntry((Separator)it, varName);
        }
        if (it instanceof ToolGroup) {
            return this._addEntry((ToolGroup)it, varName);
        }
        if (it != null) {
            return this._addEntry(it, varName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, varName).toString());
    }

    public CharSequence newEntry(AbstractToolEntry it, String toolVarName) {
        if (it instanceof StandardEntry) {
            return this._newEntry((StandardEntry)it, toolVarName);
        }
        if (it instanceof ToolEntry) {
            return this._newEntry((ToolEntry)it, toolVarName);
        }
        if (it != null) {
            return this._newEntry(it, toolVarName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, toolVarName).toString());
    }

    public CharSequence i18nTitle(EObject it) {
        if (it instanceof ToolEntry) {
            return this._i18nTitle((ToolEntry)it);
        }
        if (it instanceof ToolGroup) {
            return this._i18nTitle((ToolGroup)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence i18nDesc(EObject it) {
        if (it instanceof ToolEntry) {
            return this._i18nDesc((ToolEntry)it);
        }
        if (it instanceof ToolGroup) {
            return this._i18nDesc((ToolGroup)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

