/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainMerger;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;

public class ArchitectureDomainManager
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.infra.architecture.models";
    private static final String PATH = "path";
    private static final ArchitectureDomainManager INSTANCE = new ArchitectureDomainManager();
    private final ArchitectureDomainPreferences preferences;
    private final ArchitectureDomainMerger merger;
    private Collection<Listener> listeners = new HashSet<Listener>();

    public static ArchitectureDomainManager getInstance() {
        return INSTANCE;
    }

    private ArchitectureDomainManager() {
        this.merger = new ArchitectureDomainMerger();
        this.preferences = new ArchitectureDomainPreferences();
        ArchitectureDomainPreferences.addListener(this);
        this.initializeFromExtensions();
        this.initializeFromPreferences();
        this.merger.init();
    }

    private void initializeFromExtensions() {
        IConfigurationElement[] elements;
        ArrayList<URI> models = new ArrayList<URI>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String path = element.getAttribute(PATH);
            String bundleId = element.getContributor().getName();
            String modelPath = String.valueOf(bundleId) + '/' + path;
            models.add(URI.createPlatformPluginURI((String)modelPath, (boolean)true));
            ++n2;
        }
        this.merger.setExtensionModels(models);
    }

    private void initializeFromPreferences() {
        ArrayList<URI> models = new ArrayList<URI>();
        for (String value : this.preferences.getAddedModelURIs()) {
            if (value.length() <= 0) continue;
            models.add(URI.createURI((String)value, (boolean)true));
        }
        this.merger.setPreferenceModels(models);
    }

    public Collection<URI> getRegisteredArchitectureModels() {
        UniqueEList result = new UniqueEList(this.merger.getExtensionModels());
        result.addAll(this.merger.getPrefereceModels());
        return result;
    }

    public Collection<ArchitectureDomain> getRegisteredArchitectureDomains() {
        return this.merger.getLoadedArchitectureDomains();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        ArchitectureDomainMerger.logf("Architecture preference changed: %s => %s.", event.getKey(), event.getNewValue());
        this.preferences.read();
        if (event.getKey().equals("addedModels")) {
            this.initializeFromPreferences();
        }
        ArchitectureDomainMerger.log("Notifying listeners.");
        for (Listener listener : this.listeners) {
            if (listener instanceof SpecificListener) {
                SpecificListener specificListener = (SpecificListener)listener;
                if (event.getKey().equals("addedModels")) {
                    specificListener.addedModelsChanged();
                } else if (event.getKey().equals("defaultContext")) {
                    specificListener.defaultContextChanged();
                } else if (event.getKey().equals("excludedContexts")) {
                    specificListener.excludedContextsChanged();
                }
            }
            listener.domainManagerChanged();
        }
    }

    @Deprecated
    public ArchitectureDomainPreferences getPreferences() {
        return this.preferences;
    }

    public ArchitectureDomainMerger getMerger() {
        return this.merger;
    }

    public Collection<MergedArchitectureContext> getVisibleArchitectureContexts() {
        ArrayList<MergedArchitectureContext> contexts = new ArrayList<MergedArchitectureContext>();
        for (MergedArchitectureDomain domain : this.merger.getDomains()) {
            for (MergedArchitectureContext context : domain.getContexts()) {
                if (this.preferences.getExcludedContextIds().contains(context.getId())) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    public String getDefaultArchitectureContextId() {
        return this.preferences.getDefaultContextId();
    }

    public MergedArchitectureContext getDefaultArchitectureContext() {
        return this.getArchitectureContextById(this.getDefaultArchitectureContextId());
    }

    public MergedArchitectureContext getArchitectureContextById(String id) {
        return this.merger.getArchitectureContextById(id);
    }

    public MergedArchitectureViewpoint getArchitectureViewpointById(String id) {
        return this.merger.getArchitectureViewpointById(id);
    }

    public RepresentationKind getRepresentationKindById(String id) {
        return this.merger.getRepresentationKindById(id);
    }

    public static interface Listener {
        public void domainManagerChanged();
    }

    public static abstract class SpecificListener
    implements Listener {
        @Override
        public void domainManagerChanged() {
        }

        public void excludedContextsChanged() {
        }

        public void addedModelsChanged() {
        }

        public void defaultContextChanged() {
        }
    }
}

