/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.navigator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import parsers.ParserProvider;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class NavigatorLabelProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private ParserProvider xptParserProvider;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private NavigatorGroup navigatorGroup;
  
  @Inject
  private NavigatorItem xptNavigatorItem;
  
  public CharSequence className(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _labelProviderClassName = it.getLabelProviderClassName();
    _builder.append(_labelProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.jface.viewers.LabelProvider");
    return _builder;
  }
  
  public CharSequence implementsList(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.navigator.ICommonLabelProvider, org.eclipse.jface.viewers.ITreePathLabelProvider");
    return _builder;
  }
  
  public CharSequence NavigatorLabelProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _staticInitializer = this.staticInitializer(it);
    _builder.append(_staticInitializer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _updateLabel = this.updateLabel(it);
    _builder.append(_updateLabel, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _image = this.getImage(it);
    _builder.append(_image, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _viewImage = this.getViewImage(it);
    _builder.append(_viewImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _imageByKey = this.getImageByKey(it);
    _builder.append(_imageByKey, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _text = this.getText(it);
    _builder.append(_text, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _viewText = this.getViewText(it);
    _builder.append(_viewText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
      for(final GenCommonBase n : _navigatorContainedNodes) {
        _builder.append("\t");
        CharSequence _textMethod = this.getTextMethod(n);
        _builder.append(_textMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _unknownElementText = this.getUnknownElementText(it);
    _builder.append(_unknownElementText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _unresolvedDomainElementProxyText = this.getUnresolvedDomainElementProxyText(it);
    _builder.append(_unresolvedDomainElementProxyText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _restoreState = this.restoreState(it);
    _builder.append(_restoreState, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _saveState = this.saveState(it);
    _builder.append(_saveState, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _description = this.getDescription(it);
    _builder.append(_description, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isOwnView = this.isOwnView(it);
    _builder.append(_isOwnView, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence staticInitializer(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().getImageRegistry().put(");
    CharSequence _unknownElementKey = this.unknownElementKey();
    _builder.append(_unknownElementKey, "\t");
    _builder.append(", org.eclipse.jface.resource.ImageDescriptor.getMissingImageDescriptor());  ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(".getInstance().getImageRegistry().put(");
    CharSequence _notFoundElementKey = this.notFoundElementKey();
    _builder.append(_notFoundElementKey, "\t");
    _builder.append(", org.eclipse.jface.resource.ImageDescriptor.getMissingImageDescriptor());  ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence updateLabel(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void updateLabel(org.eclipse.jface.viewers.ViewerLabel label, org.eclipse.jface.viewers.TreePath elementPath) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object element = elementPath.getLastSegment();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" && !isOwnView(((");
    CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(") element).getView())) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("label.setText(getText(element));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("label.setImage(getImage(element));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.swt.graphics.Image getImage(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _navigatorGroupImage = this.getNavigatorGroupImage(it);
    _builder.append(_navigatorGroupImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _navigatorItemImage = this.getNavigatorItemImage(it);
    _builder.append(_navigatorItemImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _adaptableImage = this.getAdaptableImage(it);
    _builder.append(_adaptableImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additionalInputImage = this.getAdditionalInputImage(it);
    _builder.append(_additionalInputImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return super.getImage(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorGroupImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(" group = (");
    CharSequence _qualifiedClassName_2 = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(") element;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_3, "\t");
    _builder.append(".getInstance().getBundledImage(group.getIcon());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorItemImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(" navigatorItem = (");
    CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(") element;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!isOwnView(navigatorItem.getView())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.getImage(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getImage(navigatorItem.getView());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdaptableImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
      if (_generateShortcutIcon) {
        _builder.append("// Due to plugin.xml content will be called only for \"own\" views");
        _builder.newLine();
        _builder.append("if (element instanceof org.eclipse.core.runtime.IAdaptable) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) element).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (view != null && isOwnView(view)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getImage(view);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence getAdditionalInputImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getViewImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.swt.graphics.Image getImage(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenCommonBase>notEmpty(this._utils_qvto.getNavigatorContainedNodes(it));
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("switch (");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append(_visualIDMethodCall, "\t");
        _builder.append("(view)) {");
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
          for(final GenCommonBase n : _navigatorContainedNodes) {
            {
              boolean _notEquals = (!Objects.equal(n, null));
              if (_notEquals) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _caseImage = this.caseImage(n);
                _builder.append(_caseImage, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return getImage(");
    CharSequence _unknownElementKey = this.unknownElementKey();
    _builder.append(_unknownElementKey, "\t");
    _builder.append(", null);  ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence caseImage(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("case ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append(":");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return getImage(\"");
    CharSequence _key = this.key(it);
    _builder.append(_key, "\t");
    _builder.append("\", ");
    {
      ElementType _elementType = it.getElementType();
      boolean _notEquals = (!Objects.equal(null, _elementType));
      if (_notEquals) {
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(it);
        _builder.append(_accessElementType, "\t");
      } else {
        _builder.append("null");
      }
    }
    _builder.append("); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getImageByKey(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.swt.graphics.Image getImage(String key, org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.resource.ImageRegistry imageRegistry = ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().getImageRegistry();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.graphics.Image image = imageRegistry.get(key);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (image == null && elementType != null && ");
    CharSequence _qualifiedClassName_1 = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(".isKnownElementType(elementType)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("image = ");
    CharSequence _qualifiedClassName_2 = this.xptElementTypes.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(".getImage(elementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("imageRegistry.put(key, image);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (image == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("image = imageRegistry.get(");
    CharSequence _notFoundElementKey = this.notFoundElementKey();
    _builder.append(_notFoundElementKey, "\t\t");
    _builder.append(");  ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("imageRegistry.put(key, image);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return image;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _getText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getText(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _navigatorGroupText = this.getNavigatorGroupText(it);
    _builder.append(_navigatorGroupText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _navigatorItemText = this.getNavigatorItemText(it);
    _builder.append(_navigatorItemText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _adaptableText = this.getAdaptableText(it);
    _builder.append(_adaptableText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additionalInputText = this.getAdditionalInputText(it);
    _builder.append(_additionalInputText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return super.getText(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorGroupText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(" group = (");
    CharSequence _qualifiedClassName_2 = this.navigatorGroup.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(") element;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return group.getGroupName();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorItemText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(" navigatorItem = (");
    CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(") element;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!isOwnView(navigatorItem.getView())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getText(navigatorItem.getView());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdaptableText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
      if (_generateShortcutIcon) {
        _builder.append("// Due to plugin.xml content will be called only for \"own\" views");
        _builder.newLine();
        _builder.append("if (element instanceof org.eclipse.core.runtime.IAdaptable) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) element).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (view != null && isOwnView(view)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getText(view);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence getAdditionalInputText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getViewText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getText(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (view.getElement() != null && view.getElement().eIsProxy()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getUnresolvedDomainElementProxyText(view);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenCommonBase>notEmpty(this._utils_qvto.getNavigatorContainedNodes(it));
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("switch (");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append(_visualIDMethodCall, "\t");
        _builder.append("(view)) {");
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenCommonBase> _navigatorContainedNodes = this._utils_qvto.getNavigatorContainedNodes(it);
          for(final GenCommonBase n : _navigatorContainedNodes) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _caseText = this.caseText(n);
            _builder.append(_caseText, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return getUnknownElementText(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence caseText(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("case ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append(":");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _textMethodName = this.getTextMethodName(it);
    _builder.append(_textMethodName, "\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @MetaDef
  public CharSequence getTextMethodName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("Text");
    return _builder;
  }
  
  public CharSequence getTextMethod(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private String ");
    CharSequence _textMethodName = this.getTextMethodName(it);
    _builder.append(_textMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _text = this.getText(it);
    _builder.append(_text, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _getText(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Incorrect GenCommonBase: " + it));
    return _builder;
  }
  
  protected CharSequence _getText(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _labelFeatureText = this.getLabelFeatureText(it, it.getDomainDiagramElement());
    _builder.append(_labelFeatureText);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getText(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _diagramLabelText = this.getDiagramLabelText(it, it, it.getLabelModelFacet());
    _builder.append(_diagramLabelText);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getText(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _diagramLabelText = this.getDiagramLabelText(it, it.getLink(), it.getModelFacet());
    _builder.append(_diagramLabelText);
    return _builder;
  }
  
  protected CharSequence _getText(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _diagramLabelText = this.getDiagramLabelText(it, it.getNode(), it.getModelFacet());
    _builder.append(_diagramLabelText);
    return _builder;
  }
  
  protected CharSequence _getText(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      if (_isEmpty) {
        {
          TypeModelFacet _modelFacet = it.getModelFacet();
          boolean _notEquals = (!Objects.equal(null, _modelFacet));
          if (_notEquals) {
            CharSequence _labelFeatureText = this.getLabelFeatureText(it, it.getModelFacet().getMetaClass());
            _builder.append(_labelFeatureText);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _returnEmptyString = this.returnEmptyString();
            _builder.append(_returnEmptyString);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        CharSequence _diagramLabelText = this.getDiagramLabelText(it, it.getLabels());
        _builder.append(_diagramLabelText);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _getText(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      if (_isEmpty) {
        {
          LinkModelFacet _modelFacet = it.getModelFacet();
          boolean _notEquals = (!Objects.equal(null, _modelFacet));
          if (_notEquals) {
            CharSequence _text = this.getText(it, it.getModelFacet());
            _builder.append(_text);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _returnEmptyString = this.returnEmptyString();
            _builder.append(_returnEmptyString);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        CharSequence _diagramLabelText = this.getDiagramLabelText(it, it.getLabels());
        _builder.append(_diagramLabelText);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence getDiagramLabelText(final GenCommonBase it, final Iterable<? extends GenLabel> labels) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(labels);
      if (_isEmpty) {
        this._common_qvto.ERROR("Empty list of labels passed");
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _diagramLabelText = this.getDiagramLabelText(IterableExtensions.head(labels), it, IterableExtensions.head(labels).getModelFacet());
    _builder.append(_diagramLabelText);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getText(final GenLink it, final LinkModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _returnEmptyString = this.returnEmptyString();
    _builder.append(_returnEmptyString);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getText(final GenLink it, final TypeLinkModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _labelFeatureText = this.getLabelFeatureText(it, modelFacet.getMetaClass());
    _builder.append(_labelFeatureText);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getText(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return \"");
    String _title = it.getTitle();
    _builder.append(_title);
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * FIXME: [MG] Refactor. Need to reuse parts of TextAware.xpt
   * 
   * it - aka hintHolder, visual element to present a text
   * elementTypeHolder - model element being displayed
   * modelFacet - may be null
   */
  public CharSequence getDiagramLabelText(final GenCommonBase it, final GenCommonBase elementTypeHolder, final LabelModelFacet labelModelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.IParser parser = ");
    CharSequence _accessorCall = this.xptParserProvider.accessorCall(it, elementTypeHolder, labelModelFacet, "view.getElement() != null ? view.getElement() : view");
    _builder.append(_accessorCall);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("if (parser != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return parser.getPrintString(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(view.getElement() != null ? view.getElement() : view), org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions.NONE.intValue());");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().logError(\"Parser was not found for label \" + ");
    int _visualID = it.getVisualID();
    _builder.append(_visualID, "\t");
    _builder.append("); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _returnEmptyString = this.returnEmptyString();
    _builder.append(_returnEmptyString, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getLabelFeatureText(final GenCommonBase it, final GenClass genClass) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!Objects.equal(null, genClass)) && (!Objects.equal(null, genClass.getLabelFeature())))) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(genClass, "domainModelElement", "view.getElement()");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        _builder.append("if (domainModelElement != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        {
          boolean _isStringFeature = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
          boolean _not = (!_isStringFeature);
          if (_not) {
            _builder.append("String.valueOf(");
          }
        }
        CharSequence _featureValue = this.xptMetaModel.getFeatureValue(genClass.getLabelFeature(), "domainModelElement", genClass);
        _builder.append(_featureValue, "\t");
        {
          boolean _isStringFeature_1 = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
          boolean _not_1 = (!_isStringFeature_1);
          if (_not_1) {
            _builder.append(")");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".getInstance().logError(\"No domain element for view with visualID = \" + ");
        int _visualID = it.getVisualID();
        _builder.append(_visualID, "\t");
        _builder.append(");  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _returnEmptyString = this.returnEmptyString();
        _builder.append(_returnEmptyString, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        CharSequence _returnEmptyString_1 = this.returnEmptyString();
        _builder.append(_returnEmptyString_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence returnEmptyString() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return \"\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getUnknownElementText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private String getUnknownElementText(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return \"<UnknownElement Visual_ID = \" + view.getType() + \">\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.append("  ");
    CharSequence _nonNLS_1 = this._common.nonNLS(2);
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getUnresolvedDomainElementProxyText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private String getUnresolvedDomainElementProxyText(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return \"<Unresolved domain element Visual_ID = \" + view.getType() + \">\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.append("  ");
    CharSequence _nonNLS_1 = this._common.nonNLS(2);
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init(org.eclipse.ui.navigator.ICommonContentExtensionSite aConfig) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence restoreState(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void restoreState(org.eclipse.ui.IMemento aMemento) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence saveState(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void saveState(org.eclipse.ui.IMemento aMemento) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDescription(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getDescription(Object anElement) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isOwnView(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private boolean isOwnView(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
    _builder.append(_modelID, "\t");
    _builder.append(".equals(");
    CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it.getEditorGen().getDiagram());
    _builder.append(_modelIDMethodCall, "\t");
    _builder.append("(view));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence unknownElementKey() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\"");
    CharSequence _commonKeyPrefix = this.commonKeyPrefix();
    _builder.append(_commonKeyPrefix);
    _builder.append("UnknownElement\"");
    return _builder;
  }
  
  public CharSequence notFoundElementKey() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\"");
    CharSequence _commonKeyPrefix = this.commonKeyPrefix();
    _builder.append(_commonKeyPrefix);
    _builder.append("ImageNotFound\"");
    return _builder;
  }
  
  protected CharSequence _key(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Incorrect GenCommonBase: " + it));
    return _builder;
  }
  
  protected CharSequence _key(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonKeyPrefix = this.commonKeyPrefix();
    _builder.append(_commonKeyPrefix);
    _builder.append("Diagram?");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
      if (_notEquals) {
        CharSequence _keyFragment = this.keyFragment(it.getDomainDiagramElement());
        _builder.append(_keyFragment);
      }
    }
    return _builder;
  }
  
  protected CharSequence _key(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonKeyPrefix = this.commonKeyPrefix();
    _builder.append(_commonKeyPrefix);
    CharSequence _keyFragment = this.keyFragment(it);
    _builder.append(_keyFragment);
    {
      TypeModelFacet _modelFacet = it.getModelFacet();
      boolean _notEquals = (!Objects.equal(null, _modelFacet));
      if (_notEquals) {
        CharSequence _keyFragment_1 = this.keyFragment(it.getModelFacet().getMetaClass());
        _builder.append(_keyFragment_1);
      } else {
        CharSequence _keyFragment_2 = this.keyFragment(it.getViewmap());
        _builder.append(_keyFragment_2);
      }
    }
    return _builder;
  }
  
  protected CharSequence _keyFragment(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Node?");
    return _builder;
  }
  
  protected CharSequence _keyFragment(final GenTopLevelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("TopLevelNode?");
    return _builder;
  }
  
  protected CharSequence _key(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _commonKeyPrefix = this.commonKeyPrefix();
    _builder.append(_commonKeyPrefix);
    _builder.append("Link?");
    {
      LinkModelFacet _modelFacet = it.getModelFacet();
      boolean _notEquals = (!Objects.equal(null, _modelFacet));
      if (_notEquals) {
        CharSequence _keyFragment = this.keyFragment(it.getModelFacet());
        _builder.append(_keyFragment);
      } else {
        CharSequence _keyFragment_1 = this.keyFragment(it.getViewmap());
        _builder.append(_keyFragment_1);
      }
    }
    return _builder;
  }
  
  protected CharSequence _keyFragment(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Incorrect link model facet passed: " + it));
    return _builder;
  }
  
  protected CharSequence _keyFragment(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _keyFragment = this.keyFragment(it.getMetaClass());
    _builder.append(_keyFragment);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _keyFragment = this.keyFragment(it.getMetaFeature());
    _builder.append(_keyFragment);
    return _builder;
  }
  
  protected CharSequence _key(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _key = this.key(it.getNode());
    _builder.append(_key);
    _builder.append("?Compartment?");
    String _title = it.getTitle();
    _builder.append(_title);
    return _builder;
  }
  
  protected CharSequence _key(final GenLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Incorrect GenLabel:" + it));
    return _builder;
  }
  
  protected CharSequence _key(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _key = this.key(it.getNode());
    _builder.append(_key);
    CharSequence _keyFragment = this.keyFragment(it);
    _builder.append(_keyFragment);
    return _builder;
  }
  
  protected CharSequence _key(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _key = this.key(it.getLink());
    _builder.append(_key);
    CharSequence _keyFragment = this.keyFragment(it);
    _builder.append(_keyFragment);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final GenLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("?Label?");
    CharSequence _keyFragment = this.keyFragment(it.getModelFacet(), it);
    _builder.append(_keyFragment);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final GenClass it) {
    StringConcatenation _builder = new StringConcatenation();
    String _nsURI = it.getGenPackage().getEcorePackage().getNsURI();
    _builder.append(_nsURI);
    _builder.append("?");
    String _name = it.getEcoreClass().getName();
    _builder.append(_name);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final GenFeature it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _keyFragment = this.keyFragment(it.getGenClass());
    _builder.append(_keyFragment);
    _builder.append("?");
    String _name = it.getEcoreFeature().getName();
    _builder.append(_name);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _keyFragment(final FigureViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    String _figureQualifiedClassName = it.getFigureQualifiedClassName();
    _builder.append(_figureQualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final InnerClassViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final ParentAssignedViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    String _figureQualifiedClassName = it.getFigureQualifiedClassName();
    _builder.append(_figureQualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _keyFragment(final LabelModelFacet it, final GenLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Incorrect label model facet: " + it));
    return _builder;
  }
  
  protected CharSequence _keyFragment(final FeatureLabelModelFacet it, final GenLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenFeature> _metaFeatures = it.getMetaFeatures();
      for(final GenFeature f : _metaFeatures) {
        CharSequence _keyFragment = this.keyFragment(f);
        _builder.append(_keyFragment);
      }
    }
    return _builder;
  }
  
  protected CharSequence _keyFragment(final DesignLabelModelFacet it, final GenLabel label) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _keyFragment = this.keyFragment(label.getViewmap());
    _builder.append(_keyFragment);
    return _builder;
  }
  
  public CharSequence commonKeyPrefix() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Navigator?");
    return _builder;
  }
  
  public CharSequence additions(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getText(final EObject it) {
    if (it instanceof GenChildLabelNode) {
      return _getText((GenChildLabelNode)it);
    } else if (it instanceof GenCompartment) {
      return _getText((GenCompartment)it);
    } else if (it instanceof GenNode) {
      return _getText((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getText((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _getText((GenLink)it);
    } else if (it instanceof GenLinkLabel) {
      return _getText((GenLinkLabel)it);
    } else if (it instanceof GenNodeLabel) {
      return _getText((GenNodeLabel)it);
    } else if (it instanceof GenNavigator) {
      return _getText((GenNavigator)it);
    } else if (it instanceof GenCommonBase) {
      return _getText((GenCommonBase)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence getText(final GenLink it, final LinkModelFacet modelFacet) {
    if (modelFacet instanceof TypeLinkModelFacet) {
      return _getText(it, (TypeLinkModelFacet)modelFacet);
    } else if (modelFacet != null) {
      return _getText(it, modelFacet);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, modelFacet).toString());
    }
  }
  
  public CharSequence key(final GenCommonBase it) {
    if (it instanceof GenCompartment) {
      return _key((GenCompartment)it);
    } else if (it instanceof GenNode) {
      return _key((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _key((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _key((GenLink)it);
    } else if (it instanceof GenLinkLabel) {
      return _key((GenLinkLabel)it);
    } else if (it instanceof GenNodeLabel) {
      return _key((GenNodeLabel)it);
    } else if (it instanceof GenLabel) {
      return _key((GenLabel)it);
    } else if (it != null) {
      return _key(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence keyFragment(final EObject it) {
    if (it instanceof GenTopLevelNode) {
      return _keyFragment((GenTopLevelNode)it);
    } else if (it instanceof GenNode) {
      return _keyFragment((GenNode)it);
    } else if (it instanceof GenClass) {
      return _keyFragment((GenClass)it);
    } else if (it instanceof GenFeature) {
      return _keyFragment((GenFeature)it);
    } else if (it instanceof FeatureLinkModelFacet) {
      return _keyFragment((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _keyFragment((TypeLinkModelFacet)it);
    } else if (it instanceof FigureViewmap) {
      return _keyFragment((FigureViewmap)it);
    } else if (it instanceof GenLabel) {
      return _keyFragment((GenLabel)it);
    } else if (it instanceof InnerClassViewmap) {
      return _keyFragment((InnerClassViewmap)it);
    } else if (it instanceof LinkModelFacet) {
      return _keyFragment((LinkModelFacet)it);
    } else if (it instanceof ParentAssignedViewmap) {
      return _keyFragment((ParentAssignedViewmap)it);
    } else if (it instanceof Viewmap) {
      return _keyFragment((Viewmap)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence keyFragment(final LabelModelFacet it, final GenLabel label) {
    if (it instanceof DesignLabelModelFacet) {
      return _keyFragment((DesignLabelModelFacet)it, label);
    } else if (it instanceof FeatureLabelModelFacet) {
      return _keyFragment((FeatureLabelModelFacet)it, label);
    } else if (it != null) {
      return _keyFragment(it, label);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, label).toString());
    }
  }
}
