/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editpolicies.TextSelectionEditPolicy;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class LinkLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private TextSelectionEditPolicy textSelection;
  
  public CharSequence className(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence initializer(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("registerSnapBackPosition(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(", new org.eclipse.draw2d.geometry.Point(");
    int _labelOffsetX = this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0);
    _builder.append(_labelOffsetX, "\t");
    _builder.append(", ");
    int _labelOffsetY = this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0);
    _builder.append(_labelOffsetY, "\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPoliciesBody(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new ");
    CharSequence _qualifiedClassName = this.textSelection.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE,\tnew ");
    CharSequence _linkLabelDragPolicyQualifiedClassName = this.linkLabelDragPolicyQualifiedClassName(
      it.getDiagram());
    _builder.append(_linkLabelDragPolicyQualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    CharSequence _additionalEditPolicies = this.additionalEditPolicies(it);
    _builder.append(_additionalEditPolicies);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additionalEditPolicies(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getKeyPoint(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public int getKeyPoint() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.draw2d.ConnectionLocator.");
    LinkLabelAlignment _alignment = it.getAlignment();
    _builder.append(_alignment, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Object feature = event.getFeature();");
    _builder.newLine();
    CharSequence _handleText = this.xptEditpartsCommon.handleText(it);
    _builder.append(_handleText);
    _builder.newLineIfNotEmpty();
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * since 3.1, old generated NodeLabelDragPolicy extracted to GMFT-runtime,
   * see org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy.
   * The next 2 DEFINE's are left here as a hook for possible AROUND's
   */
  public CharSequence linkLabelDragPolicyQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.tooling.runtime.edit.policies.DefaultLinkLabelDragPolicy");
    return _builder;
  }
  
  public CharSequence linkLabelDragPolicyClass(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
