/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.matchers;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public class MoreMatchers {
    private MoreMatchers() {
    }

    public static <N extends Number> Matcher<N> greaterThan(N minimum) {
        return MoreMatchers.comparesAs(minimum, 1, false);
    }

    public static <N extends Number> Matcher<N> lessThan(N maximum) {
        return MoreMatchers.comparesAs(maximum, -1, false);
    }

    public static <N extends Number> Matcher<N> greaterThanOrEqual(N minimum) {
        return MoreMatchers.comparesAs(minimum, 1, true);
    }

    public static <N extends Number> Matcher<N> lessThanOrEqual(N maximum) {
        return MoreMatchers.comparesAs(maximum, -1, true);
    }

    public static <C extends Comparable<C>> Matcher<C> comparesAs(final C compareTo, int sign, final boolean orEqual) {
        final int normalizedSign = Integer.signum(sign);
        return new TypeSafeMatcher<C>(){

            public void describeTo(Description description) {
                switch (normalizedSign) {
                    case -1: {
                        description.appendText(orEqual ? "\u2264 " : "< ");
                        break;
                    }
                    case 1: {
                        description.appendText(orEqual ? "\u2265 " : "> ");
                        break;
                    }
                    default: {
                        description.appendText("= ");
                    }
                }
                description.appendValue((Object)compareTo);
            }

            protected boolean matchesSafely(C item) {
                int comparison = item.compareTo((Comparable)compareTo);
                switch (normalizedSign) {
                    case -1: {
                        return orEqual ? comparison <= 0 : comparison < 0;
                    }
                    case 1: {
                        return orEqual ? comparison >= 0 : comparison > 0;
                    }
                }
                return comparison == 0;
            }
        };
    }

    public static Matcher<Iterable<?>> isEmpty() {
        return new BaseMatcher<Iterable<?>>(){

            public void describeTo(Description description) {
                description.appendText("is empty");
            }

            public boolean matches(Object item) {
                return Iterables.isEmpty((Iterable)((Iterable)item));
            }
        };
    }

    public static <E> Matcher<Iterable<E>> emptyIterable() {
        return new BaseMatcher<Iterable<E>>(){

            public void describeTo(Description description) {
                description.appendText("is empty");
            }

            public boolean matches(Object item) {
                return Iterables.isEmpty((Iterable)((Iterable)item));
            }
        };
    }

    public static Matcher<String> regexMatches(final String pattern) {
        return new BaseMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("matches /").appendText(pattern).appendText("/");
            }

            public boolean matches(Object item) {
                String string = (String)item;
                return !Strings.isNullOrEmpty((String)string) && string.matches(pattern);
            }
        };
    }

    public static Matcher<String> regexContains(final String pattern) {
        final Pattern regex = Pattern.compile(pattern);
        return new BaseMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("contains /").appendText(pattern).appendText("/");
            }

            public boolean matches(Object item) {
                String string = (String)item;
                return !Strings.isNullOrEmpty((String)string) && regex.matcher(string).find();
            }
        };
    }

    public static Matcher<IStatus> statusWithMessage(final Matcher<? super String> matcher) {
        return new BaseMatcher<IStatus>(){

            public void describeTo(Description description) {
                description.appendText("status with message ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public boolean matches(Object item) {
                boolean result = false;
                if (item instanceof IStatus) {
                    IStatus status = (IStatus)item;
                    result = matcher.matches((Object)status.getMessage());
                }
                return result;
            }
        };
    }

    public static Matcher<IStatus> statusWithException(final Matcher<?> matcher) {
        return new BaseMatcher<IStatus>(){

            public void describeTo(Description description) {
                description.appendText("status with exception ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public boolean matches(Object item) {
                boolean result = false;
                if (item instanceof IStatus) {
                    IStatus status = (IStatus)item;
                    result = matcher.matches((Object)status.getException());
                }
                return result;
            }
        };
    }

    public static Matcher<Diagnostic> diagnosticWithMessage(Matcher<? super String> matcher) {
        return new FeatureMatcher<Diagnostic, String>(matcher, "diagnostic message", "message"){

            protected String featureValueOf(Diagnostic actual) {
                return actual.getMessage();
            }
        };
    }

    public static <T, N extends Number> Matcher<Iterable<T>> hasCount(final Matcher<N> countMatcher, final Matcher<? super T> elementMatcher) {
        return new TypeSafeDiagnosingMatcher<Iterable<T>>(){

            public void describeTo(Description description) {
                description.appendText("has ").appendDescriptionOf((SelfDescribing)countMatcher);
                description.appendText(" items that ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }

            protected boolean matchesSafely(Iterable<T> item, Description mismatchDescription) {
                int satisfiedCount = 0;
                for (Object next : item) {
                    if (!elementMatcher.matches(next)) continue;
                    ++satisfiedCount;
                }
                if (!countMatcher.matches((Object)satisfiedCount)) {
                    mismatchDescription.appendText("has ");
                    countMatcher.describeMismatch((Object)satisfiedCount, mismatchDescription);
                    mismatchDescription.appendText(" items that ");
                    mismatchDescription.appendDescriptionOf((SelfDescribing)elementMatcher);
                }
                return countMatcher.matches((Object)satisfiedCount);
            }
        };
    }

    public static <T> Matcher<Iterable<T>> hasAtMost(int max, Matcher<? super T> elementMatcher) {
        return MoreMatchers.hasCount(MoreMatchers.lessThanOrEqual(max), elementMatcher);
    }

    public static <T> Matcher<Iterable<T>> hasAtLeast(int min, Matcher<? super T> elementMatcher) {
        return MoreMatchers.hasCount(MoreMatchers.greaterThanOrEqual(min), elementMatcher);
    }
}

