/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.toolsmiths.plugin.builder.GenericEMFModelBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.ManifestBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusPluginBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.XWTModelBuilder;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitecturePluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfilePluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.StaticProfileHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Profile;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.toolsmiths.plugin.builder";
    public static final String PAPYRUS_ICON_PATH = "/icons/papyrus.png";
    public static LogHelper log;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        PapyrusPluginBuilder.addModelBuilder(new GenericEMFModelBuilder());
        PapyrusPluginBuilder.addModelBuilder(new XWTModelBuilder());
        PapyrusPluginBuilder.addModelBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", this::mapElementTypesResources).withChecker(ElementTypesPluginChecker.modelValidationCheckerFactory()).withChecker(ElementTypesPluginChecker.customModelCheckerFactory()));
        PapyrusPluginBuilder.addModelBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", this::mapArchitectureResources).withChecker(ArchitecturePluginChecker.modelValidationCheckerFactory()).withChecker(ArchitecturePluginChecker.customModelCheckerFactory()));
        PapyrusPluginBuilder.addManifestBuilder(new ManifestBuilder());
        PapyrusPluginBuilder.addManifestBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", this::mapProfilesResources).withChecker(ProfilePluginChecker.modelDependenciesCheckerFactory()).withChecker(ProfilePluginChecker.buildPropertiesCheckerFactory()));
        PapyrusPluginBuilder.addManifestBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", this::mapElementTypesResources).withChecker(ElementTypesPluginChecker.modelDependenciesCheckerFactory()).withChecker(ElementTypesPluginChecker.buildPropertiesCheckerFactory()));
        PapyrusPluginBuilder.addManifestBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", this::mapArchitectureResources).withChecker(ArchitecturePluginChecker.buildPropertiesCheckerFactory()).withChecker(ArchitecturePluginChecker.modelDependenciesCheckerFactory()));
        PapyrusPluginBuilder.addManifestBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", this::mapAllProfilesResources).withChecker(ProfilePluginChecker.extensionsCheckerFactory()));
        PapyrusPluginBuilder.addPluginBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", this::mapElementTypesResources).withChecker(ElementTypesPluginChecker.extensionsCheckerFactory()));
        PapyrusPluginBuilder.addPluginBuilder(new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", this::mapArchitectureResources).withChecker(ArchitecturePluginChecker.extensionsCheckerFactory()));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private ListMultimap<IFile, ElementTypeSetConfiguration> mapElementTypesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"elementtypesconfigurations"), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(ElementTypeSetConfiguration.class));
    }

    private ListMultimap<IFile, Profile> mapProfilesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(StaticProfileHelper.umlWithGenmodel(), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(Profile.class));
    }

    private ListMultimap<IFile, Profile> mapAllProfilesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(StaticProfileHelper.umlWithGenmodel(), ModelResourceMapper.resourceSets(), ModelResourceMapper.allElementsOfType(Profile.class));
    }

    private ListMultimap<IFile, ArchitectureDomain> mapArchitectureResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"architecture"), ModelResourceMapper.resourceSets((EPackage.Registry)ResourceUtils.createWorkspaceAwarePackageRegistry()), ModelResourceMapper.rootsOfType(ArchitectureDomain.class));
    }
}

