/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;

@Singleton
@SuppressWarnings("all")
public class DocumentProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private ResourceSetInfo xptResourceSetInfo;
  
  @Inject
  private ResourceSetModificationListener xptResourceSetModificationListener;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _documentProviderClassName = it.getDocumentProviderClassName();
    _builder.append(_documentProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider");
    return _builder;
  }
  
  public CharSequence implementsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider");
    return _builder;
  }
  
  public CharSequence DocumentProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createElementInfo = this.createElementInfo(it);
    _builder.append(_createElementInfo, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDocument = this.createDocument(it);
    _builder.append(_createDocument, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setupDocument = this.setupDocument(it);
    _builder.append(_setupDocument, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _computeModificationStamp = this.computeModificationStamp(it);
    _builder.append(_computeModificationStamp, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createEmptyDocument = this.createEmptyDocument(it);
    _builder.append(_createEmptyDocument, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createEditingDomain = this.createEditingDomain(it);
    _builder.append(_createEditingDomain, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setDocumentContent = this.setDocumentContent(it);
    _builder.append(_setDocumentContent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _modificationStamp = this.getModificationStamp(it);
    _builder.append(_modificationStamp, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isDeleted = this.isDeleted(it);
    _builder.append(_isDeleted, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _resourceSetInfo = this.getResourceSetInfo(it);
    _builder.append(_resourceSetInfo, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _disposeElementInfo = this.disposeElementInfo(it);
    _builder.append(_disposeElementInfo, "\t");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _doValidateState = this.doValidateState(it);
        _builder.append(_doValidateState, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isReadOnly = this.isReadOnly(it);
    _builder.append(_isReadOnly, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isModifiable = this.isModifiable(it);
    _builder.append(_isModifiable, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _updateCache = this.updateCache(it);
    _builder.append(_updateCache, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doUpdateStateCache = this.doUpdateStateCache(it);
    _builder.append(_doUpdateStateCache, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isSynchronized = this.isSynchronized(it);
    _builder.append(_isSynchronized, "\t");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _resetRule = this.getResetRule(it);
        _builder.append(_resetRule, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _saveRule = this.getSaveRule(it);
        _builder.append(_saveRule, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _synchronizeRule = this.getSynchronizeRule(it);
        _builder.append(_synchronizeRule, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _validateStateRule = this.getValidateStateRule(it);
        _builder.append(_validateStateRule, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _computeSchedulingRule = this.computeSchedulingRule(it);
        _builder.append(_computeSchedulingRule, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doSynchronize = this.doSynchronize(it);
    _builder.append(_doSynchronize, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doSaveDocument = this.doSaveDocument(it);
    _builder.append(_doSaveDocument, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleElementChanged = this.handleElementChanged(it);
    _builder.append(_handleElementChanged, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleElementMoved = this.handleElementMoved(it);
    _builder.append(_handleElementMoved, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createInputWithEditingDomain = this.createInputWithEditingDomain(it);
    _builder.append(_createInputWithEditingDomain, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _diagramDocument = this.getDiagramDocument(it);
    _builder.append(_diagramDocument, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _operationRunner = this.getOperationRunner(it);
    _builder.append(_operationRunner, "\t");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application_2 = it.getEditorGen().getApplication();
      boolean _notEquals = (!Objects.equal(null, _application_2));
      if (_notEquals) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _file = this.getFile(it);
        _builder.append(_file, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ResourceSetInfo = this.xptResourceSetInfo.ResourceSetInfo(it);
    _builder.append(_ResourceSetInfo, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _ResourceSetModificationListener = this.xptResourceSetModificationListener.ResourceSetModificationListener(it);
    _builder.append(_ResourceSetModificationListener, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createElementInfo(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ElementInfo createElementInfo(Object element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkEditorInputInstance = this.checkEditorInputInstance(it);
    _builder.append(_checkEditorInputInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorInput editorInput = (org.eclipse.ui.IEditorInput) element;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) createDocument(editorInput);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = new ResourceSetInfo(document, editorInput);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("info.setModificationStamp(computeModificationStamp(info));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("info.fStatus = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return info;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence checkEditorInputInstance(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("false == element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName);
        _builder.append(" && ");
      }
    }
    _builder.append("false == element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
    _builder.append(_throwIncorrectInputException, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence throwIncorrectInputException(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".ID, 0, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.osgi.util.NLS.bind(");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderIncorrectInputError(it));
    _builder.append(_accessorCall, "\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("new Object[] {element, ");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\"");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t\t\t");
        _builder.append("\", ");
      }
    }
    _builder.append("\"");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t\t\t");
    _builder.append("\"}), ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        _builder.append(" ");
        CharSequence _nonNLS_1 = this._common.nonNLS(2);
        _builder.append(_nonNLS_1, "\t\t\t");
      }
    }
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("null));");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence fileEditorInputClassFQName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.ui.part.FileEditorInput");
    return _builder;
  }
  
  public CharSequence uriEditorInputClassFQName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.common.ui.URIEditorInput");
    return _builder;
  }
  
  public CharSequence createDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument createDocument(Object element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkEditorInputInstance = this.checkEditorInputInstance(it);
    _builder.append(_checkEditorInputInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document = createEmptyDocument();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setDocumentContent(document, (org.eclipse.ui.IEditorInput) element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setupDocument(element, document);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return document;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setupDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      ((((("Sets up the given document as it would be provided for the given element. The\n" + 
        "content of the document is not changed. This default implementation is empty.\n") + 
        "Subclasses may reimplement.\n") + 
        "\n") + 
        "@param element the blue-print element\n") + 
        "@param document the document to set up"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setupDocument(Object element, org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// for subclasses");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence computeModificationStamp(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private long computeModificationStamp(ResourceSetInfo info) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int result = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (file.getLocation() != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("result += file.getLocation().toFile().lastModified();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("result += file.getModificationStamp();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("java.io.File file = getFile(nextResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file != null && file.exists()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("result += file.lastModified();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createEmptyDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument createEmptyDocument() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument document = new org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("document.setEditingDomain(createEditingDomain());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return document;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createEditingDomain(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.transaction.TransactionalEditingDomain createEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory.getInstance().createEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("editingDomain.setID(\"");
    String _editingDomainID = it.getEditingDomainID();
    _builder.append(_editingDomainID, "\t");
    _builder.append("\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final org.eclipse.emf.transaction.NotificationFilter diagramResourceModifiedFilter = org.eclipse.emf.transaction.NotificationFilter.createNotifierFilter(editingDomain.getResourceSet()).and(org.eclipse.emf.transaction.NotificationFilter.createEventTypeFilter(org.eclipse.emf.common.notify.Notification.ADD)).and(org.eclipse.emf.transaction.NotificationFilter.createFeatureFilter(org.eclipse.emf.ecore.resource.ResourceSet.class, org.eclipse.emf.ecore.resource.ResourceSet.RESOURCE_SET__RESOURCES));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("editingDomain.getResourceSet().eAdapters().add(new org.eclipse.emf.common.notify.Adapter() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.emf.common.notify.Notifier myTarger;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public org.eclipse.emf.common.notify.Notifier getTarget() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return myTarger;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public boolean isAdapterForType(Object type) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void notifyChanged(org.eclipse.emf.common.notify.Notification notification) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (diagramResourceModifiedFilter.matches(notification)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Object value = notification.getNewValue();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (value instanceof org.eclipse.emf.ecore.resource.Resource) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("((org.eclipse.emf.ecore.resource.Resource) value).setTrackingModification(true);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void setTarget(org.eclipse.emf.common.notify.Notifier newTarget) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("myTarger = newTarget;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editingDomain;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setDocumentContent(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setDocumentContent(org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, org.eclipse.ui.IEditorInput element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain domain = diagramDocument.getEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("if (element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IStorage storage = ((");
        CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName_1, "\t\t");
        _builder.append(") element).getStorage();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil.load(domain, storage, true, getProgressMonitor());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("document.setContent(diagram);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if(element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.common.util.URI uri = ((");
    CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName_1, "\t\t");
    _builder.append(") element).getURI();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("resource = domain.getResourceSet().getResource(uri.trimFragment(), false);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (resource == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("resource = domain.getResourceSet().createResource(uri.trimFragment());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!resource.isLoaded()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("java.util.Map options = new java.util.HashMap(org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory.getDefaultLoadOptions());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("// @see 171060 ");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("// options.put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("resource.load(options);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("resource.unload();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("throw e;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (uri.fragment() != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject rootElement = resource.getEObject(uri.fragment());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("document.setContent((org.eclipse.gmf.runtime.notation.Diagram) rootElement);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("for (java.util.Iterator it = resource.getContents().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("Object rootElement = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("document.setContent((org.eclipse.gmf.runtime.notation.Diagram) rootElement);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new RuntimeException(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderNoDiagramInResourceError(it));
    _builder.append(_accessorCall, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.runtime.CoreException thrownExcp = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (e instanceof org.eclipse.core.runtime.CoreException) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("thrownExcp = (org.eclipse.core.runtime.CoreException) e;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("String msg = e.getLocalizedMessage();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("thrownExcp = new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t\t");
    _builder.append(".ID, 0, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("msg != null ? msg : ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderDiagramLoadingError(it));
    _builder.append(_accessorCall_1, "\t\t\t\t");
    _builder.append(", e));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw thrownExcp;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
    _builder.append(_throwIncorrectInputException, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getModificationStamp(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public long getModificationStamp(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return computeModificationStamp(info);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getModificationStamp(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isDeleted(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isDeleted(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = getDiagramDocument(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (document != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource diagramResource = document.getDiagram().eResource();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (diagramResource != null) {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(diagramResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return file == null || file.getLocation() == null || !file.getLocation().toFile().exists();");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("java.io.File file = getFile(diagramResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return file != null && !file.exists();");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.isDeleted(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getResourceSetInfo(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ResourceSetInfo getResourceSetInfo(Object editorInput) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return (ResourceSetInfo) super.getElementInfo(editorInput);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence disposeElementInfo(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void disposeElementInfo(Object element, ElementInfo info) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info instanceof ResourceSetInfo) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ResourceSetInfo resourceSetInfo = (ResourceSetInfo) info;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("resourceSetInfo.dispose();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.disposeElementInfo(element, info);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doValidateState(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doValidateState(Object element, Object computationContext) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.resources.IFile> files2Validate = new java.util.LinkedList<org.eclipse.core.resources.IFile>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null && file.isReadOnly()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("files2Validate.add(file);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.resources.ResourcesPlugin.getWorkspace().validateEdit((org.eclipse.core.resources.IFile[]) files2Validate.toArray(new org.eclipse.core.resources.IFile[files2Validate.size()]), computationContext);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.doValidateState(element, computationContext);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isReadOnly(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isReadOnly(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _callUpdateCache = this.callUpdateCache(it);
    _builder.append(_callUpdateCache, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return info.isReadOnly();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.isReadOnly(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isModifiable(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isModifiable(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!isStateValidated(element)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t\t");
        _builder.append(" || ");
      }
    }
    _builder.append("element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _callUpdateCache = this.callUpdateCache(it);
    _builder.append(_callUpdateCache, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return info.isModifiable();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.isModifiable(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence callUpdateCache(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (info.isUpdateCache()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("updateCache(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (org.eclipse.core.runtime.CoreException ex) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().logError(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderIsModifiable(it));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(", ex);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// Error message to log was initially taken from org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages.StorageDocumentProvider_isModifiable");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence updateCache(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void updateCache(Object element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file != null && file.isReadOnly()) {");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("java.io.File file = getFile(nextResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file != null && file.exists() && !file.canWrite()) {");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t\t");
    _builder.append("info.setReadOnly(true);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("info.setModifiable(false);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("info.setReadOnly(false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("info.setModifiable(true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doUpdateStateCache(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doUpdateStateCache(Object element) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("info.setUpdateCache(true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.doUpdateStateCache(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSynchronized(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSynchronized(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return info.isSynchronized();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.isSynchronized(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getResetRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getResetRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSaveRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getSaveRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(computeSchedulingRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSynchronizeRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getSynchronizeRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(file));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getValidateStateRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.core.runtime.jobs.ISchedulingRule getValidateStateRule(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> files = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (file != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("files.add(file);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((org.eclipse.core.resources.IFile[]) files.toArray(new org.eclipse.core.resources.IFile[files.size()]));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence computeSchedulingRule(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.core.runtime.jobs.ISchedulingRule computeSchedulingRule(org.eclipse.core.resources.IResource toCreateOrModify) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (toCreateOrModify.exists())");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(toCreateOrModify);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IResource parent = toCreateOrModify;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("do {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* XXX This is a workaround for");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* https://bugs.eclipse.org/bugs/show_bug.cgi?id=67601");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* IResourceRuleFactory.createRule should iterate the hierarchy");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* itself.");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("toCreateOrModify = parent;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("parent = toCreateOrModify.getParent();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} while (parent != null && !parent.exists());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().createRule(toCreateOrModify);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doSynchronize(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doSynchronize(Object element, org.eclipse.core.runtime.IProgressMonitor monitor) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("handleElementChanged(info, nextResource, monitor);\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.doSynchronize(element, monitor);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleElementChanged(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void handleElementChanged(ResourceSetInfo info, org.eclipse.emf.ecore.resource.Resource changedResource, org.eclipse.core.runtime.IProgressMonitor monitor) {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(changedResource);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("file.refreshLocal(org.eclipse.core.resources.IResource.DEPTH_INFINITE, monitor);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("} catch (org.eclipse.core.runtime.CoreException ex) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName, "\t\t\t");
        _builder.append(".getInstance().logError(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentProviderHandleElementContentChanged(it));
        _builder.append(_accessorCall, "\t\t\t");
        _builder.append(", ex);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("// Error message to log was initially taken from org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages.FileDocumentProvider_handleElementContentChanged");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("changedResource.unload();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fireElementContentAboutToBeReplaced(info.getEditorInput());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("removeUnchangedElementListeners(info.getEditorInput(), info);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("info.fStatus = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setDocumentContent(info.fDocument, info.getEditorInput());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (org.eclipse.core.runtime.CoreException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("info.fStatus = e.getStatus();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!info.fCanBeSaved) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("info.setModificationStamp(computeModificationStamp(info));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("addUnchangedElementListeners(info.getEditorInput(), info);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fireElementContentReplaced(info.getEditorInput());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doSaveDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doSaveDocument(org.eclipse.core.runtime.IProgressMonitor monitor, Object element, org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, boolean overwrite) throws org.eclipse.core.runtime.CoreException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ResourceSetInfo info = getResourceSetInfo(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (info != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!overwrite && !info.isSynchronized()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".ID, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IResourceStatus.OUT_OF_SYNC_LOCAL");
      } else {
        _builder.append("org.eclipse.core.runtime.IStatus.ERROR");
      }
    }
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentUnsynchronizedFileSaveError(it));
    _builder.append(_accessorCall, "\t\t\t\t");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("null));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        _builder.append("\t");
        _builder.append("info.stopResourceListening();");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("fireElementStateChanging(element);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("monitor.beginTask(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveDiagramTask(it));
    _builder.append(_accessorCall_1, "\t\t\t");
    _builder.append(", info.getResourceSet().getResources().size() + 1); //\"Saving diagram\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("monitor.setTaskName(org.eclipse.osgi.util.NLS.bind(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveNextResourceTask(it));
    _builder.append(_accessorCall_2, "\t\t\t\t\t\t");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("nextResource.getURI()));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (nextResource.isLoaded() && !info.getEditingDomain().isReadOnly(nextResource)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("nextResource.save(");
    CharSequence _callGetSaveOptions = this.xptDiagramEditorUtil.callGetSaveOptions(it);
    _builder.append(_callGetSaveOptions, "\t\t\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t\t\t\t\t");
    _builder.append(".ID, org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorStatusCodes.RESOURCE_FAILURE, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("monitor.worked(1);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("monitor.done();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("info.setModificationStamp(computeModificationStamp(info));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (RuntimeException x) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw x;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} ");
    {
      GenApplication _application_2 = it.getEditorGen().getApplication();
      boolean _equals_2 = Objects.equal(null, _application_2);
      if (_equals_2) {
        _builder.append(" finally {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("info.startResourceListening();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} ");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.common.util.URI newResoruceURI;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.List<org.eclipse.core.resources.IFile> affectedFiles = null;");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenApplication _application_3 = it.getEditorGen().getApplication();
      boolean _equals_3 = Objects.equal(null, _application_3);
      if (_equals_3) {
        _builder.append("if (element instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile newFile = ((");
        CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName_1, "\t\t\t");
        _builder.append(") element).getFile();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("affectedFiles = java.util.Collections.singletonList(newFile);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("newResoruceURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(newFile.getFullPath().toString(), true);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if(element instanceof ");
    CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("newResoruceURI = ((");
    CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
    _builder.append(_uriEditorInputClassFQName_1, "\t\t\t");
    _builder.append(") element).getURI();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
    _builder.append(_throwIncorrectInputException, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (false == document instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_2, "\t\t\t");
    _builder.append(".ID, 0,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("\"Incorrect document used: \" + document + \" instead of org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument\", null)); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.append(" ");
    CharSequence _nonNLS_1 = this._common.nonNLS(2);
    _builder.append(_nonNLS_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.emf.ecore.resource.Resource newResource = diagramDocument.getEditingDomain().getResourceSet().createResource(newResoruceURI);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.gmf.runtime.notation.Diagram diagramCopy = (org.eclipse.gmf.runtime.notation.Diagram) org.eclipse.emf.ecore.util.EcoreUtil.copy(diagramDocument.getDiagram());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(diagramDocument.getEditingDomain(), org.eclipse.osgi.util.NLS.bind(");
    CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForDocumentSaveAs(it));
    _builder.append(_accessorCall_3, "\t\t\t");
    _builder.append(", diagramCopy.getName()), affectedFiles) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("newResource.getContents().add(diagramCopy);\t\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}.execute(monitor, null);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("newResource.save(");
    CharSequence _callGetSaveOptions_1 = this.xptDiagramEditorUtil.callGetSaveOptions(it);
    _builder.append(_callGetSaveOptions_1, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.core.commands.ExecutionException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_3, "\t\t\t");
    _builder.append(".ID, 0, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (java.io.IOException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementStateChangeFailed(element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
    CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_4, "\t\t\t");
    _builder.append(".ID, 0, e.getLocalizedMessage(), null));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("newResource.unload();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleElementMoved(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void handleElementMoved(org.eclipse.ui.IEditorInput input, org.eclipse.emf.common.util.URI uri) {");
    _builder.newLine();
    _builder.append("\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("if (input instanceof ");
        CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
        _builder.append(_fileEditorInputClassFQName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile newFile = org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot().getFile(new org.eclipse.core.runtime.Path(org.eclipse.emf.common.util.URI.decode(uri.path())).removeFirstSegments(1));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("fireElementMoved(input, newFile == null ? null : new org.eclipse.ui.part.FileEditorInput(newFile));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("// TODO: append suffix to the URI! (use diagram as a parameter)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fireElementMoved(input, new org.eclipse.emf.common.ui.URIEditorInput(uri));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createInputWithEditingDomain(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.IEditorInput createInputWithEditingDomain(org.eclipse.ui.IEditorInput editorInput, org.eclipse.emf.transaction.TransactionalEditingDomain domain) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editorInput;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDiagramDocument(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument getDiagramDocument(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument doc = getDocument(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (doc instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) doc;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getOperationRunner(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.jface.operation.IRunnableContext getOperationRunner(org.eclipse.core.runtime.IProgressMonitor monitor) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getFile(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.io.File getFile(org.eclipse.emf.ecore.resource.Resource resource) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.common.util.URI resourceUri = resource.getURI();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (resourceUri != null && resourceUri.isFile()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.io.File file = new java.io.File(resourceUri.toFileString());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!file.isDirectory()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return file;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForDocumentProviderIsModifiable(it));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentProviderHandleElementContentChanged(it));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentProviderIncorrectInputError(it));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentProviderNoDiagramInResourceError(it));
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentProviderDiagramLoadingError(it));
    _builder.append(_accessorField_4);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_5 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentUnsynchronizedFileSaveError(it));
    _builder.append(_accessorField_5);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_6 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentSaveDiagramTask(it));
    _builder.append(_accessorField_6);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_7 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentSaveNextResourceTask(it));
    _builder.append(_accessorField_7);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_8 = this.xptExternalizer.accessorField(this.i18nKeyForDocumentSaveAs(it));
    _builder.append(_accessorField_8);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentProviderIsModifiable(it), "Updating cache failed");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentProviderHandleElementContentChanged(it), "Failed to refresh hierarchy for changed resource");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    String _i18nKeyForDocumentProviderIncorrectInputError = this.i18nKeyForDocumentProviderIncorrectInputError(it);
    String _xifexpression = null;
    GenApplication _application = it.getEditorGen().getApplication();
    boolean _equals = Objects.equal(_application, null);
    if (_equals) {
      _xifexpression = "{1} or {2}";
    } else {
      _xifexpression = "{1}";
    }
    String _plus = ("Incorrect element used: {0} instead of " + _xifexpression);
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderIncorrectInputError, _plus);
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentProviderNoDiagramInResourceError(it), "Diagram is not present in resource");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentProviderDiagramLoadingError(it), "Error loading diagram");
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_5 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentUnsynchronizedFileSaveError(it), "The file has been changed on the file system");
    _builder.append(_messageEntry_5);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_6 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentSaveDiagramTask(it), "Saving diagram");
    _builder.append(_messageEntry_6);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_7 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentSaveNextResourceTask(it), "Saving {0}");
    _builder.append(_messageEntry_7);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_8 = this.xptExternalizer.messageEntry(this.i18nKeyForDocumentSaveAs(it), "Saving {0} diagram as");
    _builder.append(_messageEntry_8);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForDocumentProvider(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    return ("" + _className);
  }
  
  @Localization
  public String i18nKeyForDocumentProviderIsModifiable(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + "_isModifiable");
  }
  
  @Localization
  public String i18nKeyForDocumentProviderHandleElementContentChanged(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + "_handleElementContentChanged");
  }
  
  @Localization
  public String i18nKeyForDocumentProviderIncorrectInputError(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".IncorrectInputError");
  }
  
  @Localization
  public String i18nKeyForDocumentProviderNoDiagramInResourceError(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".NoDiagramInResourceError");
  }
  
  @Localization
  public String i18nKeyForDocumentProviderDiagramLoadingError(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".DiagramLoadingError");
  }
  
  @Localization
  public String i18nKeyForDocumentUnsynchronizedFileSaveError(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".UnsynchronizedFileSaveError");
  }
  
  @Localization
  public String i18nKeyForDocumentSaveDiagramTask(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".SaveDiagramTask");
  }
  
  @Localization
  public String i18nKeyForDocumentSaveNextResourceTask(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".SaveNextResourceTask");
  }
  
  @Localization
  public String i18nKeyForDocumentSaveAs(final GenDiagram diagram) {
    String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
    return (_i18nKeyForDocumentProvider + ".SaveAsOperation");
  }
}
