/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - [174961] migration to Commands/Handlers
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.actions;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.diagram.commands.CreateShortcutDecorationsCommand;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.ElementChooser;
import xpt.editor.ShortcutCreationWizard;

@Singleton
@SuppressWarnings("all")
public class CreateShortcutAction {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private ShortcutCreationWizard xptShortcutCreationWizard;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private CreateShortcutDecorationsCommand xptCreateShortcutDecorationCommand;
  
  @Inject
  private ElementChooser xptElementChooser;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  public CharSequence className(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    String _lastSegment = this._common_qvto.lastSegment(it.getQualifiedClassName());
    _builder.append(_lastSegment);
    return _builder;
  }
  
  public CharSequence packageName(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    String _withoutLastSegment = this._common_qvto.withoutLastSegment(it.getQualifiedClassName());
    _builder.append(_withoutLastSegment);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getOwner().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructors = this.constructors(it);
    _builder.append(_constructors, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createChooserDialog = this.createChooserDialog(it);
    _builder.append(_createChooserDialog, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createShortcutDecorationCommand = this.createShortcutDecorationCommand(it);
    _builder.append(_createShortcutDecorationCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.tooling.runtime.part.DefaultCreateShortcutHandler");
    return _builder;
  }
  
  public CharSequence implementsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence constructors(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getOwner().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().getLogHelper());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1);
    _builder.append("(org.eclipse.gmf.tooling.runtime.LogHelper logHelper) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(logHelper, ");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getOwner().getEditorGen());
    _builder.append(_preferenceHintAccess, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createShortcutDecorationCommand(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it.getOwner().getEditorGen().getDiagram());
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.core.command.ICommand createShortcutDecorationCommand(org.eclipse.gmf.runtime.notation.View view, org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain, java.util.List<org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor> descriptors) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    String _createShortcutDecorationsCommandQualifiedClassName = it.getOwner().getEditorGen().getDiagram().getCreateShortcutDecorationsCommandQualifiedClassName();
    _builder.append(_createShortcutDecorationsCommandQualifiedClassName, "\t");
    _builder.append("(editingDomain, view, descriptors);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createChooserDialog(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it.getOwner().getEditorGen().getDiagram());
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.tooling.runtime.part.DefaultElementChooserDialog createChooserDialog(org.eclipse.swt.widgets.Shell parentShell, org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    String _elementChooserQualifiedClassName = it.getOwner().getEditorGen().getDiagram().getElementChooserQualifiedClassName();
    _builder.append(_elementChooserQualifiedClassName, "\t");
    _builder.append("(parentShell, view);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _notEquals = (!Objects.equal(null, _application));
      if (_notEquals) {
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreateShortcutOpenModel()), "Select model to reference");
        _builder.append(_messageEntry);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreateShortcutWizard()), "Create shortcut");
        _builder.append(_messageEntry_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _notEquals = (!Objects.equal(null, _application));
      if (_notEquals) {
        CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreateShortcutOpenModel()));
        _builder.append(_accessorField);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreateShortcutWizard()));
        _builder.append(_accessorField_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Localization
  public String i18nKeyForCreateShortcutWizard() {
    return "CreateShortcutAction.Wizard";
  }
  
  @Localization
  public String i18nKeyForCreateShortcutOpenModel() {
    return "CreateShortcutAction.OpenModel";
  }
}
