/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.ProjectEditors;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class EnsureAPIAnalysisHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List<IProject> versionProjects = this.getAllVersionProjects();
        Job updateJob = new Job("Ensure API Analysis"){
            {
                super($anonymous0);
                this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }

            protected IStatus run(IProgressMonitor monitor) {
                Set<String> naturesToAdd = Collections.singleton("org.eclipse.pde.api.tools.apiAnalysisNature");
                Set<String> buildersToAdd = Collections.singleton("org.eclipse.pde.api.tools.apiAnalysisBuilder");
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating projects...", (int)versionProjects.size());
                versionProjects.forEach(project -> {
                    try {
                        if (sub.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProjectEditor projectEditor = ProjectEditors.getProjectEditor((IProject)project);
                        if (projectEditor.hasNature("org.eclipse.oomph.version.VersionNature")) {
                            projectEditor.addNatures(naturesToAdd);
                            projectEditor.addBuildCommands(buildersToAdd);
                            if (projectEditor.isDirty()) {
                                projectEditor.save();
                            }
                        }
                        sub.worked(1);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 2);
                    }
                });
                sub.done();
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProgressService progress = window.getWorkbench().getProgressService();
        progress.showInDialog(window.getShell(), updateJob);
        return null;
    }

    List<IProject> getAllVersionProjects() {
        return Stream.of(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(this::hasVersionNature).collect(Collectors.toList());
    }

    boolean hasVersionNature(IProject project) {
        boolean result = false;
        if (project.isAccessible()) {
            try {
                IProjectDescription desc = project.getDescription();
                List<String> natures = Arrays.asList(desc.getNatureIds());
                result = natures.contains("org.eclipse.oomph.version.VersionNature");
            }
            catch (CoreException e) {
                Activator.log.log(e.getStatus());
            }
        }
        return result;
    }
}

