/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.ui.CreateModelFragmentDialog;
import org.eclipse.swt.widgets.Shell;

public interface IControlModeFragmentDialogProvider {
    public static final IControlModeFragmentDialogProvider DEFAULT = new IControlModeFragmentDialogProvider(){

        @Override
        public Dialog createDialog(Shell shell, Resource parentUnit, String defaultUnitName) {
            return new CreateModelFragmentDialog(shell, parentUnit, defaultUnitName);
        }

        @Override
        public Dialog createDialog(Shell shell, EObject objectToControl, String defaultUnitName) {
            return new CreateModelFragmentDialog(shell, objectToControl, defaultUnitName);
        }

        @Override
        public URI getSelectedURI(Dialog dialog) {
            return this.cast(dialog).map(CreateModelFragmentDialog::getURI).orElse(null);
        }

        Optional<CreateModelFragmentDialog> cast(Dialog dialog) {
            return Optional.of(dialog).filter(d -> d.getReturnCode() == 0).filter(CreateModelFragmentDialog.class::isInstance).map(CreateModelFragmentDialog.class::cast);
        }

        @Override
        public ControlModeRequest getControlRequest(Dialog dialog, TransactionalEditingDomain domain, EObject objectToControl) {
            ControlModeRequest result = IControlModeFragmentDialogProvider.super.getControlRequest(dialog, domain, objectToControl);
            this.cast(dialog).ifPresent(d -> result.setParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.CreateShard", d.isCreateShard()));
            return result;
        }
    };

    @Deprecated
    public Dialog createDialog(Shell var1, Resource var2, String var3);

    default public Dialog createDialog(Shell shell, EObject objectToControl, String defaultUnitName) {
        return this.createDialog(shell, objectToControl.eResource(), defaultUnitName);
    }

    public URI getSelectedURI(Dialog var1);

    default public ControlModeRequest getControlRequest(Dialog dialog, TransactionalEditingDomain domain, EObject objectToControl) {
        return ControlModeRequest.createUIControlModelRequest(domain, objectToControl, this.getSelectedURI(dialog));
    }
}

