/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingStyledLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileResourceLabelProvider
extends DelegatingStyledLabelProvider {
    private final ResourceSet resourceSet;

    public ProfileResourceLabelProvider(ResourceSet resourceSet) {
        super((ILabelProvider)new WorkbenchLabelProvider());
        this.resourceSet = resourceSet;
    }

    protected Image customGetImage(Object element) {
        Image result = null;
        if (element instanceof Resource) {
            element = ((Resource)element).getURI();
        }
        if (element instanceof URI) {
            URI uri = (URI)element;
            IRegisteredProfile registered = this.getRegisteredProfile(uri);
            if (registered != null) {
                result = registered.getImage();
            } else if (uri.isPlatformResource()) {
                IResource file = !uri.isPlatformResource() ? null : ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
                result = this.delegatedGetImage(file);
            }
        }
        return result;
    }

    public StyledString customGetStyledText(Object element) {
        return element instanceof IFile ? this.getStyledText((IFile)element) : (element instanceof Resource ? this.getStyledText((Resource)element) : (element instanceof URI ? this.getStyledText((URI)element) : null));
    }

    protected StyledString getStyledText(Resource resource) {
        StyledString result;
        Package model;
        URI uri = resource.getURI();
        Package package_ = model = resource.isLoaded() ? (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE) : null;
        if (model == null) {
            result = this.getStyledText(uri);
        } else if (uri.isPlatformResource()) {
            result = new StyledString();
            result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)model));
            String qualifier = uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toString();
            result.append(" - " + qualifier, StyledString.QUALIFIER_STYLER);
        } else {
            result = this.getStyledText(UMLLabelInternationalization.getInstance().getLabel((NamedElement)model), resource.getURI());
        }
        return result;
    }

    protected StyledString getStyledText(String modelName, URI uri) {
        StyledString result = new StyledString();
        result.append(modelName);
        String qualifier = uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toString();
        result.append(" - " + qualifier, StyledString.QUALIFIER_STYLER);
        return result;
    }

    protected StyledString getStyledText(IFile file) {
        StyledString result = new StyledString();
        IPath path = file.getFullPath().removeFileExtension();
        result.append(path.lastSegment());
        result.append(" - " + path.removeLastSegments(1).toString(), StyledString.QUALIFIER_STYLER);
        return result;
    }

    protected IRegisteredProfile getRegisteredProfile(URI uri) {
        IRegisteredProfile result = null;
        for (IRegisteredProfile next : Registry.getRegisteredProfiles()) {
            if (!uri.equals(next.getUri())) continue;
            result = next;
            break;
        }
        return result;
    }

    protected StyledString getStyledText(URI uri) {
        StyledString result;
        IRegisteredProfile registered = this.getRegisteredProfile(uri);
        if (registered != null) {
            result = this.getStyledText(registered.getName(), uri);
        } else {
            Resource resource;
            Resource resource2 = resource = this.resourceSet == null ? null : this.resourceSet.getResource(uri, false);
            if (resource != null && resource.isLoaded()) {
                result = this.getStyledText(resource);
            } else {
                IResource file = !uri.isPlatformResource() ? null : ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
                result = file instanceof IFile ? this.getStyledText((IFile)file) : this.getStyledText(Messages.ProfileResourceLabelProvider_0, uri);
            }
        }
        return result;
    }
}

