/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - [407242] - common code extracted to gmft.runtime,
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.propsheet;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class PropertySection {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private CodeStyle xptCodeStyle;
  
  public CharSequence className(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getSheet().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence PropertySection(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getSheet().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsClause = this.implementsClause(it);
    _builder.append(_implementsClause);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _isReadOnly = it.getSheet().isReadOnly();
      if (_isReadOnly) {
        _builder.append("\t");
        CharSequence _createReadonlyControlsMethod = this.createReadonlyControlsMethod(it);
        _builder.append(_createReadonlyControlsMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _transfromSelectionMethod = this.transfromSelectionMethod(it);
    _builder.append(_transfromSelectionMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.tooling.runtime.sheet.DefaultPropertySection");
    return _builder;
  }
  
  public CharSequence implementsClause(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.views.properties.IPropertySourceProvider");
    return _builder;
  }
  
  public CharSequence createReadonlyControlsMethod(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void createControls(org.eclipse.swt.widgets.Composite parent, org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage aTabbedPropertySheetPage) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.createControls(parent, aTabbedPropertySheetPage);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("forcePageReadOnly();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence transfromSelectionMethod(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _iD = it.getID();
      boolean _equals = Objects.equal("domain", _iD);
      if (_equals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Modify/unwrap selection.");
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this.xptCodeStyle.overrideC(it.getSheet().getEditorGen().getDiagram());
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected Object transformSelection(Object selected) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _transfromSelectionMethodBodyDefault = this.transfromSelectionMethodBodyDefault(it);
        _builder.append(_transfromSelectionMethodBodyDefault, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return selected;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence transfromSelectionMethodBodyDefault(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("selected = /*super.*/transformSelectionToDomain(selected);");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * DEFINE's below are not supported anymore (code moved to superclass in 3.1).
   * If your xpt version have them, call it from custom version of additions
   * <p>
   * def dispatch getPropertySourceMethod(GenCustomPropertyTab it) ''''''
   * def dispatch getPropertySourceProviderMethod(GenCustomPropertyTab it) ''''''
   * def dispatch setInputMethod(GenCustomPropertyTab it) ''''''
   * def dispatch getAdapterFactoryMethod(GenCustomPropertyTab it) ''''''
   */
  public CharSequence additions(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
