/**
 * Copyright (c) 2011, 2013 Montages AG
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - initial API and implementation, migration to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts.viewmaps;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.top.Descriptor;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.Connection;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramElement;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.papyrus.gmf.gmfgraph.Node;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class modeledViewmapProducer {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private BareFigure_qvto _bareFigure_qvto;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  @Inject
  private Descriptor xptDescriptor;
  
  public CharSequence viewmapFigureFQN(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _figureFQN = this.figureFQN(it.getFigureModel());
    _builder.append(_figureFQN);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _figureFQN(final EObject it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown figureModel: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _figureFQN(final DiagramLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((Objects.equal(it.getFigure(), null) || Objects.equal(it.getFigure().getActualFigure(), null))) {
        _builder.append("org.eclipse.draw2d.Label");
      } else {
        ChildAccess _accessor = it.getAccessor();
        boolean _equals = Objects.equal(_accessor, null);
        if (_equals) {
          CharSequence _fqn = this.xptRuntime.fqn(it.getFigure().getActualFigure());
          _builder.append(_fqn);
        } else {
          CharSequence _fqn_1 = this.xptRuntime.fqn(it.getAccessor().getFigure());
          _builder.append(_fqn_1);
        }
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _figureFQN(final Node it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _nodeOrLinkFQN = this.nodeOrLinkFQN(it);
    _builder.append(_nodeOrLinkFQN);
    return _builder;
  }
  
  protected CharSequence _figureFQN(final Connection it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _nodeOrLinkFQN = this.nodeOrLinkFQN(it);
    _builder.append(_nodeOrLinkFQN);
    return _builder;
  }
  
  public CharSequence nodeOrLinkFQN(final DiagramElement it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((Objects.equal(it.getFigure(), null) || Objects.equal(it.getFigure().getActualFigure(), null))) {
        _builder.append("org.eclipse.draw2d.RoundedRectangle");
      } else {
        boolean _isBareFigureDescriptor = this._bareFigure_qvto.isBareFigureDescriptor(it.getFigure());
        if (_isBareFigureDescriptor) {
          CharSequence _fqn = this.xptRuntime.fqn(it.getFigure().getActualFigure());
          _builder.append(_fqn);
        } else {
          String _firstUpper = StringExtensions.toFirstUpper(it.getFigure().getName());
          _builder.append(_firstUpper);
        }
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence viewmapClassBody(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _classBody = this.classBody(it.getFigureModel());
    _builder.append(_classBody);
    return _builder;
  }
  
  protected CharSequence _classBody(final EObject it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown figureModel: " + it));
    return _builder;
  }
  
  protected CharSequence _classBody(final DiagramElement it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((Objects.equal(it.getFigure(), null) || Objects.equal(it.getFigure().getActualFigure(), null)) || this._bareFigure_qvto.isBareFigureDescriptor(it.getFigure()))) {
      } else {
        CharSequence _Inner = this.xptDescriptor.Inner(it.getFigure());
        _builder.append(_Inner);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence figureFQN(final EObject it) {
    if (it instanceof DiagramLabel) {
      return _figureFQN((DiagramLabel)it);
    } else if (it instanceof Node) {
      return _figureFQN((Node)it);
    } else if (it instanceof Connection) {
      return _figureFQN((Connection)it);
    } else if (it != null) {
      return _figureFQN(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence classBody(final EObject it) {
    if (it instanceof DiagramElement) {
      return _classBody((DiagramElement)it);
    } else if (it != null) {
      return _classBody(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
