/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;

public class ArchitectureFileChecker
implements IPluginChecker {
    private final IFile architectureFile;
    private final Resource resource;

    public ArchitectureFileChecker(IFile architectureFile, Resource resource) {
        this.architectureFile = architectureFile;
        this.resource = resource;
    }

    public void check(IProgressMonitor monitor) {
        Diagnostic diagnostic;
        EObject root;
        if (monitor != null) {
            monitor.subTask("Validate architecture file '" + this.architectureFile.getName() + "'.");
        }
        if ((root = (EObject)this.resource.getContents().get(0)) != null && (diagnostic = Diagnostician.INSTANCE.validate(root)).getSeverity() != 0) {
            for (Diagnostic child : diagnostic.getChildren()) {
                int severity = child.getSeverity() == 4 ? 2 : (child.getSeverity() == 2 ? 1 : 0);
                MarkersService.createMarker((IResource)this.architectureFile, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", (String)child.getMessage(), (int)severity);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

