/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.GenAuditRoot_qvto;
import xpt.providers.MarkerNavigationProvider;
import xpt.providers.ValidationDecoratorProvider;
import xpt.providers.ValidationProvider;

@Singleton
@SuppressWarnings("all")
public class ValidateAction {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private GenAuditRoot_qvto _genAuditRoot_qvto;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private ValidationMarker xptValidationMarker;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  @Inject
  private ValidationProvider xptValidationProvider;
  
  @Inject
  private MarkerNavigationProvider xptMarkerNavigationProvider;
  
  @Inject
  private ValidationDecoratorProvider xptValidationDecoratorProvider;
  
  @MetaDef
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ValidateAction");
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.jface.action.Action");
    return _builder;
  }
  
  public CharSequence ValidateAction(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _run = this.run(it);
    _builder.append(_run, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _runValidation = this.runValidation(it);
    _builder.append(_runValidation, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _runNonUIValidation = this.runNonUIValidation(it);
    _builder.append(_runNonUIValidation, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _runValidationWithEP = this.runValidationWithEP(it);
    _builder.append(_runValidationWithEP, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _runEMFValidator = this.runEMFValidator(it);
    _builder.append(_runEMFValidator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _validate = this.validate(it);
    _builder.append(_validate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createMarkersForStatus = this.createMarkersForStatus(it);
    _builder.append(_createMarkersForStatus, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createMarkersForDiagnostic = this.createMarkersForDiagnostic(it);
    _builder.append(_createMarkersForDiagnostic, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _addMarker = this.addMarker(it);
    _builder.append(_addMarker, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _diagnosticToStatusSeverity = this.diagnosticToStatusSeverity(it);
    _builder.append(_diagnosticToStatusSeverity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _collectTargetElementsFromStatus = this.collectTargetElementsFromStatus(it);
    _builder.append(_collectTargetElementsFromStatus, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _collectTargetElementsFromDiagnostic = this.collectTargetElementsFromDiagnostic(it);
    _builder.append(_collectTargetElementsFromDiagnostic, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.ui.IWorkbenchPage page;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.ui.IWorkbenchPage page) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("setText(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)));
    _builder.append(_accessorCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.page = page;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence run(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IWorkbenchPart workbenchPart = page.getActivePart();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (workbenchPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart part =\t(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) workbenchPart;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("\t\t\t");
        _builder.append("new org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation(");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.jface.operation.IRunnableWithProgress() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("public void run(org.eclipse.core.runtime.IProgressMonitor monitor)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("throws InterruptedException, java.lang.reflect.InvocationTargetException {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("runValidation(part.getDiagramEditPart(), part.getDiagram());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(_application_1, null);
      if (_equals_1) {
        _builder.append("\t\t\t");
        _builder.append(")");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append(".run(new org.eclipse.core.runtime.NullProgressMonitor());\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".getInstance().logError(\"Validation action failed\", e); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence runValidation(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static void runValidation(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (");
    CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".openDiagram(view.eResource())) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ui.IEditorPart editorPart = org.eclipse.ui.PlatformUI.getWorkbench()");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".getActiveWorkbenchWindow().getActivePage().getActiveEditor();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (editorPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("runValidation(((org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) editorPart).");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("getDiagramEditPart(), view);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("runNonUIValidation(view);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"Validation action failed\", e); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence runNonUIValidation(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static void runNonUIValidation(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory.getInstance().createDiagramEditPart(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("view.getDiagram());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("runValidation(diagramEditPart, view);");
    _builder.newLine();
    _builder.append("}\t\t");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence runValidationWithEP(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static void runValidation(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart fpart = diagramEditPart;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.gmf.runtime.notation.View fview = view;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain txDomain = org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(view);");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptValidationProvider.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".runWithConstraints(txDomain, new Runnable() {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("validate(fpart, fview);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence runEMFValidator(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static org.eclipse.emf.common.util.Diagnostic runEMFValidator(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View target) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (target.isSetElement() && target.getElement() != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.emf.ecore.util.Diagnostician() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getObjectLabel(org.eclipse.emf.ecore.EObject eObject) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(eObject, true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}.validate(target.getElement());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.emf.common.util.Diagnostic.OK_INSTANCE;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence validate(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static void validate(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.core.resources.IFile target = view.eResource() != null ?");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(view.eResource()) : null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (target != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
        _builder.append(_qualifiedClassName, "\t\t");
        _builder.append(".deleteMarkers(target);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View target = view;");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_1, "\t");
        _builder.append(".removeAllMarkers(diagramEditPart.getViewer());");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("org.eclipse.emf.common.util.Diagnostic diagnostic = runEMFValidator(view);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("createMarkers(target, diagnostic, diagramEditPart);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.validation.service.IBatchValidator validator =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(org.eclipse.emf.validation.service.IBatchValidator)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.validation.service.ModelValidationService.getInstance().newValidator(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.validation.model.EvaluationMode.BATCH);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("validator.setIncludeLiveConstraints(true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (view.isSetElement() && view.getElement() != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.runtime.IStatus status = validator.validate(view.getElement());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("createMarkers(target, status, diagramEditPart);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      boolean _shouldRunValidateOnDiagram = this._genAuditRoot_qvto.shouldRunValidateOnDiagram(it.getEditorGen().getAudits());
      if (_shouldRunValidateOnDiagram) {
        {
          boolean _hasDiagramElementTargetRule = this._genAuditRoot_qvto.hasDiagramElementTargetRule(it.getEditorGen().getAudits());
          if (_hasDiagramElementTargetRule) {
            _builder.append("\t");
            _builder.append("validator.setTraversalStrategy(");
            CharSequence _qualifiedClassName_2 = this.xptValidationProvider.qualifiedClassName(it);
            _builder.append(_qualifiedClassName_2, "\t");
            _builder.append(".getNotationTraversalStrategy(validator));");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("org.eclipse.core.runtime.IStatus status = validator.validate(view);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("createMarkers(target, status, diagramEditPart);");
        _builder.newLine();
      }
    }
    {
      if (((!Objects.equal(it.getEditorGen().getApplication(), null)) && it.isValidationDecorators())) {
        _builder.append("\t");
        CharSequence _qualifiedClassName_3 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_3, "\t");
        _builder.append(".refreshDecorators(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator it = view.eAllContents(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject next = (org.eclipse.emf.ecore.EObject) it.next();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (next instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_4 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_4, "\t\t\t");
        _builder.append(".refreshDecorators(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View) next);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createMarkersForStatus(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static void createMarkers(");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IFile");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
      } else {
        _builder.append("org.eclipse.gmf.runtime.notation.View");
      }
    }
    _builder.append(" target,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IStatus validationStatus,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (validationStatus.isOK()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.core.runtime.IStatus rootStatus = validationStatus;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.List allStatuses = new java.util.ArrayList();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".LazyElement2ViewMap element2ViewMap = new ");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(".LazyElement2ViewMap(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramEditPart.getDiagramView(),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("collectTargetElements(rootStatus, new java.util.HashSet<org.eclipse.emf.ecore.EObject>(), allStatuses));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = allStatuses.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.validation.model.IConstraintStatus nextStatus =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(org.eclipse.emf.validation.model.IConstraintStatus) it.next();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = ");
    CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(".findView(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("diagramEditPart, nextStatus.getTarget(), element2ViewMap);\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view), ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(nextStatus.getTarget(), true), ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("nextStatus.getMessage(), nextStatus.getSeverity());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createMarkersForDiagnostic(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static void createMarkers(");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IFile");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
      } else {
        _builder.append("org.eclipse.gmf.runtime.notation.View");
      }
    }
    _builder.append(" target,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.common.util.Diagnostic emfValidationStatus,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (emfValidationStatus.getSeverity() == org.eclipse.emf.common.util.Diagnostic.OK) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.emf.common.util.Diagnostic rootStatus = emfValidationStatus;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.List allDiagnostics = new java.util.ArrayList();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".LazyElement2ViewMap element2ViewMap =");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("new ");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(".LazyElement2ViewMap(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramEditPart.getDiagramView(),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("collectTargetElements(rootStatus, new java.util.HashSet<org.eclipse.emf.ecore.EObject>(), allDiagnostics));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = emfValidationStatus.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.common.util.Diagnostic nextDiagnostic = (org.eclipse.emf.common.util.Diagnostic) it.next();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.List data = nextDiagnostic.getData();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject element = (org.eclipse.emf.ecore.EObject) data.get(0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = ");
    CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(".findView(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramEditPart, element, element2ViewMap);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(element, true),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("nextDiagnostic.getMessage(), diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addMarker(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static void addMarker(org.eclipse.gef.EditPartViewer viewer,");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IFile");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
      } else {
        _builder.append("org.eclipse.gmf.runtime.notation.View");
      }
    }
    _builder.append(" target,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("String elementId, String location, String message, int statusSeverity) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (target == null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(_application_1, null);
      if (_equals_1) {
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".addMarker(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("target, elementId, location, message, statusSeverity);");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("new ");
        CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_1, "\t");
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("location, message, statusSeverity).add(viewer, elementId);");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence diagnosticToStatusSeverity(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static int diagnosticToStatusSeverity(int diagnosticSeverity) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.OK) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.runtime.IStatus.OK;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.INFO) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.runtime.IStatus.INFO;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.WARNING) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.core.runtime.IStatus.WARNING;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.ERROR");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("|| diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.CANCEL) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.core.runtime.IStatus.ERROR;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.core.runtime.IStatus.INFO;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence collectTargetElementsFromStatus(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.core.runtime.IStatus status,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List allConstraintStatuses) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (status instanceof org.eclipse.emf.validation.model.IConstraintStatus) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("targetElementCollector.add(((org.eclipse.emf.validation.model.IConstraintStatus) status).getTarget());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("allConstraintStatuses.add(status);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (status.isMultiStatus()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.runtime.IStatus[] children = status.getChildren();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (int i = 0; i < children.length; i++) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);\t\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return targetElementCollector;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence collectTargetElementsFromDiagnostic(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.emf.common.util.Diagnostic diagnostic,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List allDiagnostics) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.List data = diagnostic.getData();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject target = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("target = (org.eclipse.emf.ecore.EObject) data.get(0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("targetElementCollector.add(target);\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("allDiagnostics.add(diagnostic);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = diagnostic.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("collectTargetElements((org.eclipse.emf.common.util.Diagnostic) it.next(),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("targetElementCollector, allDiagnostics);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return targetElementCollector;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)), "Validate");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForValidateAction(it)));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForValidateAction(final GenDiagram diagram) {
    return this.className(diagram).toString();
  }
}
