/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.Activator;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesExternalDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesFileChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ElementTypesPluginChecker {
    public static void checkElementTypesPlugin(IProject project) {
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                Collection elementTypesFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)"elementtypesconfigurations", (boolean)true);
                monitor.beginTask("Validate Element Types plug-in", 1 + elementTypesFiles.size() * 3);
                monitor.subTask("Prepare plug-in validation");
                MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic");
                PluginValidationService pluginValidationService = new PluginValidationService();
                pluginValidationService.addPluginChecker((IPluginChecker)new ElementTypesDependenciesChecker(project));
                for (IFile elementTypesFile : elementTypesFiles) {
                    URI elementTypesFileURI = URI.createPlatformResourceURI((String)elementTypesFile.getFullPath().toOSString(), (boolean)true);
                    Resource resource = new ResourceSetImpl().getResource(elementTypesFileURI, true);
                    pluginValidationService.addPluginChecker((IPluginChecker)new ElementTypesFileChecker(elementTypesFile, resource));
                    pluginValidationService.addPluginChecker((IPluginChecker)new ElementTypesExtensionsChecker(project, elementTypesFile));
                    pluginValidationService.addPluginChecker((IPluginChecker)new ElementTypesExternalDependenciesChecker(project, elementTypesFile, resource));
                }
                monitor.worked(1);
                pluginValidationService.validate(monitor);
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

