/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.editor;

import aspects.xpt.editor.DiagramEditorUtil;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.DiagramContentInitializer;
import xpt.editor.ModelElementSelectionPage;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class NewDiagramFileWizard extends xpt.editor.NewDiagramFileWizard {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private DiagramContentInitializer xptDiagramContentInitializer;
  
  @Inject
  private ModelElementSelectionPage xptModelElementSelectionPage;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Override
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), "Initialize new diagram file");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), "Diagram file");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), 
      "Create new diagram based on {0} model content");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), 
      "Select diagram root element");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), "Diagram root element");
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_5 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), 
      "Select semantic model element to be depicted on diagram");
    _builder.append(_messageEntry_5);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_6 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(it), 
      "Select diagram root element:");
    _builder.append(_messageEntry_6);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_7 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(it), 
      "Diagram root element is not selected");
    _builder.append(_messageEntry_7);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_8 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(it), 
      "Invalid diagram root element is selected");
    _builder.append(_messageEntry_8);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_9 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardInitDiagramCommand(it), "Initializing diagram contents");
    _builder.append(_messageEntry_9);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_10 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardIncorrectRootError(it), 
      "Incorrect model object stored as a root resource object");
    _builder.append(_messageEntry_10);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence NewDiagramFileWizard(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.jface.wizard.Wizard {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private ");
    CharSequence _creationPage = this.creationPage(it);
    _builder.append(_creationPage, "\t");
    _builder.append(" myFileCreationPage;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private ");
    CharSequence _qualifiedClassName = this.xptModelElementSelectionPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" diagramRootElementSelectionPage;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.emf.transaction.TransactionalEditingDomain myEditingDomain;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(org.eclipse.emf.common.util.URI domainModelURI,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject diagramRoot,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence __assert = this._common._assert("domainModelURI != null : \"Domain model uri must be specified\"");
    _builder.append(__assert, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t    ");
    CharSequence __assert_1 = this._common._assert("diagramRoot != null : \"Doagram root element must be specified\"");
    _builder.append(__assert_1, "\t    ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t    ");
    CharSequence __assert_2 = this._common._assert("editingDomain != null : \"Editing domain must be specified\"");
    _builder.append(__assert_2, "\t    ");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myFileCreationPage = new ");
    CharSequence _creationPage_1 = this.creationPage(it);
    _builder.append(_creationPage_1, "\t\t");
    _builder.append("(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(", org.eclipse.jface.viewers.StructuredSelection.EMPTY);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("myFileCreationPage.setTitle(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
    _builder.append(_accessorCall_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("myFileCreationPage.setDescription(org.eclipse.osgi.util.NLS.bind(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
    _builder.append(_accessorCall_2, "\t\t\t\t");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _modelID = aspects.xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t\t\t\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IPath filePath;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String fileName = org.eclipse.emf.common.util.URI.decode(domainModelURI.trimFileExtension().lastSegment());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (domainModelURI.isPlatformResource()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("filePath = new org.eclipse.core.runtime.Path(domainModelURI.trimSegments(1).toPlatformString(true));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (domainModelURI.isFile()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("filePath = new org.eclipse.core.runtime.Path(domainModelURI.trimSegments(1).toFileString());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// TODO : use some default path");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new IllegalArgumentException(\"Unsupported URI: \" + domainModelURI); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myFileCreationPage.setContainerFullPath(filePath);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myFileCreationPage.setFileName(");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getUniqueFileName(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("filePath, fileName, \"");
    String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
    _builder.append(_diagramFileExtension, "\t\t\t\t");
    _builder.append("\")); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(");
    CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
    _builder.append(_accessorCall_3, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramRootElementSelectionPage.setTitle(");
    CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
    _builder.append(_accessorCall_4, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramRootElementSelectionPage.setDescription(");
    CharSequence _accessorCall_5 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
    _builder.append(_accessorCall_5, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramRootElementSelectionPage.setModelElement(diagramRoot);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t   \t");
    _builder.append("myEditingDomain = editingDomain;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void addPages() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("addPage(myFileCreationPage);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("addPage(diagramRootElementSelectionPage);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean performFinish() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.resources.IFile> affectedFiles = new java.util.LinkedList<org.eclipse.core.resources.IFile>(); ");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.resources.IFile diagramFile = myFileCreationPage.createNewFile();");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _callSetCharset = this.xptDiagramEditorUtil.callSetCharset(it, "diagramFile");
        _builder.append(_callSetCharset, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("affectedFiles.add(diagramFile);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.common.util.URI diagramModelURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(diagramFile.getFullPath().toString(), true);");
        _builder.newLine();
      } else {
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.runtime.IPath diagramModelPath = myFileCreationPage.getContainerFullPath().append(myFileCreationPage.getFileName());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.common.util.URI diagramModelURI = org.eclipse.emf.common.util.URI.createFileURI(diagramModelPath.toString());");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.ResourceSet resourceSet = myEditingDomain.getResourceSet();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.emf.ecore.resource.Resource diagramResource = resourceSet.createResource(diagramModelURI);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand command =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("myEditingDomain, ");
    CharSequence _accessorCall_6 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardInitDiagramCommand(it));
    _builder.append(_accessorCall_6, "\t\t\t\t");
    _builder.append(", affectedFiles) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("String diagramVID = ");
    CharSequence _diagramVisualIDMethodCall = this.xptVisualIDRegistry.getDiagramVisualIDMethodCall(it);
    _builder.append(_diagramVisualIDMethodCall, "\t\t\t\t");
    _builder.append("(diagramRootElementSelectionPage.getModelElement());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("if (diagramVID.equals(");
    CharSequence _visualID = aspects.xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t\t");
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newErrorCommandResult(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    CharSequence _accessorCall_7 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardIncorrectRootError(it));
    _builder.append(_accessorCall_7, "\t\t\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram =");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.services.ViewService.createDiagram(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("diagramRootElementSelectionPage.getModelElement(), ");
    CharSequence _modelID_1 = aspects.xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID_1, "\t\t\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess, "\t\t\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("diagramResource.getContents().add(diagram);");
    _builder.newLine();
    {
      boolean _isSameFileForDiagramAndModel = it.getEditorGen().isSameFileForDiagramAndModel();
      if (_isSameFileForDiagramAndModel) {
        _builder.append("\t\t\t\t");
        _builder.append("diagramResource.getContents().add(diagram.getElement());");
        _builder.newLine();
      }
    }
    {
      boolean _isSynchronized = it.isSynchronized();
      boolean _not = (!_isSynchronized);
      if (_not) {
        _builder.append("\t\t\t\t");
        _builder.append("new ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramContentInitializer.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_2, "\t\t\t\t");
        _builder.append("().initDiagramContent(diagram);\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.commands.operations.OperationHistoryFactory.getOperationHistory().execute(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("command, new org.eclipse.core.runtime.NullProgressMonitor(), null);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("diagramResource.save(");
    CharSequence _callGetSaveOptions = this.xptDiagramEditorUtil.callGetSaveOptions(it);
    _builder.append(_callGetSaveOptions, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_3 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_3, "\t\t\t");
    _builder.append(".openDiagram(diagramResource);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.core.commands.ExecutionException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_4, "\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"Unable to create model and diagram\", e); ");
    CharSequence _nonNLS_2 = this._common.nonNLS(1);
    _builder.append(_nonNLS_2, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (java.io.IOException ex) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_5 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_5, "\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"Save operation failed for: \" + diagramModelURI, ex); ");
    CharSequence _nonNLS_3 = this._common.nonNLS(1);
    _builder.append(_nonNLS_3, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException ex) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_6 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_6, "\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"Unable to open editor\", ex); ");
    CharSequence _nonNLS_4 = this._common.nonNLS(1);
    _builder.append(_nonNLS_4, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static class DiagramRootElementSelectionPage extends ");
    CharSequence _qualifiedClassName_7 = this.xptModelElementSelectionPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_7, "\t");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("protected DiagramRootElementSelectionPage(String pageName) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super(pageName);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("protected String getSelectionTitle() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return ");
    CharSequence _accessorCall_8 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(it));
    _builder.append(_accessorCall_8, "\t\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("protected boolean validatePage() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (getModelElement() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setErrorMessage(");
    CharSequence _accessorCall_9 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this.i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(it));
    _builder.append(_accessorCall_9, "\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("boolean result = org.eclipse.gmf.runtime.diagram.core.services.ViewService.getInstance().provides(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(getModelElement()),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _modelID_2 = aspects.xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID_2, "\t\t\t\t\t");
    _builder.append(", ");
    CharSequence _preferenceHintAccess_1 = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess_1, "\t\t\t\t\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("setErrorMessage(result ? null : ");
    CharSequence _accessorCall_10 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this.i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(it));
    _builder.append(_accessorCall_10, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
