/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bpc.profile;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Block;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Collection;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Connector;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Port;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Relation;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BlockOperations {
    public static EList<Port> getPort(Block block) {
        UniqueEList portList = new UniqueEList();
        if (block.getBase_Class() != null) {
            for (org.eclipse.uml2.uml.Port port : block.getBase_Class().getOwnedPorts()) {
                Port service = (Port)UMLUtil.getStereotypeApplication((Element)port, Port.class);
                if (service == null) continue;
                portList.add((Object)service);
            }
        }
        return portList;
    }

    public static EList<Connector> getConnector(Block block) {
        UniqueEList connectorList = new UniqueEList();
        if (block.getBase_Class() != null) {
            for (org.eclipse.uml2.uml.Connector umlConnector : block.getBase_Class().getOwnedConnectors()) {
                Connector connector;
                if (umlConnector == null || (connector = (Connector)UMLUtil.getStereotypeApplication((Element)umlConnector, Connector.class)) == null) continue;
                connectorList.add((Object)connector);
            }
        }
        return connectorList;
    }

    public static EList<Collection> getCollection(Block block) {
        UniqueEList collectionList = new UniqueEList();
        if (block.getBase_Class() != null) {
            for (Classifier cl : block.getBase_Class().getNestedClassifiers()) {
                Collection collection;
                if (cl == null || (collection = (Collection)UMLUtil.getStereotypeApplication((Element)cl, Collection.class)) == null) continue;
                collectionList.add((Object)collection);
            }
        }
        return collectionList;
    }

    public static EList<Block> getBlock(Block block) {
        UniqueEList blockList = new UniqueEList();
        if (block.getBase_Class() != null) {
            for (Classifier cl : block.getBase_Class().getNestedClassifiers()) {
                if (cl == null) continue;
                Block nestedBlock = (Block)UMLUtil.getStereotypeApplication((Element)cl, Block.class);
                if (block == null) continue;
                blockList.add((Object)nestedBlock);
            }
        }
        return blockList;
    }

    public static EList<Relation> getRelation(Block block) {
        UniqueEList relationList = new UniqueEList();
        if (block.getBase_Class() != null) {
            for (DirectedRelationship dr : block.getBase_Class().getSourceDirectedRelationships()) {
                Relation relation;
                if (dr == null || (relation = (Relation)UMLUtil.getStereotypeApplication((Element)dr, Relation.class)) == null) continue;
                relationList.add((Object)relation);
            }
        }
        return relationList;
    }
}

