/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.jnr;

import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.eclipse.papyrus.moka.fmi.master.jnr.FMI2Callbacks;

public class FMI2AllocatorImpl
implements FMI2Callbacks.FMI2AllocateMemory {
    private List<Pointer> allocatedPointers = new ArrayList<Pointer>();

    @Override
    public Pointer call(int numberOfObjects, int size) {
        Pointer pointer = Memory.allocateDirect((Runtime)Runtime.getSystemRuntime(), (int)(numberOfObjects * size), (boolean)true);
        this.allocatedPointers.add(pointer);
        return pointer;
    }

    public void releasePointer(Pointer pointer) {
        ArrayList<Pointer> pointersToRemove = new ArrayList<Pointer>();
        if (pointer.isDirect()) {
            for (Pointer allocPointer : this.allocatedPointers) {
                if (pointer.address() != allocPointer.address()) continue;
                pointersToRemove.add(allocPointer);
            }
        }
        this.allocatedPointers.removeAll(pointersToRemove);
    }
}

